/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Span;
import brave.internal.IpLiteral;
import brave.internal.Nullable;
import java.util.ArrayList;
import java.util.Locale;

public final class MutableSpan
implements Cloneable {
    Span.Kind kind;
    boolean shared;
    long startTimestamp;
    long finishTimestamp;
    String name;
    String remoteServiceName;
    String remoteIp;
    int remotePort;
    ArrayList<String> tags = new ArrayList();
    ArrayList<Object> annotations;

    @Nullable
    public String name() {
        return this.name;
    }

    public void name(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.name = name;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long finishTimestamp() {
        return this.finishTimestamp;
    }

    public void finishTimestamp(long finishTimestamp) {
        this.finishTimestamp = finishTimestamp;
    }

    public Span.Kind kind() {
        return this.kind;
    }

    public void kind(Span.Kind kind) {
        if (kind == null) {
            throw new NullPointerException("kind == null");
        }
        this.kind = kind;
    }

    @Nullable
    public String remoteServiceName() {
        return this.remoteServiceName;
    }

    public void remoteServiceName(String remoteServiceName) {
        if (remoteServiceName == null || remoteServiceName.isEmpty()) {
            throw new NullPointerException("remoteServiceName is empty");
        }
        this.remoteServiceName = remoteServiceName.toLowerCase(Locale.ROOT);
    }

    @Nullable
    public String remoteIp() {
        return this.remoteIp;
    }

    public int remotePort() {
        return this.remotePort;
    }

    public boolean remoteIpAndPort(@Nullable String remoteIp, int remotePort) {
        if (remoteIp == null) {
            return false;
        }
        this.remoteIp = IpLiteral.ipOrNull(remoteIp);
        if (this.remoteIp == null) {
            return false;
        }
        if (remotePort > 65535) {
            throw new IllegalArgumentException("invalid port " + remotePort);
        }
        if (remotePort < 0) {
            remotePort = 0;
        }
        this.remotePort = remotePort;
        return true;
    }

    public void annotate(long timestamp, String value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (timestamp == 0L) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(timestamp);
        this.annotations.add(value);
    }

    public void tag(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key is empty");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        int length = this.tags.size();
        for (int i = 0; i < length; i += 2) {
            if (!key.equals(this.tags.get(i))) continue;
            this.tags.set(i + 1, value);
            return;
        }
        this.tags.add(key);
        this.tags.add(value);
    }

    public <T> void forEachTag(TagConsumer<T> tagConsumer, T target) {
        int length = this.tags.size();
        for (int i = 0; i < length; i += 2) {
            tagConsumer.accept(target, this.tags.get(i), this.tags.get(i + 1));
        }
    }

    public <T> void forEachAnnotation(AnnotationConsumer<T> annotationConsumer, T target) {
        if (this.annotations == null) {
            return;
        }
        int length = this.annotations.size();
        for (int i = 0; i < length; i += 2) {
            long timestamp = (Long)this.annotations.get(i);
            annotationConsumer.accept(target, timestamp, this.annotations.get(i + 1).toString());
        }
    }

    public boolean shared() {
        return this.shared;
    }

    public void setShared() {
        this.shared = true;
    }

    public static interface AnnotationConsumer<T> {
        public void accept(T var1, long var2, String var4);
    }

    public static interface TagConsumer<T> {
        public void accept(T var1, String var2, String var3);
    }
}

