/*
 * Decompiled with CFR 0.152.
 */
package brave.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Lists {
    static List<Object> ensureMutable(List<Object> list) {
        if (list instanceof ArrayList) {
            return list;
        }
        int size = list.size();
        ArrayList<Object> mutable = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            mutable.add(list.get(i));
        }
        return mutable;
    }

    public static List<Object> ensureImmutable(List<Object> extra) {
        if (Lists.isImmutable(extra)) {
            return extra;
        }
        if (extra.size() == 1) {
            return Collections.singletonList(extra.get(0));
        }
        return Collections.unmodifiableList(new ArrayList<Object>(extra));
    }

    static boolean isImmutable(List<Object> extra) {
        if (extra == Collections.EMPTY_LIST) {
            return true;
        }
        String simpleName = extra.getClass().getSimpleName();
        return simpleName.equals("SingletonList") || simpleName.startsWith("Unmodifiable") || simpleName.contains("Immutable");
    }

    public static List<Object> concatImmutableLists(List<Object> left, List<Object> right) {
        int i;
        int leftSize = left.size();
        if (leftSize == 0) {
            return right;
        }
        int rightSize = right.size();
        if (rightSize == 0) {
            return left;
        }
        ArrayList<Object> mutable = new ArrayList<Object>();
        for (i = 0; i < leftSize; ++i) {
            mutable.add(left.get(i));
        }
        for (i = 0; i < rightSize; ++i) {
            mutable.add(right.get(i));
        }
        return Collections.unmodifiableList(mutable);
    }

    Lists() {
    }
}

