/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.util.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterSchema;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterService;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.receiver.core.EventReceiverDeployer;
import org.wso2.carbon.event.receiver.core.InputMapper;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverStreamValidationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverValidationException;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.type.json.JSONInputMapperConfigurationBuilder;
import org.wso2.carbon.event.receiver.core.internal.type.map.MapInputMappingConfigBuilder;
import org.wso2.carbon.event.receiver.core.internal.type.text.TextInputMapperConfigurationBuilder;
import org.wso2.carbon.event.receiver.core.internal.type.wso2event.WSO2EventInputMapperConfigurationBuilder;
import org.wso2.carbon.event.receiver.core.internal.type.xml.XMLInputMapperConfigrationBuilder;

public class EventReceiverConfigurationHelper {
    private static final Log log = LogFactory.getLog(EventReceiverConfigurationHelper.class);

    public static String getInputMappingType(OMElement eventReceiverOMElement) {
        OMElement mappingElement = eventReceiverOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "mapping"));
        return mappingElement.getAttributeValue(new QName("type"));
    }

    public static String getEventReceiverName(OMElement eventReceiverOMElement) {
        return eventReceiverOMElement.getAttributeValue(new QName("name"));
    }

    public static EventReceiverDeployer getEventReceiverDeployer(AxisConfiguration axisConfiguration) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfiguration.getConfigurator();
        return (EventReceiverDeployer)deploymentEngine.getDeployer("eventreceivers", "xml");
    }

    public static Attribute[] getAttributes(List<InputMappingAttribute> inputMappingAttributes) {
        ArrayList<Attribute> metaAttributes = new ArrayList<Attribute>();
        ArrayList<Attribute> correlationAttributes = new ArrayList<Attribute>();
        ArrayList<Attribute> payloadAttributes = new ArrayList<Attribute>();
        for (InputMappingAttribute inputMappingAttribute : inputMappingAttributes) {
            if (inputMappingAttribute.getToElementKey().startsWith("meta_")) {
                metaAttributes.add(new Attribute(inputMappingAttribute.getToElementKey(), inputMappingAttribute.getToElementType()));
                continue;
            }
            if (inputMappingAttribute.getToElementKey().startsWith("correlation_")) {
                correlationAttributes.add(new Attribute(inputMappingAttribute.getToElementKey(), inputMappingAttribute.getToElementType()));
                continue;
            }
            payloadAttributes.add(new Attribute(inputMappingAttribute.getToElementKey(), inputMappingAttribute.getToElementType()));
        }
        Attribute[] outputAttributes = new Attribute[metaAttributes.size() + correlationAttributes.size() + payloadAttributes.size()];
        int attributeCount = 0;
        for (Attribute attribute : metaAttributes) {
            outputAttributes[attributeCount++] = attribute;
        }
        for (Attribute attribute : correlationAttributes) {
            outputAttributes[attributeCount++] = attribute;
        }
        for (Attribute attribute : payloadAttributes) {
            outputAttributes[attributeCount++] = attribute;
        }
        return outputAttributes;
    }

    public static void validateEventReceiverConfiguration(OMElement eventReceiverOMElement) throws EventReceiverConfigurationException {
        if (!eventReceiverOMElement.getLocalName().equals("eventReceiver")) {
            throw new EventReceiverConfigurationException("Invalid event receiver configuration.");
        }
        if (eventReceiverOMElement.getAttributeValue(new QName("name")) == null || eventReceiverOMElement.getAttributeValue(new QName("name")).trim().isEmpty()) {
            throw new EventReceiverConfigurationException("Need to have an eventReceiver name");
        }
        String eventReceiverName = eventReceiverOMElement.getAttributeValue(new QName("name"));
        Iterator childElements = eventReceiverOMElement.getChildElements();
        int count = 0;
        while (childElements.hasNext()) {
            ++count;
            childElements.next();
        }
        if (count != 3) {
            throw new EventReceiverConfigurationException("Not a valid configuration, Event Receiver Configuration can only contains 3 child tags (From,Mapping & To), for " + eventReceiverName);
        }
        OMElement fromElement = eventReceiverOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        OMElement mappingElement = eventReceiverOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "mapping"));
        OMElement toElement = eventReceiverOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        if (fromElement == null || mappingElement == null || toElement == null) {
            throw new EventReceiverConfigurationException("Invalid event receiver configuration for event receiver: " + eventReceiverName);
        }
        Iterator fromPropertyIter = eventReceiverOMElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        OMElement fromPropertyOMElement = null;
        count = 0;
        while (fromPropertyIter.hasNext()) {
            fromPropertyOMElement = (OMElement)fromPropertyIter.next();
            ++count;
        }
        if (count != 1) {
            throw new EventReceiverConfigurationException("There can be only one 'From' element in Event Receiver configuration file.");
        }
        String fromEventAdapterType = fromPropertyOMElement.getAttributeValue(new QName("eventAdapterType"));
        if (fromEventAdapterType == null || fromEventAdapterType.isEmpty()) {
            throw new EventReceiverConfigurationException("There should be a event adapter type in Receiver configuration file.");
        }
        if (!EventReceiverConfigurationHelper.validateFromPropertyConfiguration(fromElement, fromEventAdapterType)) {
            throw new EventReceiverConfigurationException("From property does not contains all the required values for event adapter type " + fromEventAdapterType);
        }
        Iterator mappingPropertyIter = eventReceiverOMElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "mapping"));
        OMElement mappingPropertyOMElement = null;
        count = 0;
        while (mappingPropertyIter.hasNext()) {
            mappingPropertyOMElement = (OMElement)mappingPropertyIter.next();
            ++count;
        }
        if (count != 1) {
            throw new EventReceiverConfigurationException("There can be only one 'Mapping' element in Event Receiver configuration " + eventReceiverName);
        }
        String mappingType = mappingPropertyOMElement.getAttributeValue(new QName("type"));
        if (mappingType == null || mappingType.isEmpty()) {
            throw new EventReceiverConfigurationException("There should be proper mapping type in Event Receiver configuration " + eventReceiverName);
        }
        EventReceiverConfigurationHelper.validateMappingProperties(mappingElement, mappingType);
        Iterator toPropertyIter = eventReceiverOMElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        OMElement toPropertyOMElement = null;
        count = 0;
        while (toPropertyIter.hasNext()) {
            toPropertyOMElement = (OMElement)toPropertyIter.next();
            ++count;
        }
        if (count != 1) {
            throw new EventReceiverConfigurationException("There can be only one 'To' element in Event Receiver configuration " + eventReceiverName);
        }
        String toStreamName = toPropertyOMElement.getAttributeValue(new QName("streamName"));
        String toStreamVersion = toPropertyOMElement.getAttributeValue(new QName("version"));
        if (toStreamName == null || toStreamName.isEmpty() || toStreamVersion == null || toStreamVersion.isEmpty()) {
            throw new EventReceiverConfigurationException("There should be stream name and version in the 'To' element, of " + eventReceiverName);
        }
    }

    private static boolean validateFromPropertyConfiguration(OMElement fromElement, String fromEventAdapterType) {
        ArrayList<String> requiredProperties = new ArrayList<String>();
        ArrayList<String> propertiesInConfig = new ArrayList<String>();
        Iterator toElementPropertyIterator = fromElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "property"));
        InputEventAdapterService eventAdapterService = EventReceiverServiceValueHolder.getInputEventAdapterService();
        InputEventAdapterSchema adapterSchema = eventAdapterService.getInputEventAdapterSchema(fromEventAdapterType);
        if (adapterSchema == null) {
            throw new EventReceiverValidationException("Event Adapter with type: " + fromEventAdapterType + " does not exist", fromEventAdapterType);
        }
        List propertyList = adapterSchema.getPropertyList();
        if (propertyList != null) {
            for (Property property : propertyList) {
                if (!property.isRequired()) continue;
                requiredProperties.add(property.getPropertyName());
            }
            while (toElementPropertyIterator.hasNext()) {
                OMElement toElementProperty = (OMElement)toElementPropertyIterator.next();
                String propertyName = toElementProperty.getAttributeValue(new QName("name"));
                propertiesInConfig.add(propertyName);
            }
            if (!propertiesInConfig.containsAll(requiredProperties)) {
                return false;
            }
        }
        return true;
    }

    public static void validateMappingProperties(OMElement mappingElement, String mappingType) throws EventReceiverConfigurationException {
        if (mappingType.equalsIgnoreCase("wso2event")) {
            WSO2EventInputMapperConfigurationBuilder.validateWso2EventMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("text")) {
            TextInputMapperConfigurationBuilder.validateTextMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("map")) {
            MapInputMappingConfigBuilder.validateMapEventMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("xml")) {
            XMLInputMapperConfigrationBuilder.validateXMLEventMapping(mappingElement);
        } else if (mappingType.equalsIgnoreCase("json")) {
            JSONInputMapperConfigurationBuilder.validateJsonEventMapping(mappingElement);
        } else {
            log.info((Object)("No validations available for input mapping type :" + mappingType));
        }
    }

    public static void validateExportedStream(EventReceiverConfiguration eventReceiverConfiguration, StreamDefinition exportedStreamDefinition, InputMapper inputMapper) {
        if (eventReceiverConfiguration != null && exportedStreamDefinition != null && eventReceiverConfiguration.getInputMapping().isCustomMappingEnabled()) {
            List payloadAttributeList;
            List correlationAttributeList;
            String streamId = exportedStreamDefinition.getStreamId();
            if (inputMapper.getOutputAttributes() == null || inputMapper.getOutputAttributes().length == 0) {
                throw new EventReceiverStreamValidationException("The input mapper is not exporting any output attributes for stream " + streamId);
            }
            ArrayList<Attribute> outputAttributes = new ArrayList<Attribute>(Arrays.asList(inputMapper.getOutputAttributes()));
            List metaAttributeList = exportedStreamDefinition.getMetaData();
            if (metaAttributeList != null) {
                for (Attribute attribute : metaAttributeList) {
                    Attribute prependedAttribute = new Attribute("meta_" + attribute.getName(), attribute.getType());
                    if (!outputAttributes.contains(prependedAttribute)) {
                        throw new EventReceiverStreamValidationException("The meta data attribute '" + attribute.getName() + "' in stream '" + streamId + "' cannot be found under attributes exported by this event receiver mapping", streamId);
                    }
                    outputAttributes.remove(prependedAttribute);
                }
            }
            if ((correlationAttributeList = exportedStreamDefinition.getCorrelationData()) != null) {
                for (Attribute attribute : correlationAttributeList) {
                    Attribute prependedAttribute = new Attribute("correlation_" + attribute.getName(), attribute.getType());
                    if (!outputAttributes.contains(prependedAttribute)) {
                        throw new EventReceiverStreamValidationException("The correlation data attribute '" + attribute.getName() + "' in stream '" + streamId + "' cannot be found under attributes exported by this event receiver mapping", streamId);
                    }
                    outputAttributes.remove(prependedAttribute);
                }
            }
            if ((payloadAttributeList = exportedStreamDefinition.getPayloadData()) != null) {
                for (Attribute attribute : payloadAttributeList) {
                    if (!outputAttributes.contains(attribute)) {
                        throw new EventReceiverStreamValidationException("The payload data attribute '" + attribute.getName() + "' in stream '" + streamId + "' cannot be found under attributes exported by this event receiver mapping", streamId);
                    }
                    outputAttributes.remove(attribute);
                }
            }
            if (outputAttributes.size() > 0) {
                throw new EventReceiverStreamValidationException("The attribute '" + ((Attribute)outputAttributes.get(0)).getName() + "' exported by this event receiver mapping cannot be found not in '" + streamId + "'", streamId);
            }
        }
    }

    public static boolean validateEncryptedProperties(OMElement eventAdapterConfigOMElement) {
        String adaptorType = eventAdapterConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from")).getAttributeValue(new QName("eventAdapterType"));
        List<String> encryptedProperties = EventReceiverServiceValueHolder.getCarbonEventReceiverService().getEncryptedProperties(adaptorType);
        Iterator propertyIter = eventAdapterConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from")).getChildrenWithName(new QName("property"));
        while (propertyIter.hasNext()) {
            OMElement propertyOMElement = (OMElement)propertyIter.next();
            String name = propertyOMElement.getAttributeValue(new QName("name"));
            String value = propertyOMElement.getText();
            if (!encryptedProperties.contains(name.trim())) continue;
            OMAttribute encryptedAttribute = propertyOMElement.getAttribute(new QName("encrypted"));
            if (value == null || value.length() <= 0 || encryptedAttribute != null && "true".equals(encryptedAttribute.getAttributeValue())) continue;
            return false;
        }
        return true;
    }
}

