/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.util.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.event.input.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.receiver.core.EventReceiverDeployer;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfigurationFile;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;
import org.wso2.carbon.event.receiver.core.internal.util.XmlFormatter;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;

public class EventReceiverConfigurationFileSystemInvoker {
    private static final Log log = LogFactory.getLog(EventReceiverConfigurationFileSystemInvoker.class);

    public static void encryptAndSave(OMElement eventAdaptorElement, String fileName) throws EventReceiverConfigurationException {
        String adaptorType = eventAdaptorElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from")).getAttributeValue(new QName("eventAdapterType"));
        List<String> encryptedProperties = EventReceiverServiceValueHolder.getCarbonEventReceiverService().getEncryptedProperties(adaptorType);
        Iterator propertyIter = eventAdaptorElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from")).getChildrenWithName(new QName("property"));
        if (propertyIter.hasNext()) {
            while (propertyIter.hasNext()) {
                OMAttribute encryptedAttribute;
                OMElement propertyOMElement = (OMElement)propertyIter.next();
                String name = propertyOMElement.getAttributeValue(new QName("name"));
                if (!encryptedProperties.contains(name.trim()) || (encryptedAttribute = propertyOMElement.getAttribute(new QName("encrypted"))) != null && "true".equals(encryptedAttribute.getAttributeValue())) continue;
                String value = propertyOMElement.getText();
                try {
                    value = new String(CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(value.getBytes()));
                    propertyOMElement.setText(value);
                    propertyOMElement.addAttribute("encrypted", "true", null);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to decrypt the encrypted field: " + name + " for adaptor type: " + adaptorType + ". Hence, setting \"\" (empty string) as the property value"), (Throwable)e);
                    propertyOMElement.setText("");
                }
            }
        }
        EventReceiverConfigurationFileSystemInvoker.save(eventAdaptorElement, fileName);
    }

    public static void save(OMElement eventReceiverConfigOMElement, String fileName) throws EventReceiverConfigurationException {
        EventReceiverConfigurationFileSystemInvoker.saveAndDeploy(eventReceiverConfigOMElement.toString(), fileName);
    }

    public static void saveAndDeploy(String eventReceiverConfigXml, String fileName) throws EventReceiverConfigurationException {
        EventReceiverDeployer eventReceiverDeployer = EventReceiverConfigurationHelper.getEventReceiverDeployer(EventAdapterUtil.getAxisConfiguration());
        EventReceiverUtil.validateFilePath(fileName);
        String filePath = EventReceiverConfigurationFileSystemInvoker.getFilePathFromFilename(fileName);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(filePath));){
            String xmlContent = XmlFormatter.format(eventReceiverConfigXml);
            eventReceiverDeployer.getDeployedEventReceiverFilePaths().add(filePath);
            out.write(xmlContent);
            out.close();
            log.info((Object)("Event receiver configuration saved to the filesystem :" + fileName));
            DeploymentFileData deploymentFileData = new DeploymentFileData(new File(filePath));
            eventReceiverDeployer.executeManualDeployment(deploymentFileData);
        }
        catch (IOException e) {
            eventReceiverDeployer.getDeployedEventReceiverFilePaths().remove(filePath);
            log.error((Object)("Error while saving event receiver configuration: " + fileName), (Throwable)e);
        }
    }

    public static void delete(String fileName) throws EventReceiverConfigurationException {
        try {
            EventReceiverUtil.validateFilePath(fileName);
            String filePath = EventReceiverConfigurationFileSystemInvoker.getFilePathFromFilename(fileName);
            File file = new File(filePath);
            String filename = file.getName();
            if (file.exists()) {
                EventReceiverDeployer eventReceiverDeployer = EventReceiverConfigurationHelper.getEventReceiverDeployer(EventAdapterUtil.getAxisConfiguration());
                eventReceiverDeployer.getUndeployedEventReceiverFilePaths().add(filePath);
                boolean fileDeleted = file.delete();
                if (!fileDeleted) {
                    log.error((Object)("Could not delete " + filename));
                    eventReceiverDeployer.getUndeployedEventReceiverFilePaths().remove(filePath);
                } else {
                    log.info((Object)("Event receiver configuration deleted from the file system :" + filename));
                    eventReceiverDeployer.executeManualUndeployment(filePath);
                }
            }
        }
        catch (Exception e) {
            throw new EventReceiverConfigurationException("Error while deleting the event receiver :" + e.getMessage(), e);
        }
    }

    public static boolean isFileExists(String fileName) throws EventReceiverConfigurationException {
        EventReceiverUtil.validateFilePath(fileName);
        String filePath = EventReceiverConfigurationFileSystemInvoker.getFilePathFromFilename(fileName);
        File file = new File(filePath);
        return file.exists();
    }

    public static String readEventReceiverConfigurationFile(String fileName) throws EventReceiverConfigurationException {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            EventReceiverUtil.validateFilePath(fileName);
            String filePath = EventReceiverConfigurationFileSystemInvoker.getFilePathFromFilename(fileName);
            bufferedReader = new BufferedReader(new FileReader(filePath));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new EventReceiverConfigurationException("Event receiver file not found : " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EventReceiverConfigurationException("Cannot read the event receiver file : " + e.getMessage(), e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when reading the file : " + e.getMessage()), (Throwable)e);
            }
        }
        return stringBuilder.toString().trim();
    }

    public static void reload(EventReceiverConfigurationFile eventReceiverConfigurationFile, Map<Integer, EventReceiverDeployer> tenantSpecificDeployerMap) throws EventReceiverConfigurationException {
        EventReceiverUtil.validateFilePath(eventReceiverConfigurationFile.getFileName());
        String filePath = eventReceiverConfigurationFile.getFilePath();
        EventReceiverDeployer deployer = tenantSpecificDeployerMap.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true));
        try {
            deployer.processUndeployment(filePath);
            deployer.processDeployment(new DeploymentFileData(new File(filePath)));
        }
        catch (DeploymentException e) {
            throw new EventReceiverConfigurationException(e);
        }
    }

    private static String getFilePathFromFilename(String filename) {
        return new File(EventAdapterUtil.getAxisConfiguration().getRepository().getPath()).getAbsolutePath() + File.separator + "eventreceivers" + File.separator + filename;
    }
}

