/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.InputMapping;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;

public class EventReceiverUtil {
    private static final String JVM_BIT_ARCH_SYSTEM_PROPERTY = "sun.arch.data.model";
    private static int referenceSize;
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static final Log log;

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static Object getConvertedAttributeObject(String value, AttributeType type) {
        switch (type) {
            case INT: {
                return Integer.valueOf(value);
            }
            case LONG: {
                return Long.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case BOOL: {
                return Boolean.valueOf(value);
            }
        }
        return value;
    }

    public static String getExportedStreamIdFrom(EventReceiverConfiguration eventReceiverConfiguration) {
        String streamId = null;
        if (eventReceiverConfiguration != null && eventReceiverConfiguration.getToStreamName() != null && !eventReceiverConfiguration.getToStreamName().isEmpty()) {
            streamId = eventReceiverConfiguration.getToStreamName() + ":" + (eventReceiverConfiguration.getToStreamVersion() != null && !eventReceiverConfiguration.getToStreamVersion().isEmpty() ? eventReceiverConfiguration.getToStreamVersion() : "1.0.0");
        }
        return streamId;
    }

    public static boolean isMetaAttribute(String attributeName) {
        return attributeName != null && attributeName.startsWith("meta_");
    }

    public static boolean isCorrelationAttribute(String attributeName) {
        return attributeName != null && attributeName.startsWith("correlation_");
    }

    public static Attribute[] getOrderedAttributeArray(InputMapping inputMapping) {
        List<InputMappingAttribute> orderedInputMappingAttributes = EventReceiverUtil.sortInputMappingAttributes(inputMapping.getInputMappingAttributes());
        int currentCount = 0;
        int totalAttributeCount = orderedInputMappingAttributes.size();
        Attribute[] attributeArray = new Attribute[totalAttributeCount];
        for (InputMappingAttribute inputMappingAttribute : orderedInputMappingAttributes) {
            attributeArray[currentCount++] = new Attribute(inputMappingAttribute.getToElementKey(), inputMappingAttribute.getToElementType());
        }
        return attributeArray;
    }

    public static List<InputMappingAttribute> sortInputMappingAttributes(List<InputMappingAttribute> inputMappingAttributes) {
        ArrayList<InputMappingAttribute> metaAttributes = new ArrayList<InputMappingAttribute>();
        ArrayList<InputMappingAttribute> correlationAttributes = new ArrayList<InputMappingAttribute>();
        ArrayList<InputMappingAttribute> payloadAttributes = new ArrayList<InputMappingAttribute>();
        for (InputMappingAttribute inputMappingAttribute : inputMappingAttributes) {
            if (inputMappingAttribute.getToElementKey().startsWith("meta_")) {
                metaAttributes.add(inputMappingAttribute);
                continue;
            }
            if (inputMappingAttribute.getToElementKey().startsWith("correlation_")) {
                correlationAttributes.add(inputMappingAttribute);
                continue;
            }
            payloadAttributes.add(inputMappingAttribute);
        }
        ArrayList<InputMappingAttribute> orderedInputMappingAttributes = new ArrayList<InputMappingAttribute>();
        orderedInputMappingAttributes.addAll(metaAttributes);
        orderedInputMappingAttributes.addAll(correlationAttributes);
        orderedInputMappingAttributes.addAll(payloadAttributes);
        return orderedInputMappingAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateFilePath(String eventReceiverName, String repositoryPath) throws EventReceiverConfigurationException {
        String path;
        File subDir;
        File repoDir = new File(repositoryPath);
        if (!repoDir.exists()) {
            String string = repositoryPath.intern();
            synchronized (string) {
                if (!repoDir.exists() && !repoDir.mkdir()) {
                    throw new EventReceiverConfigurationException("Cannot create directory to add tenant specific event receiver :" + eventReceiverName);
                }
            }
        }
        if (!(subDir = new File(path = repoDir.getAbsolutePath() + File.separator + "eventreceivers")).exists()) {
            String string = path.intern();
            synchronized (string) {
                if (!subDir.exists() && !subDir.mkdir()) {
                    throw new EventReceiverConfigurationException("Cannot create directory eventreceivers to add tenant specific event receiver :" + eventReceiverName);
                }
            }
        }
        return subDir.getAbsolutePath() + File.separator + eventReceiverName + ".xml";
    }

    public static Attribute[] streamDefinitionToAttributeArray(StreamDefinition streamDefinition) {
        int size = 0;
        if (streamDefinition.getMetaData() != null) {
            size += streamDefinition.getMetaData().size();
        }
        if (streamDefinition.getCorrelationData() != null) {
            size += streamDefinition.getCorrelationData().size();
        }
        if (streamDefinition.getPayloadData() != null) {
            size += streamDefinition.getPayloadData().size();
        }
        Attribute[] attributes = new Attribute[size];
        int index = 0;
        if (streamDefinition.getMetaData() != null) {
            for (Attribute attribute : streamDefinition.getMetaData()) {
                attributes[index] = new Attribute("meta_" + attribute.getName(), attribute.getType());
                ++index;
            }
        }
        if (streamDefinition.getCorrelationData() != null) {
            for (Attribute attribute : streamDefinition.getCorrelationData()) {
                attributes[index] = new Attribute("correlation_" + attribute.getName(), attribute.getType());
                ++index;
            }
        }
        if (streamDefinition.getPayloadData() != null) {
            for (Attribute attribute : streamDefinition.getPayloadData()) {
                attributes[index] = new Attribute(attribute.getName(), attribute.getType());
                ++index;
            }
        }
        return attributes;
    }

    public static int getAttributePosition(String attributeName, StreamDefinition streamDefinition) {
        block6: {
            List payloadData;
            int correlationAttributeSize;
            int metaAttributeSize;
            block8: {
                List correlationData;
                block7: {
                    if (streamDefinition == null) break block6;
                    metaAttributeSize = 0;
                    correlationAttributeSize = 0;
                    List metaData = streamDefinition.getMetaData();
                    correlationData = streamDefinition.getCorrelationData();
                    payloadData = streamDefinition.getPayloadData();
                    if (metaData != null) {
                        metaAttributeSize = metaData.size();
                    }
                    if (correlationData != null) {
                        correlationAttributeSize = correlationData.size();
                    }
                    if (!attributeName.startsWith("meta_")) break block7;
                    if (metaData == null) break block6;
                    for (int i = 0; i < metaAttributeSize; ++i) {
                        if (!((Attribute)metaData.get(i)).getName().equals(attributeName.substring("meta_".length()))) continue;
                        return i;
                    }
                    break block6;
                }
                if (!attributeName.startsWith("correlation_")) break block8;
                if (correlationData == null) break block6;
                for (int i = 0; i < correlationAttributeSize; ++i) {
                    if (!((Attribute)correlationData.get(i)).getName().equals(attributeName.substring("correlation_".length()))) continue;
                    return metaAttributeSize + i;
                }
                break block6;
            }
            if (payloadData != null) {
                for (int i = 0; i < payloadData.size(); ++i) {
                    if (!((Attribute)payloadData.get(i)).getName().equals(attributeName)) continue;
                    return metaAttributeSize + correlationAttributeSize + i;
                }
            }
        }
        return -1;
    }

    public static int getSize(Event event) {
        int size = 8;
        size += EventReceiverUtil.getSize(event.getStreamId());
        if (event.getMetaData() != null) {
            size += EventReceiverUtil.getSize(event.getMetaData());
        }
        if (event.getCorrelationData() != null) {
            size += EventReceiverUtil.getSize(event.getCorrelationData());
        }
        if (event.getPayloadData() != null) {
            size += EventReceiverUtil.getSize(event.getPayloadData());
        }
        size += referenceSize;
        if (event.getArbitraryDataMap() != null) {
            size += EventReceiverUtil.getSize(event.getArbitraryDataMap());
        }
        return size;
    }

    private static int getSize(Object[] objects) {
        int size = 0;
        for (Object object : objects) {
            if (object == null) continue;
            if (object instanceof Integer) {
                size += 4;
                continue;
            }
            if (object instanceof Long) {
                size += 8;
                continue;
            }
            if (object instanceof Boolean) {
                ++size;
                continue;
            }
            if (object instanceof Double) {
                size += 8;
                continue;
            }
            if (object instanceof Float) {
                size += 4;
                continue;
            }
            if (!(object instanceof String)) continue;
            size += EventReceiverUtil.getSize(object.toString());
        }
        return size += referenceSize * objects.length;
    }

    public static int getSize(String value) {
        int size = 0;
        if (value != null) {
            try {
                size = value.getBytes("UTF8").length;
            }
            catch (UnsupportedEncodingException e) {
                size = value.getBytes().length;
            }
        }
        return size;
    }

    private static int getSize(Map<String, String> arbitraryDataMap) {
        int size = 0;
        if (arbitraryDataMap != null) {
            for (Map.Entry<String, String> entry : arbitraryDataMap.entrySet()) {
                size += EventReceiverUtil.getSize(entry.getKey());
                size += EventReceiverUtil.getSize(entry.getValue());
                size += referenceSize * 2;
            }
        }
        return size;
    }

    public static String getMappedInputStreamAttributeName(String toStreamAttributeName, InputMapping inputMapping) {
        for (InputMappingAttribute inputMappingAttribute : inputMapping.getInputMappingAttributes()) {
            if (!inputMappingAttribute.getToElementKey().equals(toStreamAttributeName)) continue;
            return inputMappingAttribute.getFromElementKey();
        }
        return null;
    }

    public static Event getEventFromArray(Object[] outObjArray, StreamDefinition outStreamDefinition, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) {
        int attributeCount = 0;
        int metaDataCount = metaDataArray.length;
        int correlationDataCount = correlationDataArray.length;
        for (Object attributeObject : outObjArray) {
            if (attributeCount < metaDataCount) {
                metaDataArray[attributeCount++] = attributeObject;
                continue;
            }
            if (attributeCount < metaDataCount + correlationDataCount) {
                correlationDataArray[attributeCount++ - metaDataCount] = attributeObject;
                continue;
            }
            payloadDataArray[attributeCount++ - (metaDataCount + correlationDataCount)] = attributeObject;
        }
        return new Event(outStreamDefinition.getStreamId(), System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray);
    }

    public static void validateFilePath(String fileName) throws EventReceiverConfigurationException {
        if (fileName.contains("../") || fileName.contains("..\\")) {
            throw new EventReceiverConfigurationException("File name contains restricted path elements. " + fileName);
        }
    }

    public static Object convertToAttributeType(String attributeValue, Class beanClass) {
        if (Integer.class == beanClass) {
            return Integer.parseInt(attributeValue);
        }
        if (Double.class == beanClass) {
            return Double.parseDouble(attributeValue);
        }
        if (Long.class == beanClass) {
            return Long.parseLong(attributeValue);
        }
        if (Boolean.class == beanClass) {
            return Boolean.parseBoolean(attributeValue);
        }
        if (Float.class == beanClass) {
            return Float.valueOf(Float.parseFloat(attributeValue));
        }
        return attributeValue;
    }

    static {
        log = LogFactory.getLog(EventReceiverUtil.class);
        String arch = System.getProperty(JVM_BIT_ARCH_SYSTEM_PROPERTY);
        referenceSize = arch.equals("32") ? 4 : 8;
    }
}

