/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterSchema;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterService;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.receiver.core.InputMapperFactory;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConstants;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverStreamValidationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverValidationException;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.util.XmlFormatter;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class EventReceiverConfigurationBuilder {
    private static final Log log = LogFactory.getLog(EventReceiverConfigurationBuilder.class);

    public static OMElement eventReceiverConfigurationToOM(EventReceiverConfiguration eventReceiverConfiguration) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement eventReceiverConfigElement = factory.createOMElement(new QName("eventReceiver"));
        eventReceiverConfigElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        eventReceiverConfigElement.addAttribute("name", eventReceiverConfiguration.getEventReceiverName(), null);
        if (eventReceiverConfiguration.isTraceEnabled()) {
            eventReceiverConfigElement.addAttribute("trace", "enable", null);
        } else {
            eventReceiverConfigElement.addAttribute("trace", "disable", null);
        }
        if (eventReceiverConfiguration.isStatisticsEnabled()) {
            eventReceiverConfigElement.addAttribute("statistics", "enable", null);
        } else {
            eventReceiverConfigElement.addAttribute("statistics", "disable", null);
        }
        OMElement fromOMElement = factory.createOMElement(new QName("from"));
        fromOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        InputEventAdapterConfiguration inputEventAdapterConfiguration = eventReceiverConfiguration.getFromAdapterConfiguration();
        fromOMElement.addAttribute("eventAdapterType", inputEventAdapterConfiguration.getType(), null);
        Map inputPropertyMap = inputEventAdapterConfiguration.getProperties();
        if (inputPropertyMap != null) {
            for (Map.Entry propertyEntry : inputPropertyMap.entrySet()) {
                if (propertyEntry.getValue() == null) continue;
                OMElement propertyElement = factory.createOMElement(new QName("property"));
                propertyElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
                propertyElement.addAttribute("name", (String)propertyEntry.getKey(), null);
                propertyElement.setText((String)propertyEntry.getValue());
                fromOMElement.addChild((OMNode)propertyElement);
            }
        }
        eventReceiverConfigElement.addChild((OMNode)fromOMElement);
        OMElement mappingOMElement = EventReceiverServiceValueHolder.getMappingFactoryMap().get(eventReceiverConfiguration.getInputMapping().getMappingType()).constructOMFromInputMapping(eventReceiverConfiguration.getInputMapping(), factory);
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        eventReceiverConfigElement.addChild((OMNode)mappingOMElement);
        OMElement toOMElement = factory.createOMElement(new QName("to"));
        toOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        toOMElement.addAttribute("streamName", eventReceiverConfiguration.getToStreamName(), null);
        toOMElement.addAttribute("version", eventReceiverConfiguration.getToStreamVersion(), null);
        eventReceiverConfigElement.addChild((OMNode)toOMElement);
        try {
            String formattedXml = XmlFormatter.format(eventReceiverConfigElement.toString());
            eventReceiverConfigElement = AXIOMUtil.stringToOM((String)formattedXml);
        }
        catch (XMLStreamException e) {
            log.warn((Object)("Could not format OMElement properly." + eventReceiverConfigElement.toString()));
        }
        return eventReceiverConfigElement;
    }

    public static EventReceiverConfiguration getEventReceiverConfiguration(OMElement eventReceiverConfigOMElement, String mappingType, boolean isEditable, int tenantId) throws EventReceiverConfigurationException {
        String statisticsEnabledAttribute;
        if (!eventReceiverConfigOMElement.getLocalName().equals("eventReceiver")) {
            throw new EventReceiverConfigurationException("Root element is not an event receiver.");
        }
        String eventReceiverName = eventReceiverConfigOMElement.getAttributeValue(new QName("name"));
        boolean traceEnabled = false;
        boolean statisticsEnabled = false;
        String traceEnabledAttribute = eventReceiverConfigOMElement.getAttributeValue(new QName("trace"));
        if (traceEnabledAttribute != null && traceEnabledAttribute.equalsIgnoreCase("enable")) {
            traceEnabled = true;
        }
        if ((statisticsEnabledAttribute = eventReceiverConfigOMElement.getAttributeValue(new QName("statistics"))) != null && statisticsEnabledAttribute.equalsIgnoreCase("enable")) {
            statisticsEnabled = true;
        }
        EventReceiverConfiguration eventReceiverConfiguration = new EventReceiverConfiguration();
        OMElement fromElement = eventReceiverConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        OMElement mappingElement = eventReceiverConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "mapping"));
        OMElement toElement = eventReceiverConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        String fromEventAdapterType = fromElement.getAttributeValue(new QName("eventAdapterType"));
        if (!EventReceiverConfigurationBuilder.validateEventAdapter(fromEventAdapterType)) {
            throw new EventReceiverValidationException("Event Adapter with type: " + fromEventAdapterType + " does not exist", fromEventAdapterType);
        }
        InputEventAdapterConfiguration inputEventAdapterConfiguration = EventReceiverConfigurationBuilder.getInputEventAdapterConfiguration(fromEventAdapterType, eventReceiverName, mappingType);
        Iterator fromElementPropertyIterator = fromElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "property"));
        while (fromElementPropertyIterator.hasNext()) {
            OMElement toElementProperty = (OMElement)fromElementPropertyIterator.next();
            String propertyName = toElementProperty.getAttributeValue(new QName("name"));
            String propertyValue = toElementProperty.getText();
            OMAttribute encryptedAttribute = toElementProperty.getAttribute(new QName("encrypted"));
            if (encryptedAttribute != null && "true".equals(encryptedAttribute.getAttributeValue())) {
                try {
                    propertyValue = new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(propertyValue));
                }
                catch (CryptoException e) {
                    log.error((Object)("Unable to decrypt the encrypted field: " + propertyName + " in adaptor: " + inputEventAdapterConfiguration.getName()));
                    propertyValue = "";
                }
            }
            if (inputEventAdapterConfiguration.getProperties().containsKey(propertyName)) {
                inputEventAdapterConfiguration.getProperties().put(propertyName, propertyValue);
                continue;
            }
            log.warn((Object)("To property " + propertyName + " with value " + propertyValue + " is dropped as its irrelevant of input adapter type:" + fromEventAdapterType));
        }
        String fromStreamName = "";
        String fromStreamVersion = "";
        String customMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("customMapping"));
        if (mappingType.equalsIgnoreCase("wso2event") && customMappingEnabledAttribute != null && customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            OMElement fromOMElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
            fromStreamName = fromOMElement.getAttributeValue(new QName("streamName"));
            fromStreamVersion = fromOMElement.getAttributeValue(new QName("version"));
        }
        String toStreamName = toElement.getAttributeValue(new QName("streamName"));
        String toStreamVersion = toElement.getAttributeValue(new QName("version"));
        if (fromStreamName == null || fromStreamName.isEmpty() || fromStreamVersion == null || fromStreamVersion.isEmpty()) {
            inputEventAdapterConfiguration.setInputStreamIdOfWso2eventMessageFormat(toStreamName + ":" + toStreamVersion);
        } else {
            inputEventAdapterConfiguration.setInputStreamIdOfWso2eventMessageFormat(fromStreamName + ":" + fromStreamVersion);
        }
        if (mappingType.equalsIgnoreCase("wso2event")) {
            if (!EventReceiverConfigurationBuilder.validateSupportedMapping(fromEventAdapterType, "wso2event")) {
                throw new EventReceiverConfigurationException("Wso2 Event Mapping is not supported by event adapter type " + fromEventAdapterType);
            }
        } else if (mappingType.equalsIgnoreCase("text")) {
            if (!EventReceiverConfigurationBuilder.validateSupportedMapping(fromEventAdapterType, "text")) {
                throw new EventReceiverConfigurationException("Text Mapping is not supported by event adapter type " + fromEventAdapterType);
            }
        } else if (mappingType.equalsIgnoreCase("map")) {
            if (!EventReceiverConfigurationBuilder.validateSupportedMapping(fromEventAdapterType, "map")) {
                throw new EventReceiverConfigurationException("Mapping for Map input is not supported by event adapter type " + fromEventAdapterType);
            }
        } else if (mappingType.equalsIgnoreCase("xml")) {
            if (!EventReceiverConfigurationBuilder.validateSupportedMapping(fromEventAdapterType, "xml")) {
                throw new EventReceiverConfigurationException("XML Mapping is not supported by event adapter type " + fromEventAdapterType);
            }
            eventReceiverConfiguration = new EventReceiverConfiguration();
        } else if (mappingType.equalsIgnoreCase("json")) {
            if (!EventReceiverConfigurationBuilder.validateSupportedMapping(fromEventAdapterType, "json")) {
                throw new EventReceiverConfigurationException("JSON Mapping is not supported by event adapter type " + fromEventAdapterType);
            }
        } else {
            String factoryClassName = EventReceiverConfigurationBuilder.getMappingTypeFactoryClass(mappingElement);
            if (factoryClassName == null) {
                throw new EventReceiverConfigurationException("Corresponding mappingType " + mappingType + " is not valid");
            }
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                InputMapperFactory inputMapperFactory = (InputMapperFactory)factoryClass.newInstance();
                EventReceiverServiceValueHolder.getMappingFactoryMap().putIfAbsent(mappingType, inputMapperFactory);
                eventReceiverConfiguration = new EventReceiverConfiguration();
            }
            catch (ClassNotFoundException e) {
                throw new EventReceiverConfigurationException("Class not found exception occurred ", e);
            }
            catch (InstantiationException e) {
                throw new EventReceiverConfigurationException("Instantiation exception occurred ", e);
            }
            catch (IllegalAccessException e) {
                throw new EventReceiverConfigurationException("Illegal exception occurred ", e);
            }
        }
        if (!EventReceiverConfigurationBuilder.validateStreamDetails(toStreamName, toStreamVersion, tenantId)) {
            throw new EventReceiverStreamValidationException("Stream " + toStreamName + ":" + toStreamVersion + " does not exist", toStreamName + ":" + toStreamVersion);
        }
        eventReceiverConfiguration.setEventReceiverName(eventReceiverName);
        eventReceiverConfiguration.setTraceEnabled(traceEnabled);
        eventReceiverConfiguration.setStatisticsEnabled(statisticsEnabled);
        eventReceiverConfiguration.setToStreamName(toStreamName);
        eventReceiverConfiguration.setToStreamVersion(toStreamVersion);
        InputMapperFactory mapperFactory = EventReceiverServiceValueHolder.getMappingFactoryMap().get(mappingType);
        eventReceiverConfiguration.setInputMapping(mapperFactory.constructInputMappingFromOM(mappingElement));
        eventReceiverConfiguration.setFromAdapterConfiguration(inputEventAdapterConfiguration);
        eventReceiverConfiguration.setEditable(isEditable);
        return eventReceiverConfiguration;
    }

    public static InputEventAdapterConfiguration getInputEventAdapterConfiguration(String eventAdapterType, String receiverName, String messageFormat) {
        InputEventAdapterSchema schema = EventReceiverServiceValueHolder.getInputEventAdapterService().getInputEventAdapterSchema(eventAdapterType);
        InputEventAdapterConfiguration inputEventAdapterConfiguration = new InputEventAdapterConfiguration();
        inputEventAdapterConfiguration.setName(receiverName);
        inputEventAdapterConfiguration.setMessageFormat(messageFormat);
        inputEventAdapterConfiguration.setType(eventAdapterType);
        HashMap<String, String> staticProperties = new HashMap<String, String>();
        if (schema != null && schema.getPropertyList() != null) {
            for (Property property : schema.getPropertyList()) {
                staticProperties.put(property.getPropertyName(), property.getDefaultValue());
            }
        }
        inputEventAdapterConfiguration.setProperties(staticProperties);
        return inputEventAdapterConfiguration;
    }

    public static String getMappingTypeFactoryClass(OMElement omElement) {
        return omElement.getAttributeValue(new QName("factoryClass"));
    }

    private static boolean validateEventAdapter(String eventAdapterType) {
        InputEventAdapterService eventAdapterService = EventReceiverServiceValueHolder.getInputEventAdapterService();
        List eventAdapterTypes = eventAdapterService.getInputEventAdapterTypes();
        if (eventAdapterTypes == null || eventAdapterTypes.size() == 0) {
            throw new EventReceiverValidationException("Event adapter with type: " + eventAdapterType + " does not exist", eventAdapterType);
        }
        for (String adapterType : eventAdapterTypes) {
            if (!adapterType.equals(eventAdapterType)) continue;
            return true;
        }
        return false;
    }

    public static String getAttributeType(AttributeType attributeType) {
        Map<String, AttributeType> attributeMap = EventReceiverConstants.STRING_ATTRIBUTE_TYPE_MAP;
        for (Map.Entry<String, AttributeType> entry : attributeMap.entrySet()) {
            if (!entry.getValue().equals((Object)attributeType)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean validateSupportedMapping(String eventAdapterType, String messageType) {
        InputEventAdapterService eventAdapterService = EventReceiverServiceValueHolder.getInputEventAdapterService();
        InputEventAdapterSchema eventAdapterSchema = eventAdapterService.getInputEventAdapterSchema(eventAdapterType);
        if (eventAdapterSchema == null) {
            throw new EventReceiverValidationException("Event Adapter with type: " + eventAdapterType + " does not exist", eventAdapterType);
        }
        List supportedInputMessageFormats = eventAdapterSchema.getSupportedMessageFormats();
        return supportedInputMessageFormats.contains(messageType);
    }

    private static boolean validateStreamDetails(String streamName, String streamVersion, int tenantId) throws EventReceiverConfigurationException {
        EventStreamService eventStreamService = EventReceiverServiceValueHolder.getEventStreamService();
        try {
            StreamDefinition streamDefinition = eventStreamService.getStreamDefinition(streamName, streamVersion);
            if (streamDefinition != null) {
                return true;
            }
        }
        catch (EventStreamConfigurationException e) {
            throw new EventReceiverConfigurationException("Error while validating stream definition with store : " + e.getMessage(), e);
        }
        return false;
    }
}

