/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConstants;
import org.wso2.carbon.event.receiver.core.config.InputMapping;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.XMLInputMapping;
import org.wso2.carbon.event.receiver.core.config.mapping.XPathDefinition;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverConfigurationBuilder;

public class XMLInputMapperConfigrationBuilder {
    private static XMLInputMapperConfigrationBuilder instance = new XMLInputMapperConfigrationBuilder();

    private XMLInputMapperConfigrationBuilder() {
    }

    public static XMLInputMapperConfigrationBuilder getInstance() {
        return instance;
    }

    public OMElement inputMappingToOM(InputMapping inputMapping, OMFactory factory) {
        XMLInputMapping xmlInputMapping = (XMLInputMapping)inputMapping;
        List<XPathDefinition> xPathDefinitions = xmlInputMapping.getXPathDefinitions();
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        if (xmlInputMapping.getParentSelectorXpath() != null && !xmlInputMapping.getParentSelectorXpath().isEmpty()) {
            mappingOMElement.addAttribute("parentXpath", xmlInputMapping.getParentSelectorXpath(), null);
        }
        mappingOMElement.addAttribute("type", "xml", null);
        if (xmlInputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        if (xPathDefinitions != null) {
            for (XPathDefinition xPathDefinition : xPathDefinitions) {
                OMElement xpathDefOMElement = factory.createOMElement(new QName("xpathDefinition"));
                xpathDefOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
                xpathDefOMElement.addAttribute("prefix", xPathDefinition.getPrefix(), null);
                xpathDefOMElement.addAttribute("namespace", xPathDefinition.getNamespaceUri(), null);
                mappingOMElement.addChild((OMNode)xpathDefOMElement);
            }
        }
        for (InputMappingAttribute inputMappingAttribute : xmlInputMapping.getInputMappingAttributes()) {
            OMElement propertyOMElement = this.getPropertyOmElement(factory, inputMappingAttribute);
            propertyOMElement.setNamespace(mappingOMElement.getDefaultNamespace());
            mappingOMElement.addChild((OMNode)propertyOMElement);
        }
        return mappingOMElement;
    }

    private InputMappingAttribute getInputMappingAttributeFromOM(OMElement omElement) {
        OMElement propertyFromElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        OMElement propertyToElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        String xpath = propertyFromElement.getAttributeValue(new QName("xpath"));
        String outputPropertyName = propertyToElement.getAttributeValue(new QName("name"));
        String attributeType = propertyToElement.getAttributeValue(new QName("type"));
        AttributeType outputPropertyType = EventReceiverConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attributeType.toLowerCase());
        String defaultValue = propertyToElement.getAttributeValue(new QName("default"));
        InputMappingAttribute inputMappingAttribute = new InputMappingAttribute(xpath, outputPropertyName, outputPropertyType);
        inputMappingAttribute.setDefaultValue(defaultValue);
        return inputMappingAttribute;
    }

    private OMElement getPropertyOmElement(OMFactory factory, InputMappingAttribute inputMappingAttribute) {
        OMElement propertyOmElement = factory.createOMElement(new QName("property"));
        OMElement fromElement = factory.createOMElement(new QName("from"));
        fromElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        fromElement.addAttribute("xpath", inputMappingAttribute.getFromElementKey(), null);
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        toElement.addAttribute("name", inputMappingAttribute.getToElementKey(), null);
        toElement.addAttribute("type", EventReceiverConfigurationBuilder.getAttributeType(inputMappingAttribute.getToElementType()), null);
        if (inputMappingAttribute.getDefaultValue() != null && !inputMappingAttribute.getDefaultValue().isEmpty()) {
            toElement.addAttribute("default", inputMappingAttribute.getDefaultValue(), null);
        }
        propertyOmElement.addChild((OMNode)fromElement);
        propertyOmElement.addChild((OMNode)toElement);
        return propertyOmElement;
    }

    public InputMapping fromOM(OMElement mappingElement) throws EventReceiverConfigurationException {
        XMLInputMapperConfigrationBuilder.validateXMLEventMapping(mappingElement);
        XMLInputMapping xmlInputMapping = new XMLInputMapping();
        String customMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            xmlInputMapping.setCustomMappingEnabled(true);
            String parentSelectorXpath = mappingElement.getAttributeValue(new QName("parentXpath"));
            if (parentSelectorXpath != null && !parentSelectorXpath.isEmpty()) {
                xmlInputMapping.setParentSelectorXpath(parentSelectorXpath);
            }
            Iterator xpathDefIterator = mappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "xpathDefinition"));
            ArrayList<XPathDefinition> xPathDefinitions = new ArrayList<XPathDefinition>();
            while (xpathDefIterator.hasNext()) {
                OMElement xpathDefElement = (OMElement)xpathDefIterator.next();
                if (xpathDefElement == null) continue;
                String prefix = xpathDefElement.getAttributeValue(new QName("prefix"));
                String namespace = xpathDefElement.getAttributeValue(new QName("namespace"));
                xPathDefinitions.add(new XPathDefinition(prefix, namespace));
            }
            xmlInputMapping.setXPathDefinitions(xPathDefinitions);
            Iterator propertyIterator = mappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "property"));
            while (propertyIterator.hasNext()) {
                OMElement propertyOMElement = (OMElement)propertyIterator.next();
                InputMappingAttribute inputMappingAttribute = this.getInputMappingAttributeFromOM(propertyOMElement);
                xmlInputMapping.addInputMappingAttribute(inputMappingAttribute);
            }
        } else {
            xmlInputMapping.setCustomMappingEnabled(false);
        }
        return xmlInputMapping;
    }

    public static void validateXMLEventMapping(OMElement omElement) throws EventReceiverConfigurationException {
        String customMappingEnabledAttribute = omElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            ArrayList<String> supportedChildTags = new ArrayList<String>();
            supportedChildTags.add("property");
            supportedChildTags.add("xpathDefinition");
            int propertyCount = 0;
            Iterator mappingIterator = omElement.getChildElements();
            while (mappingIterator.hasNext()) {
                OMElement childElement = (OMElement)mappingIterator.next();
                String childTag = childElement.getLocalName();
                if (!supportedChildTags.contains(childTag)) {
                    throw new EventReceiverConfigurationException("Unsupported XML configuration element for XML Input Mapping : " + childTag);
                }
                if (!childTag.equals("property")) continue;
                ++propertyCount;
                OMElement propertyFromElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
                OMElement propertyToElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
                if (propertyFromElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'from' element");
                }
                if (propertyFromElement.getAttribute(new QName("xpath")) == null) {
                    throw new EventReceiverConfigurationException("XML Mapping must contain an XPath expression to map from");
                }
                if (propertyToElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'to' element");
                }
                if (propertyToElement.getAttribute(new QName("name")) != null && propertyToElement.getAttribute(new QName("type")) != null) continue;
                throw new EventReceiverConfigurationException("An attribute mapping must provide name and type for its 'to' element.");
            }
            if (propertyCount == 0) {
                throw new EventReceiverConfigurationException("No Mapping properties in configuration");
            }
        }
    }
}

