/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.wso2event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConstants;
import org.wso2.carbon.event.receiver.core.config.InputMapping;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.WSO2EventInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverConfigurationBuilder;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;

public class WSO2EventInputMapperConfigurationBuilder {
    private static WSO2EventInputMapperConfigurationBuilder instance = new WSO2EventInputMapperConfigurationBuilder();

    private WSO2EventInputMapperConfigurationBuilder() {
    }

    public static WSO2EventInputMapperConfigurationBuilder getInstance() {
        return instance;
    }

    public InputMapping fromOM(OMElement mappingElement) throws EventReceiverConfigurationException {
        WSO2EventInputMapperConfigurationBuilder.validateWso2EventMapping(mappingElement);
        WSO2EventInputMapping wso2EventInputMapping = new WSO2EventInputMapping();
        String customMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            wso2EventInputMapping.setCustomMappingEnabled(true);
            Iterator propertyIterator = mappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "property"));
            while (propertyIterator.hasNext()) {
                OMElement propertyOMElement = (OMElement)propertyIterator.next();
                InputMappingAttribute inputMappingAttribute = this.getInputMappingAttributeFromOM(propertyOMElement);
                wso2EventInputMapping.addInputMappingAttribute(inputMappingAttribute);
            }
            OMElement fromOMElement = mappingElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
            wso2EventInputMapping.setFromEventName(fromOMElement.getAttributeValue(new QName("streamName")));
            wso2EventInputMapping.setFromEventVersion(fromOMElement.getAttributeValue(new QName("version")));
            List<InputMappingAttribute> sortedInputMappingAttributes = EventReceiverUtil.sortInputMappingAttributes(wso2EventInputMapping.getInputMappingAttributes());
            int streamPosition = 0;
            for (InputMappingAttribute inputMappingAttribute : sortedInputMappingAttributes) {
                inputMappingAttribute.setToStreamPosition(streamPosition++);
            }
            wso2EventInputMapping.setInputMappingAttributes(sortedInputMappingAttributes);
        } else {
            wso2EventInputMapping.setCustomMappingEnabled(false);
        }
        String arbitraryMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("arbitraryMaps"));
        if (arbitraryMappingEnabledAttribute != null && arbitraryMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            wso2EventInputMapping.setArbitraryMapsEnabled(true);
        }
        return wso2EventInputMapping;
    }

    private InputMappingAttribute getInputMappingAttributeFromOM(OMElement omElement) {
        OMElement propertyFromElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        OMElement propertyToElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        String name = propertyFromElement.getAttributeValue(new QName("name"));
        String dataType = propertyFromElement.getAttributeValue(new QName("dataType"));
        String valueOf = propertyToElement.getAttributeValue(new QName("name"));
        String attributeType = propertyToElement.getAttributeValue(new QName("type"));
        AttributeType type = EventReceiverConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attributeType.toLowerCase());
        if (valueOf == null) {
            valueOf = name;
        }
        return new InputMappingAttribute(name, valueOf, type, dataType);
    }

    public static void validateWso2EventMapping(OMElement omElement) throws EventReceiverConfigurationException {
        ArrayList<String> supportedChildTags = new ArrayList<String>();
        supportedChildTags.add("property");
        supportedChildTags.add("from");
        String customMappingEnabledAttribute = omElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            int count = 0;
            Iterator mappingIterator = omElement.getChildElements();
            while (mappingIterator.hasNext()) {
                ++count;
                OMElement childElement = (OMElement)mappingIterator.next();
                String childTag = childElement.getLocalName();
                if (!supportedChildTags.contains(childTag)) {
                    throw new EventReceiverConfigurationException("Unsupported XML configuration element for WSO2Event Input Mapping : " + childTag);
                }
                if (!childTag.equals("property")) continue;
                OMElement propertyFromElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
                OMElement propertyToElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
                if (propertyFromElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'from' element");
                }
                if (propertyToElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'to' element");
                }
                if (propertyToElement.getAttribute(new QName("name")) != null && propertyToElement.getAttribute(new QName("type")) != null) continue;
                throw new EventReceiverConfigurationException("An attribute mapping must provide name and type for its 'to' element.");
            }
            if (count == 0) {
                throw new EventReceiverConfigurationException("There must be at least 1 attribute mapping with Custom Mapping enabled.");
            }
        }
    }

    public OMElement inputMappingToOM(InputMapping inputMapping, OMFactory factory) {
        WSO2EventInputMapping wso2EventInputMapping = (WSO2EventInputMapping)inputMapping;
        List<InputMappingAttribute> inputMappingAttributes = wso2EventInputMapping.getInputMappingAttributes();
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        mappingOMElement.addAttribute("type", "wso2event", null);
        if (wso2EventInputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        if (inputMappingAttributes.size() > 0) {
            OMElement fromOMElement = factory.createOMElement(new QName("from"));
            fromOMElement.setNamespace(mappingOMElement.getDefaultNamespace());
            fromOMElement.addAttribute("streamName", wso2EventInputMapping.getFromEventName(), null);
            fromOMElement.addAttribute("version", wso2EventInputMapping.getFromEventVersion(), null);
            mappingOMElement.addChild((OMNode)fromOMElement);
            for (InputMappingAttribute inputMappingAttribute : inputMappingAttributes) {
                OMElement propertyOMElement = this.getPropertyOmElement(factory, inputMappingAttribute);
                propertyOMElement.setNamespace(mappingOMElement.getDefaultNamespace());
                mappingOMElement.addChild((OMNode)propertyOMElement);
            }
        }
        return mappingOMElement;
    }

    protected OMElement getPropertyOmElement(OMFactory factory, InputMappingAttribute inputMappingAttribute) {
        OMElement propertyOMElement = factory.createOMElement(new QName("property"));
        OMElement fromElement = factory.createOMElement(new QName("from"));
        fromElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        fromElement.addAttribute("name", inputMappingAttribute.getFromElementKey(), null);
        fromElement.addAttribute("dataType", inputMappingAttribute.getFromElementType(), null);
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        toElement.addAttribute("name", inputMappingAttribute.getToElementKey(), null);
        toElement.addAttribute("type", EventReceiverConfigurationBuilder.getAttributeType(inputMappingAttribute.getToElementType()), null);
        propertyOMElement.addChild((OMNode)fromElement);
        propertyOMElement.addChild((OMNode)toElement);
        return propertyOMElement;
    }
}

