/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.wso2event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.receiver.core.InputMapper;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.InputMapping;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.WSO2EventInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverProcessingException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverStreamValidationException;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class WSO2EventInputMapper
implements InputMapper {
    private EventReceiverConfiguration eventReceiverConfiguration = null;
    private StreamDefinition exportedStreamDefinition = null;
    private StreamDefinition importedStreamDefinition = null;
    private Map<InputDataType, int[]> inputDataTypeSpecificPositionMap = null;
    private boolean arbitraryMapsEnabled = false;
    private int inputStreamSize = 0;
    private int outMetaSize = 0;
    private int outCorrelationSize = 0;
    private int outPayloadSize = 0;

    public WSO2EventInputMapper(EventReceiverConfiguration eventReceiverConfiguration, StreamDefinition exportedStreamDefinition) throws EventReceiverConfigurationException {
        EventStreamService eventStreamService = EventReceiverServiceValueHolder.getEventStreamService();
        this.eventReceiverConfiguration = eventReceiverConfiguration;
        WSO2EventInputMapping wso2EventInputMapping = (WSO2EventInputMapping)this.eventReceiverConfiguration.getInputMapping();
        String fromStreamName = wso2EventInputMapping.getFromEventName();
        String fromStreamVersion = wso2EventInputMapping.getFromEventVersion();
        this.arbitraryMapsEnabled = wso2EventInputMapping.isArbitraryMapsEnabled();
        if (fromStreamName == null || fromStreamVersion == null || fromStreamName.isEmpty() || fromStreamVersion.isEmpty()) {
            this.importedStreamDefinition = exportedStreamDefinition;
        } else {
            try {
                this.importedStreamDefinition = eventStreamService.getStreamDefinition(fromStreamName, fromStreamVersion);
            }
            catch (EventStreamConfigurationException e) {
                throw new EventReceiverStreamValidationException("Error while retrieving stream definition : " + e.getMessage(), fromStreamName + ":" + fromStreamVersion);
            }
        }
        this.exportedStreamDefinition = exportedStreamDefinition;
        if (this.importedStreamDefinition == null) {
            String fromStream = fromStreamName + ":" + fromStreamVersion;
            throw new EventReceiverStreamValidationException("Imported stream " + fromStream + " is not available", fromStream);
        }
        boolean candidateForArbitraryMaps = this.isCandidateForArbitraryAttributes(eventReceiverConfiguration.getInputMapping(), this.importedStreamDefinition);
        if (!candidateForArbitraryMaps) {
            this.validateInputStreamAttributes();
        }
        if (this.importedStreamDefinition != null && eventReceiverConfiguration.getInputMapping().isCustomMappingEnabled() && !candidateForArbitraryMaps) {
            int i;
            this.inputDataTypeSpecificPositionMap = new HashMap<InputDataType, int[]>();
            TreeMap<Integer, Integer> payloadDataMap = new TreeMap<Integer, Integer>();
            TreeMap<Integer, Integer> metaDataMap = new TreeMap<Integer, Integer>();
            TreeMap<Integer, Integer> correlationDataMap = new TreeMap<Integer, Integer>();
            ArrayList allAttributes = new ArrayList();
            if (this.importedStreamDefinition.getMetaData() != null && !this.importedStreamDefinition.getMetaData().isEmpty()) {
                allAttributes.addAll(this.importedStreamDefinition.getMetaData());
            }
            if (this.importedStreamDefinition.getCorrelationData() != null && !this.importedStreamDefinition.getCorrelationData().isEmpty()) {
                allAttributes.addAll(this.importedStreamDefinition.getCorrelationData());
            }
            if (this.importedStreamDefinition.getPayloadData() != null && !this.importedStreamDefinition.getPayloadData().isEmpty()) {
                allAttributes.addAll(this.importedStreamDefinition.getPayloadData());
            }
            int metaCount = 0;
            int correlationCount = 0;
            int payloadCount = 0;
            for (InputMappingAttribute inputMappingAttribute : wso2EventInputMapping.getInputMappingAttributes()) {
                if (inputMappingAttribute.getToElementKey().startsWith("meta_")) {
                    for (i = 0; i < allAttributes.size(); ++i) {
                        if (!((Attribute)allAttributes.get(i)).getName().equals(inputMappingAttribute.getFromElementKey())) continue;
                        metaDataMap.put(metaCount, i);
                        break;
                    }
                    if (metaDataMap.get(metaCount++) != null) continue;
                    this.inputDataTypeSpecificPositionMap = null;
                    throw new EventReceiverStreamValidationException("Cannot find a corresponding meta data input attribute '" + inputMappingAttribute.getFromElementKey() + "' in stream with id " + this.importedStreamDefinition.getStreamId(), this.importedStreamDefinition.getStreamId());
                }
                if (inputMappingAttribute.getToElementKey().startsWith("correlation_")) {
                    for (i = 0; i < allAttributes.size(); ++i) {
                        if (!((Attribute)allAttributes.get(i)).getName().equals(inputMappingAttribute.getFromElementKey())) continue;
                        correlationDataMap.put(correlationCount, i);
                        break;
                    }
                    if (correlationDataMap.get(correlationCount++) != null) continue;
                    this.inputDataTypeSpecificPositionMap = null;
                    throw new EventReceiverStreamValidationException("Cannot find a corresponding correlation data input attribute '" + inputMappingAttribute.getFromElementKey() + "' in stream with id " + this.importedStreamDefinition.getStreamId(), this.importedStreamDefinition.getStreamId());
                }
                for (i = 0; i < allAttributes.size(); ++i) {
                    if (!((Attribute)allAttributes.get(i)).getName().equals(inputMappingAttribute.getFromElementKey())) continue;
                    payloadDataMap.put(payloadCount, i);
                    break;
                }
                if (payloadDataMap.get(payloadCount++) != null) continue;
                this.inputDataTypeSpecificPositionMap = null;
                throw new EventReceiverStreamValidationException("Cannot find a corresponding payload data input attribute '" + inputMappingAttribute.getFromElementKey() + "' in stream with id : " + this.importedStreamDefinition.getStreamId(), this.importedStreamDefinition.getStreamId());
            }
            this.outMetaSize = metaDataMap.size();
            this.outCorrelationSize = correlationDataMap.size();
            this.outPayloadSize = payloadDataMap.size();
            int[] metaPositions = new int[this.outMetaSize];
            for (int i2 = 0; i2 < metaPositions.length; ++i2) {
                metaPositions[i2] = (Integer)metaDataMap.get(i2);
            }
            this.inputDataTypeSpecificPositionMap.put(InputDataType.META_DATA, metaPositions);
            int[] correlationPositions = new int[this.outCorrelationSize];
            for (i = 0; i < correlationPositions.length; ++i) {
                correlationPositions[i] = (Integer)correlationDataMap.get(i);
            }
            this.inputDataTypeSpecificPositionMap.put(InputDataType.CORRELATION_DATA, correlationPositions);
            int[] payloadPositions = new int[this.outPayloadSize];
            for (int i3 = 0; i3 < payloadPositions.length; ++i3) {
                payloadPositions[i3] = (Integer)payloadDataMap.get(i3);
            }
            this.inputDataTypeSpecificPositionMap.put(InputDataType.PAYLOAD_DATA, payloadPositions);
            this.inputStreamSize = allAttributes.size();
        } else if (this.importedStreamDefinition != null && !eventReceiverConfiguration.getInputMapping().isCustomMappingEnabled()) {
            if (this.importedStreamDefinition.getCorrelationData() != null ? !this.importedStreamDefinition.getCorrelationData().equals(exportedStreamDefinition.getCorrelationData()) : exportedStreamDefinition.getCorrelationData() != null) {
                throw new EventReceiverStreamValidationException("Input stream definition : " + this.importedStreamDefinition + " not matching with output stream definition : " + exportedStreamDefinition + " to create pass-through link ", this.importedStreamDefinition.getStreamId());
            }
            if (this.importedStreamDefinition.getMetaData() != null ? !this.importedStreamDefinition.getMetaData().equals(exportedStreamDefinition.getMetaData()) : exportedStreamDefinition.getMetaData() != null) {
                throw new EventReceiverStreamValidationException("Input stream definition : " + this.importedStreamDefinition + " not matching with output stream definition : " + exportedStreamDefinition + " to create pass-through link ", this.importedStreamDefinition.getStreamId());
            }
            if (this.importedStreamDefinition.getPayloadData() != null ? !this.importedStreamDefinition.getPayloadData().equals(exportedStreamDefinition.getPayloadData()) : exportedStreamDefinition.getPayloadData() != null) {
                throw new EventReceiverStreamValidationException("Input stream definition : " + this.importedStreamDefinition + " not matching with output stream definition : " + exportedStreamDefinition + " to create pass-through link ", this.importedStreamDefinition.getStreamId());
            }
        } else if (!candidateForArbitraryMaps) {
            throw new EventReceiverStreamValidationException("Error while retrieving stream definition : " + fromStreamName + ":" + fromStreamVersion);
        }
    }

    private boolean isCandidateForArbitraryAttributes(InputMapping inputMapping, StreamDefinition importedStreamDefinition) {
        for (InputMappingAttribute inputMappingAttribute : inputMapping.getInputMappingAttributes()) {
            if ("meta".equals(inputMappingAttribute.getFromElementType()) && !importedStreamDefinition.getMetaData().contains(new Attribute(inputMappingAttribute.getFromElementKey(), inputMappingAttribute.getToElementType()))) {
                return true;
            }
            if ("correlation".equals(inputMappingAttribute.getFromElementType()) && !importedStreamDefinition.getCorrelationData().contains(new Attribute(inputMappingAttribute.getFromElementKey(), inputMappingAttribute.getToElementType()))) {
                return true;
            }
            if (!"payload".equals(inputMappingAttribute.getFromElementType()) || importedStreamDefinition.getPayloadData().contains(new Attribute(inputMappingAttribute.getFromElementKey(), inputMappingAttribute.getToElementType()))) continue;
            return true;
        }
        return false;
    }

    private void validateInputStreamAttributes() throws EventReceiverConfigurationException {
        if (this.importedStreamDefinition != null) {
            WSO2EventInputMapping wso2EventInputMapping = (WSO2EventInputMapping)this.eventReceiverConfiguration.getInputMapping();
            List<InputMappingAttribute> inputMappingAttributes = wso2EventInputMapping.getInputMappingAttributes();
            List<String> inputStreamMetaAttributeNames = this.getAttributeNamesList(this.importedStreamDefinition.getMetaData());
            List<String> inputStreamCorrelationAttributeNames = this.getAttributeNamesList(this.importedStreamDefinition.getCorrelationData());
            List<String> inputStreamPayloadAttributeNames = this.getAttributeNamesList(this.importedStreamDefinition.getPayloadData());
            for (InputMappingAttribute inputMappingAttribute : inputMappingAttributes) {
                if (inputMappingAttribute.getToElementKey().startsWith("meta_") && !inputStreamMetaAttributeNames.contains(inputMappingAttribute.getFromElementKey())) {
                    throw new EventReceiverStreamValidationException("Property " + inputMappingAttribute.getFromElementKey() + " is not in the input stream definition. ", this.importedStreamDefinition.getStreamId());
                }
                if (inputMappingAttribute.getToElementKey().startsWith("correlation_") && !inputStreamCorrelationAttributeNames.contains(inputMappingAttribute.getFromElementKey())) {
                    throw new EventReceiverStreamValidationException("Property " + inputMappingAttribute.getFromElementKey() + " is not in the input stream definition. ", this.importedStreamDefinition.getStreamId());
                }
                if (inputMappingAttribute.getToElementKey().startsWith("meta_") || inputMappingAttribute.getToElementKey().startsWith("correlation_") || inputStreamPayloadAttributeNames.contains(inputMappingAttribute.getFromElementKey())) continue;
                throw new EventReceiverStreamValidationException("Property " + inputMappingAttribute.getFromElementKey() + " is not in the input stream definition. ", this.importedStreamDefinition.getStreamId());
            }
        }
    }

    private List<String> getAttributeNamesList(List<Attribute> attributeList) {
        ArrayList<String> attributeNamesList = new ArrayList<String>();
        if (attributeList != null) {
            for (Attribute attribute : attributeList) {
                attributeNamesList.add(attribute.getName());
            }
        }
        return attributeNamesList;
    }

    @Override
    public Object convertToMappedInputEvent(Object obj) throws EventReceiverProcessingException {
        if (obj instanceof Event) {
            Event event = (Event)obj;
            Map arbitraryMap = event.getArbitraryDataMap();
            if (arbitraryMap != null && !arbitraryMap.isEmpty()) {
                return this.processArbitraryMap(event);
            }
            if (this.inputDataTypeSpecificPositionMap != null) {
                Object[] outMetaAttrArray = new Object[this.outMetaSize];
                Object[] outCorrelationAttrArray = new Object[this.outCorrelationSize];
                Object[] outPayloadAttrArray = new Object[this.outPayloadSize];
                Object[] inEventArray = new Object[this.inputStreamSize];
                int inEventArrayCount = 0;
                if (event.getMetaData() != null) {
                    for (Object attribute : event.getMetaData()) {
                        inEventArray[inEventArrayCount++] = attribute;
                    }
                }
                if (event.getCorrelationData() != null) {
                    for (Object attribute : event.getCorrelationData()) {
                        inEventArray[inEventArrayCount++] = attribute;
                    }
                }
                if (event.getPayloadData() != null) {
                    for (Object attribute : event.getPayloadData()) {
                        inEventArray[inEventArrayCount++] = attribute;
                    }
                }
                int[] metaPositions = this.inputDataTypeSpecificPositionMap.get((Object)InputDataType.META_DATA);
                for (int i = 0; i < metaPositions.length; ++i) {
                    outMetaAttrArray[i] = inEventArray[metaPositions[i]];
                }
                int[] correlationPositions = this.inputDataTypeSpecificPositionMap.get((Object)InputDataType.CORRELATION_DATA);
                for (int i = 0; i < correlationPositions.length; ++i) {
                    outCorrelationAttrArray[i] = inEventArray[correlationPositions[i]];
                }
                int[] payloadPositions = this.inputDataTypeSpecificPositionMap.get((Object)InputDataType.PAYLOAD_DATA);
                for (int i = 0; i < payloadPositions.length; ++i) {
                    outPayloadAttrArray[i] = inEventArray[payloadPositions[i]];
                }
                return new Event(this.exportedStreamDefinition.getStreamId(), event.getTimeStamp(), outMetaAttrArray, outCorrelationAttrArray, outPayloadAttrArray);
            }
            return null;
        }
        return null;
    }

    @Override
    public Object convertToTypedInputEvent(Object obj) throws EventReceiverProcessingException {
        if (obj instanceof Event) {
            return obj;
        }
        return null;
    }

    @Override
    public Attribute[] getOutputAttributes() {
        WSO2EventInputMapping wso2EventInputMapping = (WSO2EventInputMapping)this.eventReceiverConfiguration.getInputMapping();
        List<InputMappingAttribute> inputMappingAttributes = wso2EventInputMapping.getInputMappingAttributes();
        return EventReceiverConfigurationHelper.getAttributes(inputMappingAttributes);
    }

    private Event processArbitraryMap(Event inEvent) {
        Object attributeObj;
        String value;
        int i;
        Map arbitraryMap = inEvent.getArbitraryDataMap();
        Object[] metaData = this.exportedStreamDefinition.getMetaData() != null ? new Object[this.exportedStreamDefinition.getMetaData().size()] : new Object[]{};
        Object[] correlationData = this.exportedStreamDefinition.getCorrelationData() != null ? new Object[this.exportedStreamDefinition.getCorrelationData().size()] : new Object[]{};
        Object[] payloadData = this.exportedStreamDefinition.getPayloadData() != null ? new Object[this.exportedStreamDefinition.getPayloadData().size()] : new Object[]{};
        for (i = 0; i < metaData.length; ++i) {
            Attribute metaAttribute = (Attribute)this.exportedStreamDefinition.getMetaData().get(i);
            value = (String)arbitraryMap.get(EventReceiverUtil.getMappedInputStreamAttributeName(metaAttribute.getName(), this.eventReceiverConfiguration.getInputMapping()));
            metaData[i] = value != null ? (attributeObj = EventReceiverUtil.getConvertedAttributeObject(value, metaAttribute.getType())) : inEvent.getMetaData()[i];
        }
        for (i = 0; i < correlationData.length; ++i) {
            Attribute correlationAttribute = (Attribute)this.exportedStreamDefinition.getCorrelationData().get(i);
            value = (String)arbitraryMap.get(EventReceiverUtil.getMappedInputStreamAttributeName(correlationAttribute.getName(), this.eventReceiverConfiguration.getInputMapping()));
            correlationData[i] = value != null ? (attributeObj = EventReceiverUtil.getConvertedAttributeObject(value, correlationAttribute.getType())) : inEvent.getCorrelationData()[i];
        }
        for (i = 0; i < payloadData.length; ++i) {
            Attribute payloadAttribute = (Attribute)this.exportedStreamDefinition.getPayloadData().get(i);
            value = (String)arbitraryMap.get(EventReceiverUtil.getMappedInputStreamAttributeName(payloadAttribute.getName(), this.eventReceiverConfiguration.getInputMapping()));
            payloadData[i] = value != null ? (attributeObj = EventReceiverUtil.getConvertedAttributeObject(value, payloadAttribute.getType())) : inEvent.getPayloadData()[i];
        }
        return new Event(inEvent.getStreamId(), inEvent.getTimeStamp(), metaData, correlationData, payloadData, arbitraryMap);
    }

    private static enum InputDataType {
        META_DATA,
        CORRELATION_DATA,
        PAYLOAD_DATA;

    }
}

