/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.text.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexData {
    private Pattern pattern;
    private Matcher matcher;
    private int matchGroupIndex;
    private List<String> types;
    private List<String> defaultValues;
    private String regex;
    private boolean matched;

    public RegexData(String regex) {
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
        this.matchGroupIndex = 0;
        this.types = new ArrayList<String>();
        this.defaultValues = new ArrayList<String>();
    }

    public void addMapping(String type, String defaultValue) {
        this.types.add(this.matchGroupIndex, type);
        this.defaultValues.add(this.matchGroupIndex, defaultValue);
        ++this.matchGroupIndex;
    }

    public String getDefaultValue() {
        return this.defaultValues.get(this.matchGroupIndex);
    }

    public String getType() {
        return this.types.get(this.matchGroupIndex);
    }

    public String next() {
        ++this.matchGroupIndex;
        String matchResult = this.matched && this.matchGroupIndex < this.matcher.groupCount() ? this.matcher.group(this.matchGroupIndex + 1) : this.defaultValues.get(this.matchGroupIndex);
        return matchResult;
    }

    public boolean hasNext() {
        return this.matcher.groupCount() > this.matchGroupIndex + 1;
    }

    public void matchInput(String input) {
        this.matcher = this.pattern.matcher(input);
        this.matched = this.matcher.find();
        this.matchGroupIndex = -1;
    }

    public String getRegex() {
        return this.regex;
    }
}

