/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConstants;
import org.wso2.carbon.event.receiver.core.config.InputMapping;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.TextInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverValidationException;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverConfigurationBuilder;

public class TextInputMapperConfigurationBuilder {
    private static TextInputMapperConfigurationBuilder instance = new TextInputMapperConfigurationBuilder();

    private TextInputMapperConfigurationBuilder() {
    }

    public static TextInputMapperConfigurationBuilder getInstance() {
        return instance;
    }

    public static void validateTextMapping(OMElement omElement) throws EventReceiverConfigurationException {
        ArrayList<String> supportedChildTags = new ArrayList<String>();
        supportedChildTags.add("property");
        String customMappingEnabledAttribute = omElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            int count = 0;
            Iterator mappingIterator = omElement.getChildElements();
            while (mappingIterator.hasNext()) {
                ++count;
                OMElement childElement = (OMElement)mappingIterator.next();
                String childTag = childElement.getLocalName();
                if (!supportedChildTags.contains(childTag)) {
                    throw new EventReceiverConfigurationException("Unsupported XML configuration element for Text Input Mapping : " + childTag);
                }
                if (!childTag.equals("property")) continue;
                OMElement propertyFromElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
                OMElement propertyToElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
                if (propertyFromElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'from' element");
                }
                if (propertyToElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'to' element");
                }
                if (propertyToElement.getAttribute(new QName("name")) != null && propertyToElement.getAttribute(new QName("type")) != null) continue;
                throw new EventReceiverConfigurationException("An attribute mapping must provide name and type for its 'to' element.");
            }
            if (count == 0) {
                throw new EventReceiverConfigurationException("There must be at least 1 attribute mapping with Custom Mapping enabled.");
            }
        }
    }

    public InputMapping fromOM(OMElement mappingElement) throws EventReceiverValidationException, EventReceiverConfigurationException {
        TextInputMapperConfigurationBuilder.validateTextMapping(mappingElement);
        TextInputMapping textInputMapping = new TextInputMapping();
        String customMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            textInputMapping.setCustomMappingEnabled(true);
            Iterator propertyIterator = mappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "property"));
            ArrayList<InputMappingAttribute> inputMappingAttributeList = new ArrayList<InputMappingAttribute>();
            while (propertyIterator.hasNext()) {
                OMElement propertyOMElement = (OMElement)propertyIterator.next();
                inputMappingAttributeList.addAll(this.getInputMappingAttributesFromOM(propertyOMElement));
            }
            for (InputMappingAttribute inputMappingAttribute : inputMappingAttributeList) {
                textInputMapping.addInputMappingAttribute(inputMappingAttribute);
            }
        } else {
            textInputMapping.setCustomMappingEnabled(false);
        }
        return textInputMapping;
    }

    public OMElement inputMappingToOM(InputMapping inputMapping, OMFactory factory) {
        TextInputMapping textInputMapping = (TextInputMapping)inputMapping;
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        mappingOMElement.addAttribute("type", "text", null);
        if (textInputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        List<InputMappingAttribute> inputMappingAttributes = textInputMapping.getInputMappingAttributes();
        InputMappingAttribute prevInputMappingAttribute = null;
        OMElement propertyOMElement = null;
        for (InputMappingAttribute inputMappingAttribute : inputMappingAttributes) {
            if (prevInputMappingAttribute != null && prevInputMappingAttribute.getFromElementKey().equals(inputMappingAttribute.getFromElementKey())) {
                this.addAnotherToProperty(factory, propertyOMElement, inputMappingAttribute);
            } else {
                propertyOMElement = this.getPropertyOmElement(factory, inputMappingAttribute);
                propertyOMElement.setNamespace(mappingOMElement.getDefaultNamespace());
                mappingOMElement.addChild((OMNode)propertyOMElement);
            }
            prevInputMappingAttribute = inputMappingAttribute;
        }
        return mappingOMElement;
    }

    private List<InputMappingAttribute> getInputMappingAttributesFromOM(OMElement omElement) {
        OMElement propertyFromElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        Iterator toElementIterator = omElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        ArrayList<InputMappingAttribute> inputMappingAttributeList = new ArrayList<InputMappingAttribute>();
        while (toElementIterator.hasNext()) {
            OMElement propertyToElement = (OMElement)toElementIterator.next();
            String regex = propertyFromElement.getAttributeValue(new QName("regex"));
            String outputPropertyName = propertyToElement.getAttributeValue(new QName("name"));
            String attributeType = propertyToElement.getAttributeValue(new QName("type"));
            AttributeType outputPropertyType = EventReceiverConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attributeType.toLowerCase());
            String defaultValue = propertyToElement.getAttributeValue(new QName("default"));
            InputMappingAttribute inputMappingAttribute = new InputMappingAttribute(regex, outputPropertyName, outputPropertyType);
            inputMappingAttribute.setDefaultValue(defaultValue);
            inputMappingAttributeList.add(inputMappingAttribute);
        }
        return inputMappingAttributeList;
    }

    private OMElement getPropertyOmElement(OMFactory factory, InputMappingAttribute inputMappingAttribute) {
        OMElement propertyOmElement = factory.createOMElement(new QName("property"));
        OMElement fromElement = factory.createOMElement(new QName("from"));
        fromElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        fromElement.addAttribute("regex", inputMappingAttribute.getFromElementKey(), null);
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        toElement.addAttribute("name", inputMappingAttribute.getToElementKey(), null);
        toElement.addAttribute("type", EventReceiverConfigurationBuilder.getAttributeType(inputMappingAttribute.getToElementType()), null);
        if (inputMappingAttribute.getDefaultValue() != null && !inputMappingAttribute.getDefaultValue().isEmpty()) {
            toElement.addAttribute("default", inputMappingAttribute.getDefaultValue(), null);
        }
        propertyOmElement.addChild((OMNode)fromElement);
        propertyOmElement.addChild((OMNode)toElement);
        return propertyOmElement;
    }

    private void addAnotherToProperty(OMFactory factory, OMElement propertyOmElement, InputMappingAttribute inputMappingAttribute) {
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        toElement.addAttribute("name", inputMappingAttribute.getToElementKey(), null);
        toElement.addAttribute("type", EventReceiverConfigurationBuilder.getAttributeType(inputMappingAttribute.getToElementType()), null);
        if (inputMappingAttribute.getDefaultValue() != null && !inputMappingAttribute.getDefaultValue().isEmpty()) {
            toElement.addAttribute("default", inputMappingAttribute.getDefaultValue(), null);
        }
        propertyOmElement.addChild((OMNode)toElement);
    }
}

