/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.text;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.receiver.core.InputMapper;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConstants;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.TextInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverProcessingException;
import org.wso2.carbon.event.receiver.core.internal.type.text.config.RegexData;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;

public class TextInputMapper
implements InputMapper {
    private List<RegexData> attributeRegexList;
    private EventReceiverConfiguration eventReceiverConfiguration;
    private int[] attributePositions;
    private static final Log log = LogFactory.getLog(TextInputMapper.class);
    private int noMetaData;
    private int noCorrelationData;
    private int noPayloadData;
    private Map<String, AttributeType> attributeDescriptionMap;
    private StreamDefinition streamDefinition;

    public TextInputMapper(EventReceiverConfiguration eventReceiverConfiguration, StreamDefinition streamDefinition) throws EventReceiverConfigurationException {
        block11: {
            block12: {
                this.attributeRegexList = new ArrayList<RegexData>();
                this.eventReceiverConfiguration = null;
                this.attributeDescriptionMap = new LinkedHashMap<String, AttributeType>();
                this.streamDefinition = null;
                this.eventReceiverConfiguration = eventReceiverConfiguration;
                this.streamDefinition = streamDefinition;
                if (eventReceiverConfiguration == null || !(eventReceiverConfiguration.getInputMapping() instanceof TextInputMapping)) break block11;
                if (!eventReceiverConfiguration.getInputMapping().isCustomMappingEnabled()) break block12;
                TextInputMapping textInputMapping = (TextInputMapping)eventReceiverConfiguration.getInputMapping();
                RegexData regexData = null;
                if (textInputMapping.getInputMappingAttributes() == null && textInputMapping.getInputMappingAttributes().size() != 0) {
                    throw new EventReceiverConfigurationException("Text input mapping attribute list cannot be null!");
                }
                this.attributePositions = new int[textInputMapping.getInputMappingAttributes().size()];
                LinkedList<Integer> attribPositionList = new LinkedList<Integer>();
                for (InputMappingAttribute inputMappingAttribute : textInputMapping.getInputMappingAttributes()) {
                    String regex = inputMappingAttribute.getFromElementKey();
                    if (regexData == null || !regex.equals(regexData.getRegex())) {
                        try {
                            regexData = new RegexData(regex);
                            this.attributeRegexList.add(regexData);
                        }
                        catch (PatternSyntaxException e) {
                            throw new EventReceiverConfigurationException("Error parsing regular expression: " + regex, e);
                        }
                    }
                    attribPositionList.add(this.getEventAttributeLocation(inputMappingAttribute, streamDefinition));
                    String type = EventReceiverConstants.ATTRIBUTE_TYPE_CLASS_TYPE_MAP.get(inputMappingAttribute.getToElementType());
                    String defaultValue = inputMappingAttribute.getDefaultValue();
                    regexData.addMapping(type, defaultValue);
                }
                for (int i = 0; i < attribPositionList.size(); ++i) {
                    this.attributePositions[i] = (Integer)attribPositionList.get(i);
                }
                break block11;
            }
            this.noMetaData = streamDefinition.getMetaData() != null ? streamDefinition.getMetaData().size() : 0;
            this.noCorrelationData += streamDefinition.getCorrelationData() != null ? streamDefinition.getCorrelationData().size() : 0;
            this.noPayloadData += streamDefinition.getPayloadData() != null ? streamDefinition.getPayloadData().size() : 0;
            if (this.noMetaData > 0) {
                for (Attribute metaData : streamDefinition.getMetaData()) {
                    this.attributeDescriptionMap.put("meta_" + metaData.getName(), metaData.getType());
                }
            }
            if (this.noCorrelationData > 0) {
                for (Attribute correlationData : streamDefinition.getCorrelationData()) {
                    this.attributeDescriptionMap.put("correlation_" + correlationData.getName(), correlationData.getType());
                }
            }
            if (this.noPayloadData <= 0) break block11;
            for (Attribute payloadData : streamDefinition.getPayloadData()) {
                this.attributeDescriptionMap.put(payloadData.getName(), payloadData.getType());
            }
        }
    }

    @Override
    public Object convertToMappedInputEvent(Object obj) throws EventReceiverProcessingException {
        Object[] attributeArray = new Object[this.attributePositions.length];
        StreamDefinition outStreamDefinition = this.streamDefinition;
        int metaDataCount = outStreamDefinition.getMetaData() != null ? outStreamDefinition.getMetaData().size() : 0;
        int correlationDataCount = outStreamDefinition.getCorrelationData() != null ? outStreamDefinition.getCorrelationData().size() : 0;
        int payloadDataCount = outStreamDefinition.getPayloadData() != null ? outStreamDefinition.getPayloadData().size() : 0;
        Object[] metaDataArray = new Object[metaDataCount];
        Object[] correlationDataArray = new Object[correlationDataCount];
        Object[] payloadDataArray = new Object[payloadDataCount];
        if (obj instanceof String) {
            String inputString = (String)obj;
            int attributeCount = 0;
            for (RegexData regexData : this.attributeRegexList) {
                String formattedInputString = inputString.replaceAll("\\r", "");
                regexData.matchInput(formattedInputString);
                while (regexData.hasNext()) {
                    Object returnedAttribute = null;
                    String value = regexData.next();
                    if (value != null) {
                        String type = regexData.getType();
                        try {
                            Class<?> beanClass = Class.forName(type);
                            if (!beanClass.equals(String.class)) {
                                Class<String> stringClass = String.class;
                                Method valueOfMethod = beanClass.getMethod("valueOf", stringClass);
                                returnedAttribute = valueOfMethod.invoke(null, value);
                            } else {
                                returnedAttribute = value;
                            }
                        }
                        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                            throw new EventReceiverProcessingException("Cannot convert " + value + " to type " + type, e);
                        }
                        catch (InvocationTargetException e) {
                            log.warn((Object)("Cannot convert " + value + " to type " + type + ": " + e.getMessage() + "; Sending null value."));
                        }
                    }
                    attributeArray[this.attributePositions[attributeCount++]] = returnedAttribute;
                }
            }
        }
        return EventReceiverUtil.getEventFromArray(attributeArray, outStreamDefinition, metaDataArray, correlationDataArray, payloadDataArray);
    }

    @Override
    public Object convertToTypedInputEvent(Object obj) throws EventReceiverProcessingException {
        Object[] attributeArray = new Object[this.noMetaData + this.noCorrelationData + this.noPayloadData];
        StreamDefinition outStreamDefinition = this.streamDefinition;
        int metaDataCount = outStreamDefinition.getMetaData() != null ? outStreamDefinition.getMetaData().size() : 0;
        int correlationDataCount = outStreamDefinition.getCorrelationData() != null ? outStreamDefinition.getCorrelationData().size() : 0;
        int payloadDataCount = outStreamDefinition.getPayloadData() != null ? outStreamDefinition.getPayloadData().size() : 0;
        Object[] metaDataArray = new Object[metaDataCount];
        Object[] correlationDataArray = new Object[correlationDataCount];
        Object[] payloadDataArray = new Object[payloadDataCount];
        if (obj instanceof String) {
            String[] eventAttributes;
            String inputString = ((String)obj).trim();
            int attributeCount = 0;
            for (String eventAttribute : eventAttributes = inputString.trim().split(",")) {
                String[] textEvent = eventAttribute.split(":");
                try {
                    AttributeType attributeType;
                    if (textEvent.length == 2) {
                        attributeType = this.attributeDescriptionMap.get(textEvent[0].trim());
                        if (attributeType != null) {
                            attributeArray[attributeCount++] = this.getPropertyValue(textEvent[1], attributeType);
                            continue;
                        }
                        throw new EventReceiverProcessingException("Event attributes are not matching with the stream, hence dropping event attribute " + eventAttribute);
                    }
                    if (textEvent.length == 0) {
                        throw new EventReceiverProcessingException("Invalid attribute value found for event ,hence dropping the event " + eventAttribute);
                    }
                    if (textEvent.length != 1) continue;
                    attributeType = this.attributeDescriptionMap.get(textEvent[0].trim());
                    if (AttributeType.STRING.equals((Object)attributeType)) {
                        attributeArray[attributeCount++] = "";
                        continue;
                    }
                    throw new EventReceiverProcessingException("Attribute value not found in the event, hence dropping event " + eventAttribute);
                }
                catch (NumberFormatException e) {
                    throw new EventReceiverProcessingException("Unable to cast the input data to required type for attribute " + eventAttribute + ", hence dropping the event.", e);
                }
            }
            if (this.noMetaData + this.noCorrelationData + this.noPayloadData != attributeCount) {
                throw new EventReceiverProcessingException("Event attributes are not matching with the stream : " + this.eventReceiverConfiguration.getToStreamName() + ":" + this.eventReceiverConfiguration.getToStreamVersion());
            }
        }
        return EventReceiverUtil.getEventFromArray(attributeArray, outStreamDefinition, metaDataArray, correlationDataArray, payloadDataArray);
    }

    @Override
    public Attribute[] getOutputAttributes() {
        TextInputMapping textInputMapping = (TextInputMapping)this.eventReceiverConfiguration.getInputMapping();
        List<InputMappingAttribute> inputMappingAttributes = textInputMapping.getInputMappingAttributes();
        return EventReceiverConfigurationHelper.getAttributes(inputMappingAttributes);
    }

    private Object getPropertyValue(String propertyValue, AttributeType attributeType) {
        if (AttributeType.BOOL.equals((Object)attributeType)) {
            return Boolean.parseBoolean(propertyValue);
        }
        if (AttributeType.DOUBLE.equals((Object)attributeType)) {
            return Double.parseDouble(propertyValue);
        }
        if (AttributeType.FLOAT.equals((Object)attributeType)) {
            return Float.valueOf(Float.parseFloat(propertyValue));
        }
        if (AttributeType.INT.equals((Object)attributeType)) {
            return Integer.parseInt(propertyValue);
        }
        if (AttributeType.LONG.equals((Object)attributeType)) {
            return Long.parseLong(propertyValue);
        }
        return propertyValue;
    }

    private int getEventAttributeLocation(InputMappingAttribute inputMappingAttribute, StreamDefinition streamDefinition) {
        int correlationSize;
        int attributeLocation = 0;
        int metaSize = streamDefinition.getMetaData() != null ? streamDefinition.getMetaData().size() : 0;
        int n = correlationSize = streamDefinition.getCorrelationData() != null ? streamDefinition.getCorrelationData().size() : 0;
        if (EventReceiverUtil.isMetaAttribute(inputMappingAttribute.getToElementKey())) {
            for (Attribute metaAttribute : streamDefinition.getMetaData()) {
                if ("meta_".concat(metaAttribute.getName()).equals(inputMappingAttribute.getToElementKey())) {
                    return attributeLocation;
                }
                ++attributeLocation;
            }
        } else if (EventReceiverUtil.isCorrelationAttribute(inputMappingAttribute.getToElementKey())) {
            for (Attribute correlationData : streamDefinition.getCorrelationData()) {
                if ("correlation_".concat(correlationData.getName()).equals(inputMappingAttribute.getToElementKey())) {
                    return attributeLocation + metaSize;
                }
                ++attributeLocation;
            }
        } else {
            for (Attribute payloadData : streamDefinition.getPayloadData()) {
                if (payloadData.getName().equals(inputMappingAttribute.getToElementKey())) {
                    return attributeLocation + metaSize + correlationSize;
                }
                ++attributeLocation;
            }
        }
        return -1;
    }
}

