/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.map;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConstants;
import org.wso2.carbon.event.receiver.core.config.InputMapping;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.MapInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverValidationException;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverConfigurationBuilder;

public class MapInputMappingConfigBuilder {
    private static MapInputMappingConfigBuilder instance = new MapInputMappingConfigBuilder();

    private MapInputMappingConfigBuilder() {
    }

    public static MapInputMappingConfigBuilder getInstance() {
        return instance;
    }

    public static void validateMapEventMapping(OMElement omElement) throws EventReceiverConfigurationException {
        String customMappingEnabledAttribute = omElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            int count = 0;
            Iterator mappingIterator = omElement.getChildElements();
            while (mappingIterator.hasNext()) {
                ++count;
                OMElement childElement = (OMElement)mappingIterator.next();
                String childTag = childElement.getLocalName();
                if (!"property".equals(childTag)) {
                    throw new EventReceiverConfigurationException("Unsupported XML configuration element for Map Input Mapping : " + childTag);
                }
                if (!childTag.equals("property")) continue;
                OMElement propertyFromElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
                OMElement propertyToElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
                if (propertyFromElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'from' element");
                }
                if (propertyToElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'to' element");
                }
                if (propertyToElement.getAttribute(new QName("name")) != null && propertyToElement.getAttribute(new QName("type")) != null) continue;
                throw new EventReceiverConfigurationException("An attribute mapping must provide name and type for its 'to' element.");
            }
            if (count == 0) {
                throw new EventReceiverConfigurationException("There must be at least 1 attribute mapping with Custom Mapping enabled.");
            }
        }
    }

    private OMElement getPropertyOmElement(OMFactory factory, InputMappingAttribute inputMappingAttribute) {
        OMElement propertyOMElement = factory.createOMElement(new QName("property"));
        OMElement fromElement = factory.createOMElement(new QName("from"));
        fromElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        fromElement.addAttribute("name", inputMappingAttribute.getFromElementKey(), null);
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        toElement.addAttribute("name", inputMappingAttribute.getToElementKey(), null);
        toElement.addAttribute("type", EventReceiverConfigurationBuilder.getAttributeType(inputMappingAttribute.getToElementType()), null);
        if (inputMappingAttribute.getDefaultValue() != null && !inputMappingAttribute.getDefaultValue().isEmpty()) {
            toElement.addAttribute("default", inputMappingAttribute.getDefaultValue(), null);
        }
        propertyOMElement.addChild((OMNode)fromElement);
        propertyOMElement.addChild((OMNode)toElement);
        return propertyOMElement;
    }

    public InputMapping fromOM(OMElement mappingElement) throws EventReceiverValidationException, EventReceiverConfigurationException {
        MapInputMappingConfigBuilder.validateMapEventMapping(mappingElement);
        MapInputMapping mapInputMapping = new MapInputMapping();
        String customMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            mapInputMapping.setCustomMappingEnabled(true);
            Iterator propertyIterator = mappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "property"));
            int positionCount = 0;
            while (propertyIterator.hasNext()) {
                OMElement propertyOMElement = (OMElement)propertyIterator.next();
                InputMappingAttribute inputMappingAttribute = this.getInputMappingAttributeFromOM(propertyOMElement);
                inputMappingAttribute.setToStreamPosition(positionCount++);
                mapInputMapping.addInputMappingAttribute(inputMappingAttribute);
            }
        } else {
            mapInputMapping.setCustomMappingEnabled(false);
        }
        return mapInputMapping;
    }

    public OMElement inputMappingToOM(InputMapping outputMapping, OMFactory factory) {
        MapInputMapping mapInputMapping = (MapInputMapping)outputMapping;
        List<InputMappingAttribute> inputMappingAttributes = mapInputMapping.getInputMappingAttributes();
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        mappingOMElement.addAttribute("type", "map", null);
        if (mapInputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        if (inputMappingAttributes.size() > 0) {
            for (InputMappingAttribute inputMappingAttribute : inputMappingAttributes) {
                OMElement propertyOMElement = this.getPropertyOmElement(factory, inputMappingAttribute);
                propertyOMElement.setNamespace(mappingOMElement.getDefaultNamespace());
                mappingOMElement.addChild((OMNode)propertyOMElement);
            }
        }
        return mappingOMElement;
    }

    private InputMappingAttribute getInputMappingAttributeFromOM(OMElement omElement) {
        OMElement propertyFromElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        OMElement propertyToElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        String name = propertyFromElement.getAttributeValue(new QName("name"));
        String valueOf = propertyToElement.getAttributeValue(new QName("name"));
        String attributeType = propertyToElement.getAttributeValue(new QName("type"));
        String defaultVal = propertyToElement.getAttributeValue(new QName("default"));
        AttributeType type = EventReceiverConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attributeType.toLowerCase());
        if (valueOf == null) {
            valueOf = name;
        }
        InputMappingAttribute mappingAttribute = new InputMappingAttribute(name, valueOf, type);
        mappingAttribute.setDefaultValue(defaultVal);
        return mappingAttribute;
    }
}

