/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.receiver.core.InputMapper;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.MapInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverProcessingException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverStreamValidationException;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;

public class MapInputMapper
implements InputMapper {
    private int noMetaData;
    private int noCorrelationData;
    private int noPayloadData;
    private StreamDefinition streamDefinition;
    private Object[] attributePositionKeyMap = null;
    private Object[] attributeDefaultValueKeyMap = null;
    private EventReceiverConfiguration eventReceiverConfiguration = null;

    public MapInputMapper(EventReceiverConfiguration eventReceiverConfiguration, StreamDefinition streamDefinition) throws EventReceiverConfigurationException {
        this.eventReceiverConfiguration = eventReceiverConfiguration;
        this.streamDefinition = streamDefinition;
        if (eventReceiverConfiguration != null && eventReceiverConfiguration.getInputMapping() instanceof MapInputMapping) {
            MapInputMapping mapInputMapping = (MapInputMapping)eventReceiverConfiguration.getInputMapping();
            if (mapInputMapping.isCustomMappingEnabled()) {
                HashMap<Integer, String> positionKeyMap = new HashMap<Integer, String>();
                HashMap<Integer, String> defaultValueMap = new HashMap<Integer, String>();
                for (InputMappingAttribute inputMappingAttribute : mapInputMapping.getInputMappingAttributes()) {
                    positionKeyMap.put(inputMappingAttribute.getToStreamPosition(), inputMappingAttribute.getFromElementKey());
                    defaultValueMap.put(inputMappingAttribute.getToStreamPosition(), inputMappingAttribute.getDefaultValue());
                    if (positionKeyMap.get(inputMappingAttribute.getToStreamPosition()) != null) continue;
                    this.attributePositionKeyMap = null;
                    throw new EventReceiverStreamValidationException("Error creating map mapping. '" + inputMappingAttribute.getToElementKey() + "' position not found.", streamDefinition.getStreamId());
                }
                this.attributePositionKeyMap = new Object[positionKeyMap.size()];
                this.attributeDefaultValueKeyMap = new Object[positionKeyMap.size()];
                for (int i = 0; i < this.attributePositionKeyMap.length; ++i) {
                    this.attributePositionKeyMap[i] = positionKeyMap.get(i);
                    this.attributeDefaultValueKeyMap[i] = defaultValueMap.get(i);
                }
            } else {
                this.noMetaData = streamDefinition.getMetaData() != null ? streamDefinition.getMetaData().size() : 0;
                this.noCorrelationData += streamDefinition.getCorrelationData() != null ? streamDefinition.getCorrelationData().size() : 0;
                this.noPayloadData += streamDefinition.getPayloadData() != null ? streamDefinition.getPayloadData().size() : 0;
            }
        }
    }

    @Override
    public Object convertToMappedInputEvent(Object obj) throws EventReceiverProcessingException {
        ArrayList<Object> outObjList;
        if (this.attributePositionKeyMap == null) {
            throw new EventReceiverProcessingException("Input mapping is not available for the current input stream definition:");
        }
        StreamDefinition outStreamDefinition = this.streamDefinition;
        int metaDataCount = outStreamDefinition.getMetaData() != null ? outStreamDefinition.getMetaData().size() : 0;
        int correlationDataCount = outStreamDefinition.getCorrelationData() != null ? outStreamDefinition.getCorrelationData().size() : 0;
        int payloadDataCount = outStreamDefinition.getPayloadData() != null ? outStreamDefinition.getPayloadData().size() : 0;
        Object[] metaDataArray = new Object[metaDataCount];
        Object[] correlationDataArray = new Object[correlationDataCount];
        Object[] payloadDataArray = new Object[payloadDataCount];
        if (obj instanceof Map) {
            Map eventMap = (Map)obj;
            outObjList = new ArrayList<Object>();
            for (int i = 0; i < this.attributePositionKeyMap.length; ++i) {
                if (eventMap.get(this.attributePositionKeyMap[i]) == null) {
                    outObjList.add(this.attributeDefaultValueKeyMap[i]);
                    continue;
                }
                outObjList.add(eventMap.get(this.attributePositionKeyMap[i]));
            }
        } else {
            throw new EventReceiverProcessingException("Received event object is not of type map." + this.getClass() + " cannot convert this event.");
        }
        Object[] outObjArray = outObjList.toArray();
        return EventReceiverUtil.getEventFromArray(outObjArray, outStreamDefinition, metaDataArray, correlationDataArray, payloadDataArray);
    }

    @Override
    public Object convertToTypedInputEvent(Object obj) throws EventReceiverProcessingException {
        Object[] metaDataAttributeArray = new Object[this.noMetaData];
        Object[] correlationDataAttributeArray = new Object[this.noCorrelationData];
        Object[] payloadDataAttributeArray = new Object[this.noPayloadData];
        int attributeCount = 0;
        if (obj instanceof Map) {
            Object mapAttribute;
            Map eventMap = (Map)obj;
            if (this.noMetaData > 0) {
                int metaAttributeCount = 0;
                for (Attribute metaData : this.streamDefinition.getMetaData()) {
                    mapAttribute = eventMap.get("meta_" + metaData.getName());
                    if (mapAttribute != null || AttributeType.STRING.equals((Object)metaData.getType())) {
                        metaDataAttributeArray[metaAttributeCount++] = mapAttribute;
                        ++attributeCount;
                        continue;
                    }
                    throw new EventReceiverProcessingException("Non-string meta attribute '" + metaData.getName() + "' of type " + metaData.getType() + " is null.");
                }
            }
            if (this.noCorrelationData > 0) {
                int correlationAttributeCount = 0;
                for (Attribute correlationData : this.streamDefinition.getCorrelationData()) {
                    mapAttribute = eventMap.get("correlation_" + correlationData.getName());
                    if (mapAttribute != null || AttributeType.STRING.equals((Object)correlationData.getType())) {
                        correlationDataAttributeArray[correlationAttributeCount++] = mapAttribute;
                        ++attributeCount;
                        continue;
                    }
                    throw new EventReceiverProcessingException("Non-string correlation attribute '" + correlationData.getName() + "' of type " + correlationData.getType() + " is null.");
                }
            }
            if (this.noPayloadData > 0) {
                int payloadAttributeCount = 0;
                for (Attribute payloadData : this.streamDefinition.getPayloadData()) {
                    mapAttribute = eventMap.get(payloadData.getName());
                    if (mapAttribute != null || AttributeType.STRING.equals((Object)payloadData.getType())) {
                        payloadDataAttributeArray[payloadAttributeCount++] = mapAttribute;
                        ++attributeCount;
                        continue;
                    }
                    throw new EventReceiverProcessingException("Non-string payload attribute '" + payloadData.getName() + "' of type " + payloadData.getType() + " is null.");
                }
            }
            if (this.noMetaData + this.noCorrelationData + this.noPayloadData != attributeCount) {
                throw new EventReceiverProcessingException("Event attributes are not matching with the stream : " + this.eventReceiverConfiguration.getToStreamName() + ":" + this.eventReceiverConfiguration.getToStreamVersion());
            }
        } else {
            throw new EventReceiverProcessingException("Received event object is not of type map." + this.getClass() + " cannot convert this event.");
        }
        return new Event(this.streamDefinition.getStreamId(), System.currentTimeMillis(), metaDataAttributeArray, correlationDataAttributeArray, payloadDataAttributeArray);
    }

    @Override
    public Attribute[] getOutputAttributes() {
        MapInputMapping mapInputMapping = (MapInputMapping)this.eventReceiverConfiguration.getInputMapping();
        List<InputMappingAttribute> inputMappingAttributes = mapInputMapping.getInputMappingAttributes();
        return EventReceiverConfigurationHelper.getAttributes(inputMappingAttributes);
    }
}

