/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.json;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConstants;
import org.wso2.carbon.event.receiver.core.config.InputMapping;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.JSONInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverConfigurationBuilder;

public class JSONInputMapperConfigurationBuilder {
    private static JSONInputMapperConfigurationBuilder instance = new JSONInputMapperConfigurationBuilder();

    private JSONInputMapperConfigurationBuilder() {
    }

    public static JSONInputMapperConfigurationBuilder getInstance() {
        return instance;
    }

    public OMElement inputMappingToOM(InputMapping inputMapping, OMFactory factory) {
        JSONInputMapping jsonInputMapping = (JSONInputMapping)inputMapping;
        OMElement mappingOMElement = factory.createOMElement(new QName("mapping"));
        mappingOMElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        mappingOMElement.addAttribute("type", "json", null);
        if (jsonInputMapping.isCustomMappingEnabled()) {
            mappingOMElement.addAttribute("customMapping", "enable", null);
        } else {
            mappingOMElement.addAttribute("customMapping", "disable", null);
        }
        for (InputMappingAttribute inputMappingAttribute : jsonInputMapping.getInputMappingAttributes()) {
            OMElement propertyOMElement = this.getPropertyOmElement(factory, inputMappingAttribute);
            propertyOMElement.setNamespace(mappingOMElement.getDefaultNamespace());
            mappingOMElement.addChild((OMNode)propertyOMElement);
        }
        return mappingOMElement;
    }

    private InputMappingAttribute getInputMappingAttributeFromOM(OMElement omElement) {
        OMElement propertyFromElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
        OMElement propertyToElement = omElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
        String jsonPath = propertyFromElement.getAttributeValue(new QName("jsonPath"));
        String outputPropertyName = propertyToElement.getAttributeValue(new QName("name"));
        String attributeType = propertyToElement.getAttributeValue(new QName("type"));
        AttributeType outputPropertyType = EventReceiverConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attributeType.toLowerCase());
        String defaultValue = propertyToElement.getAttributeValue(new QName("default"));
        InputMappingAttribute inputMappingAttribute = new InputMappingAttribute(jsonPath, outputPropertyName, outputPropertyType);
        inputMappingAttribute.setDefaultValue(defaultValue);
        return inputMappingAttribute;
    }

    private OMElement getPropertyOmElement(OMFactory factory, InputMappingAttribute inputMappingAttribute) {
        OMElement propertyOmElement = factory.createOMElement(new QName("property"));
        OMElement fromElement = factory.createOMElement(new QName("from"));
        fromElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        fromElement.addAttribute("jsonPath", inputMappingAttribute.getFromElementKey(), null);
        OMElement toElement = factory.createOMElement(new QName("to"));
        toElement.declareDefaultNamespace("http://wso2.org/carbon/eventreceiver");
        toElement.addAttribute("name", inputMappingAttribute.getToElementKey(), null);
        toElement.addAttribute("type", EventReceiverConfigurationBuilder.getAttributeType(inputMappingAttribute.getToElementType()), null);
        if (inputMappingAttribute.getDefaultValue() != null && !inputMappingAttribute.getDefaultValue().isEmpty()) {
            toElement.addAttribute("default", inputMappingAttribute.getDefaultValue(), null);
        }
        propertyOmElement.addChild((OMNode)fromElement);
        propertyOmElement.addChild((OMNode)toElement);
        return propertyOmElement;
    }

    public InputMapping fromOM(OMElement mappingElement) throws EventReceiverConfigurationException {
        JSONInputMapperConfigurationBuilder.validateJsonEventMapping(mappingElement);
        JSONInputMapping jsonInputMapping = new JSONInputMapping();
        String customMappingEnabledAttribute = mappingElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            jsonInputMapping.setCustomMappingEnabled(true);
            Iterator propertyIterator = mappingElement.getChildrenWithName(new QName("http://wso2.org/carbon/eventreceiver", "property"));
            while (propertyIterator.hasNext()) {
                OMElement propertyOMElement = (OMElement)propertyIterator.next();
                InputMappingAttribute inputMappingAttribute = this.getInputMappingAttributeFromOM(propertyOMElement);
                jsonInputMapping.addInputMappingAttribute(inputMappingAttribute);
            }
        } else {
            jsonInputMapping.setCustomMappingEnabled(false);
        }
        return jsonInputMapping;
    }

    public static void validateJsonEventMapping(OMElement omElement) throws EventReceiverConfigurationException {
        String customMappingEnabledAttribute = omElement.getAttributeValue(new QName("customMapping"));
        if (customMappingEnabledAttribute == null || customMappingEnabledAttribute.equalsIgnoreCase("enable")) {
            ArrayList<String> supportedChildTags = new ArrayList<String>();
            supportedChildTags.add("property");
            Iterator mappingIterator = omElement.getChildElements();
            int count = 0;
            while (mappingIterator.hasNext()) {
                ++count;
                OMElement childElement = (OMElement)mappingIterator.next();
                String childTag = childElement.getLocalName();
                if (!supportedChildTags.contains(childTag)) {
                    throw new EventReceiverConfigurationException("Unsupported XML configuration element for JSON Input Mapping : " + childTag);
                }
                if (!childTag.equals("property")) continue;
                OMElement propertyFromElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "from"));
                OMElement propertyToElement = childElement.getFirstChildWithName(new QName("http://wso2.org/carbon/eventreceiver", "to"));
                if (propertyFromElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'from' element");
                }
                if (propertyToElement == null) {
                    throw new EventReceiverConfigurationException("An attribute mapping must provide a valid 'to' element");
                }
                if (propertyToElement.getAttribute(new QName("name")) != null && propertyToElement.getAttribute(new QName("type")) != null) continue;
                throw new EventReceiverConfigurationException("An attribute mapping must provide name and type for its 'to' element.");
            }
            if (count == 0) {
                throw new EventReceiverConfigurationException("There must be at least 1 attribute mapping with Custom Mapping enabled.");
            }
        }
    }
}

