/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.type.json;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.receiver.core.InputMapper;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.InputMappingAttribute;
import org.wso2.carbon.event.receiver.core.config.mapping.JSONInputMapping;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverProcessingException;
import org.wso2.carbon.event.receiver.core.exception.InvalidPropertyValueException;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;

public class JSONInputMapper
implements InputMapper {
    private static final Log log = LogFactory.getLog(JSONInputMapper.class);
    private EventReceiverConfiguration eventReceiverConfiguration = null;
    private List<JsonPathData> attributeJsonPathDataList = new ArrayList<JsonPathData>();
    private int noMetaData;
    private int noCorrelationData;
    private int noPayloadData;
    private StreamDefinition streamDefinition;

    public JSONInputMapper(EventReceiverConfiguration eventReceiverConfiguration, StreamDefinition streamDefinition) throws EventReceiverConfigurationException {
        this.eventReceiverConfiguration = eventReceiverConfiguration;
        this.streamDefinition = streamDefinition;
        if (eventReceiverConfiguration != null && eventReceiverConfiguration.getInputMapping() instanceof JSONInputMapping) {
            JSONInputMapping jsonInputMapping = (JSONInputMapping)eventReceiverConfiguration.getInputMapping();
            if (jsonInputMapping.isCustomMappingEnabled()) {
                this.createAttributeJsonPathList(streamDefinition, jsonInputMapping.getInputMappingAttributes());
            } else {
                this.noMetaData = streamDefinition.getMetaData() != null ? streamDefinition.getMetaData().size() : 0;
                this.noCorrelationData += streamDefinition.getCorrelationData() != null ? streamDefinition.getCorrelationData().size() : 0;
                this.noPayloadData += streamDefinition.getPayloadData() != null ? streamDefinition.getPayloadData().size() : 0;
            }
        }
    }

    @Override
    public Object convertToMappedInputEvent(Object obj) throws EventReceiverProcessingException {
        Event outObject = null;
        if (obj instanceof String) {
            String jsonString = (String)obj;
            outObject = jsonString.startsWith("[") ? this.processMultipleEvents(obj) : this.processSingleEvent(obj);
        }
        return outObject;
    }

    @Override
    public Object convertToTypedInputEvent(Object obj) throws EventReceiverProcessingException {
        Event outObject = null;
        if (obj instanceof String) {
            String jsonString = (String)obj;
            outObject = jsonString.startsWith("[") ? this.processTypedMultipleEvents(obj) : this.processTypedSingleEvent(obj);
        }
        return outObject;
    }

    @Override
    public Attribute[] getOutputAttributes() {
        JSONInputMapping jsonInputMapping = (JSONInputMapping)this.eventReceiverConfiguration.getInputMapping();
        List<InputMappingAttribute> inputMappingAttributes = jsonInputMapping.getInputMappingAttributes();
        return EventReceiverConfigurationHelper.getAttributes(inputMappingAttributes);
    }

    private Event[] processMultipleEvents(Object obj) throws EventReceiverProcessingException {
        Event[] events = null;
        if (obj instanceof String) {
            String stringEvents = (String)obj;
            try {
                JSONArray jsonArray = new JSONArray(stringEvents);
                events = new Event[jsonArray.length()];
                for (int i = 0; i < jsonArray.length(); ++i) {
                    events[i] = this.processSingleEvent(jsonArray.getJSONObject(i).toString());
                }
            }
            catch (JSONException e) {
                throw new EventReceiverProcessingException("Error in parsing JSON: ", e);
            }
        }
        return events;
    }

    private Event processSingleEvent(Object obj) throws EventReceiverProcessingException {
        Object[] outObjArray = null;
        StreamDefinition outStreamDefinition = this.streamDefinition;
        int metaDataCount = outStreamDefinition.getMetaData() != null ? outStreamDefinition.getMetaData().size() : 0;
        int correlationDataCount = outStreamDefinition.getCorrelationData() != null ? outStreamDefinition.getCorrelationData().size() : 0;
        int payloadDataCount = outStreamDefinition.getPayloadData() != null ? outStreamDefinition.getPayloadData().size() : 0;
        Object[] metaDataArray = new Object[metaDataCount];
        Object[] correlationDataArray = new Object[correlationDataCount];
        Object[] payloadDataArray = new Object[payloadDataCount];
        if (obj instanceof String) {
            String jsonString = (String)obj;
            ArrayList<Object> objList = new ArrayList<Object>();
            for (JsonPathData jsonPathData : this.attributeJsonPathDataList) {
                JsonPath jsonPath = jsonPathData.getJsonPath();
                AttributeType type = jsonPathData.getType();
                try {
                    Object resultObject = null;
                    Object returnedObj = null;
                    try {
                        resultObject = jsonPath.read(jsonString);
                    }
                    catch (InvalidPathException e) {
                        log.debug((Object)(e.getMessage() + ". Could not find match for JSONPath : " + jsonPath.toString() + " for event: " + obj.toString()));
                    }
                    if (resultObject == null) {
                        if (jsonPathData.getDefaultValue() != null && !jsonPathData.getDefaultValue().isEmpty()) {
                            returnedObj = this.getPropertyValue(jsonPathData.getDefaultValue(), type);
                            log.debug((Object)"Unable to parse JSONPath to retrieve required attribute. Sending defaults.");
                        } else if (!AttributeType.STRING.equals((Object)jsonPathData.getType())) {
                            throw new InvalidPropertyValueException("Found Invalid property value null for attribute ");
                        }
                    } else {
                        try {
                            returnedObj = this.getPropertyValue(resultObject, type);
                        }
                        catch (NumberFormatException e) {
                            if (!AttributeType.STRING.equals((Object)type) && jsonPathData.getDefaultValue() != null) {
                                returnedObj = this.getPropertyValue(jsonPathData.getDefaultValue(), type);
                            }
                            throw e;
                        }
                    }
                    objList.add(returnedObj);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Unable to cast the input data to required type :" + type + " ,hence dropping the event " + obj.toString()), (Throwable)e);
                    return null;
                }
                catch (InvalidPropertyValueException e) {
                    log.error((Object)(e.getMessage() + " ,hence dropping the event : " + obj.toString()));
                    return null;
                }
            }
            outObjArray = objList.toArray(new Object[objList.size()]);
        }
        return EventReceiverUtil.getEventFromArray(outObjArray, outStreamDefinition, metaDataArray, correlationDataArray, payloadDataArray);
    }

    private Event[] processTypedMultipleEvents(Object obj) throws EventReceiverProcessingException {
        Event[] eventArray;
        String events = (String)obj;
        try {
            JSONArray jsonArray = new JSONArray(events);
            eventArray = new Event[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                eventArray[i] = this.processTypedSingleEvent(jsonArray.getJSONObject(i).toString());
            }
        }
        catch (JSONException e) {
            throw new EventReceiverProcessingException("Error in parsing JSON: ", e);
        }
        return eventArray;
    }

    private Event processTypedSingleEvent(Object obj) throws EventReceiverProcessingException {
        Object[] attributeArray = new Object[this.noMetaData + this.noCorrelationData + this.noPayloadData];
        int attributeCount = 0;
        StreamDefinition outStreamDefinition = this.streamDefinition;
        int metaDataCount = outStreamDefinition.getMetaData() != null ? outStreamDefinition.getMetaData().size() : 0;
        int correlationDataCount = outStreamDefinition.getCorrelationData() != null ? outStreamDefinition.getCorrelationData().size() : 0;
        int payloadDataCount = outStreamDefinition.getPayloadData() != null ? outStreamDefinition.getPayloadData().size() : 0;
        Object[] metaDataArray = new Object[metaDataCount];
        Object[] correlationDataArray = new Object[correlationDataCount];
        Object[] payloadDataArray = new Object[payloadDataCount];
        try {
            if (obj instanceof String) {
                Map<Object, Object> eventMap;
                JsonPath jsonPath;
                String jsonString = (String)obj;
                if (this.noMetaData > 0) {
                    jsonPath = JsonPath.compile((String)"$.event.metaData", (Predicate[])new Predicate[0]);
                    eventMap = null;
                    eventMap = this.parseEventToMap(jsonPath, jsonString);
                    if (eventMap == null) {
                        throw new EventReceiverProcessingException("Missing event MetaData attributes, Event does not match with the stream : " + this.eventReceiverConfiguration.getToStreamName() + ":" + this.eventReceiverConfiguration.getToStreamVersion());
                    }
                    for (Attribute metaData : this.streamDefinition.getMetaData()) {
                        if (eventMap.containsKey(metaData.getName())) {
                            attributeArray[attributeCount++] = this.getPropertyValue(eventMap.get(metaData.getName()), metaData.getType());
                            continue;
                        }
                        if (AttributeType.STRING.equals((Object)metaData.getType())) {
                            attributeArray[attributeCount++] = this.getPropertyValue(null, metaData.getType());
                            continue;
                        }
                        throw new InvalidPropertyValueException("Attribute " + metaData.getName() + " tag not found in the event hence Dropping event " + obj.toString());
                    }
                }
                if (this.noCorrelationData > 0) {
                    jsonPath = JsonPath.compile((String)"$.event.correlationData", (Predicate[])new Predicate[0]);
                    eventMap = null;
                    eventMap = this.parseEventToMap(jsonPath, jsonString);
                    if (eventMap == null) {
                        throw new EventReceiverProcessingException("Missing CorrelationData attributes, Event does not match with the stream : " + this.eventReceiverConfiguration.getToStreamName() + ":" + this.eventReceiverConfiguration.getToStreamVersion());
                    }
                    for (Attribute correlationData : this.streamDefinition.getCorrelationData()) {
                        if (eventMap.containsKey(correlationData.getName())) {
                            attributeArray[attributeCount++] = this.getPropertyValue(eventMap.get(correlationData.getName()), correlationData.getType());
                            continue;
                        }
                        if (AttributeType.STRING.equals((Object)correlationData.getType())) {
                            attributeArray[attributeCount++] = this.getPropertyValue(null, correlationData.getType());
                            continue;
                        }
                        throw new InvalidPropertyValueException("Attribute " + correlationData.getName() + " tag not found in the event hence Dropping event " + obj.toString());
                    }
                }
                if (this.noPayloadData > 0) {
                    jsonPath = JsonPath.compile((String)"$.event.payloadData", (Predicate[])new Predicate[0]);
                    eventMap = null;
                    eventMap = this.parseEventToMap(jsonPath, jsonString);
                    if (eventMap == null) {
                        throw new EventReceiverProcessingException("Missing PayloadData attributes, Event does not match with the stream : " + this.eventReceiverConfiguration.getToStreamName() + ":" + this.eventReceiverConfiguration.getToStreamVersion());
                    }
                    for (Attribute payloadData : this.streamDefinition.getPayloadData()) {
                        if (eventMap.containsKey(payloadData.getName())) {
                            attributeArray[attributeCount++] = this.getPropertyValue(eventMap.get(payloadData.getName()), payloadData.getType());
                            continue;
                        }
                        if (AttributeType.STRING.equals((Object)payloadData.getType())) {
                            attributeArray[attributeCount++] = this.getPropertyValue(null, payloadData.getType());
                            continue;
                        }
                        throw new InvalidPropertyValueException("Attribute " + payloadData.getName() + " tag not found in the event hence Dropping event " + obj.toString());
                    }
                }
                if (this.noMetaData + this.noCorrelationData + this.noPayloadData != attributeCount) {
                    throw new EventReceiverProcessingException("Event attributes are not matching with the stream : " + this.eventReceiverConfiguration.getToStreamName() + ":" + this.eventReceiverConfiguration.getToStreamVersion());
                }
            }
            return EventReceiverUtil.getEventFromArray(attributeArray, outStreamDefinition, metaDataArray, correlationDataArray, payloadDataArray);
        }
        catch (InvalidPropertyValueException e) {
            log.error((Object)(e.getMessage() + ", hence dropping the event : " + obj.toString()));
            return null;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Unable to cast the input data to required type, hence dropping the event: " + obj.toString()), (Throwable)e);
            return null;
        }
    }

    private Object getPropertyValue(Object propertyValue, AttributeType attributeType) throws InvalidPropertyValueException {
        if (!AttributeType.STRING.equals((Object)attributeType) && propertyValue == null) {
            throw new InvalidPropertyValueException("Found Invalid property value 'null' for attribute of type " + attributeType);
        }
        if (AttributeType.BOOL.equals((Object)attributeType)) {
            return Boolean.parseBoolean(propertyValue.toString());
        }
        if (AttributeType.DOUBLE.equals((Object)attributeType)) {
            return Double.parseDouble(propertyValue.toString());
        }
        if (AttributeType.FLOAT.equals((Object)attributeType)) {
            return Float.valueOf(Float.parseFloat(propertyValue.toString()));
        }
        if (AttributeType.INT.equals((Object)attributeType)) {
            return Integer.parseInt(propertyValue.toString());
        }
        if (AttributeType.LONG.equals((Object)attributeType)) {
            return Long.parseLong(propertyValue.toString());
        }
        return propertyValue == null ? null : propertyValue.toString();
    }

    private void createAttributeJsonPathList(StreamDefinition streamDefinition, List<InputMappingAttribute> inputMappingAttributeList) {
        InputMappingAttribute inputMappingAttribute;
        if (streamDefinition.getMetaData() != null && streamDefinition.getMetaData().size() > 0) {
            for (Attribute metaData : streamDefinition.getMetaData()) {
                inputMappingAttribute = this.getInputMappingAttribute("meta_" + metaData.getName(), inputMappingAttributeList);
                this.attributeJsonPathDataList.add(new JsonPathData(JsonPath.compile((String)inputMappingAttribute.getFromElementKey(), (Predicate[])new Predicate[0]), inputMappingAttribute.getToElementType(), inputMappingAttribute.getDefaultValue()));
            }
        }
        if (streamDefinition.getCorrelationData() != null && streamDefinition.getCorrelationData().size() > 0) {
            for (Attribute correlationData : streamDefinition.getCorrelationData()) {
                inputMappingAttribute = this.getInputMappingAttribute("correlation_" + correlationData.getName(), inputMappingAttributeList);
                this.attributeJsonPathDataList.add(new JsonPathData(JsonPath.compile((String)inputMappingAttribute.getFromElementKey(), (Predicate[])new Predicate[0]), inputMappingAttribute.getToElementType(), inputMappingAttribute.getDefaultValue()));
            }
        }
        if (streamDefinition.getPayloadData() != null && streamDefinition.getPayloadData().size() > 0) {
            for (Attribute payloadData : streamDefinition.getPayloadData()) {
                inputMappingAttribute = this.getInputMappingAttribute(payloadData.getName(), inputMappingAttributeList);
                this.attributeJsonPathDataList.add(new JsonPathData(JsonPath.compile((String)inputMappingAttribute.getFromElementKey(), (Predicate[])new Predicate[0]), inputMappingAttribute.getToElementType(), inputMappingAttribute.getDefaultValue()));
            }
        }
    }

    private InputMappingAttribute getInputMappingAttribute(String mappingAttribute, List<InputMappingAttribute> inputMappingAttributeList) {
        for (InputMappingAttribute inputMappingAttribute : inputMappingAttributeList) {
            if (!inputMappingAttribute.getToElementKey().equals(mappingAttribute)) continue;
            return inputMappingAttribute;
        }
        log.error((Object)"Json input mapping attribute not found");
        return null;
    }

    private Map<Object, Object> parseEventToMap(JsonPath jsonPath, String jsonString) {
        Map eventMap = null;
        Object eventObj = jsonPath.read(jsonString);
        if (eventObj != null) {
            if (eventObj instanceof JsonObject) {
                eventMap = (Map)new Gson().fromJson(eventObj.toString(), LinkedHashMap.class);
            } else if (eventObj instanceof Map) {
                eventMap = (Map)eventObj;
            }
        }
        return eventMap;
    }

    private class JsonPathData {
        private AttributeType type;
        private JsonPath jsonPath;
        private String defaultValue;

        public JsonPathData(JsonPath jsonPath, AttributeType type, String defaultValue) {
            this.type = type;
            this.jsonPath = jsonPath;
            this.defaultValue = defaultValue;
        }

        private String getDefaultValue() {
            return this.defaultValue;
        }

        private JsonPath getJsonPath() {
            return this.jsonPath;
        }

        private AttributeType getType() {
            return this.type;
        }
    }
}

