/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.management;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.processor.manager.core.EventManagementUtil;
import org.wso2.carbon.event.processor.manager.core.EventSync;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.management.AbstractInputEventDispatcher;
import org.wso2.carbon.event.receiver.core.internal.management.BlockingEventQueue;

public class QueueInputEventDispatcher
extends AbstractInputEventDispatcher
implements EventSync {
    private final StreamDefinition streamDefinition;
    private Log log = LogFactory.getLog(AbstractInputEventDispatcher.class);
    private final BlockingEventQueue eventQueue;
    private Lock readLock;
    private String syncId;
    private int tenantId;
    private ReentrantLock threadBarrier = new ReentrantLock();
    private ExecutorService executorService;
    private boolean isContinue = false;
    private String originalEventStreamId;

    public QueueInputEventDispatcher(int tenantId, String syncId, Lock readLock, StreamDefinition exportedStreamDefinition, int eventQueueSizeMb, int eventSyncQueueSize) {
        this.readLock = readLock;
        this.tenantId = tenantId;
        this.syncId = syncId;
        this.eventQueue = new BlockingEventQueue(eventQueueSizeMb, eventSyncQueueSize);
        this.originalEventStreamId = exportedStreamDefinition.getStreamId();
        this.streamDefinition = EventManagementUtil.constructDatabridgeStreamDefinition((String)syncId, (StreamDefinition)exportedStreamDefinition);
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Thread pool- component - QueueInputEventDispatcher.executorService;tenant - " + this.tenantId + ";stream - " + exportedStreamDefinition.getStreamId() + ";receiver - " + this.streamDefinition.getName()).build());
        this.executorService.submit(new QueueInputEventDispatcherWorker());
    }

    @Override
    public void onEvent(Event event) {
        try {
            this.eventQueue.put(event, this.threadBarrier);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Interrupted while waiting to put the event to queue.", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public byte[] getState() {
        this.threadBarrier.lock();
        byte[] state = this.objectToBytes(this.eventQueue);
        this.threadBarrier.unlock();
        return state;
    }

    @Override
    public void syncState(byte[] bytes) {
        BlockingEventQueue events = (BlockingEventQueue)this.bytesToObject(bytes);
        while (events.peek() != null && events.poll().equals((Object)this.eventQueue.peek())) {
            this.eventQueue.poll();
        }
    }

    public void process(Event event) {
        if (this.isContinueProcess()) {
            this.readLock.lock();
            this.readLock.unlock();
            this.callBack.sendEvent(event);
        }
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public boolean isContinueProcess() {
        return this.isContinue;
    }

    public void setContinueProcess(boolean isContinue) {
        this.isContinue = isContinue;
    }

    public String getOriginalEventStreamId() {
        return this.originalEventStreamId;
    }

    private byte[] objectToBytes(Object obj) {
        long start = System.currentTimeMillis();
        byte[] out = null;
        if (obj != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                out = baos.toByteArray();
            }
            catch (IOException e) {
                this.log.error((Object)("Error when writing byte array. " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        long end = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encoded in :" + (end - start) + " msec"));
        }
        return out;
    }

    private Object bytesToObject(byte[] bytes) {
        long start = System.currentTimeMillis();
        Object out = null;
        if (bytes != null) {
            try {
                ByteArrayInputStream bios = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bios);
                out = ois.readObject();
            }
            catch (IOException e) {
                this.log.error((Object)("Error when writing to object. " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("Error when writing to object. " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        long end = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Decoded in :" + (end - start) + " msec"));
        }
        return out;
    }

    static /* synthetic */ int access$000(QueueInputEventDispatcher x0) {
        return x0.tenantId;
    }

    static /* synthetic */ Lock access$100(QueueInputEventDispatcher x0) {
        return x0.readLock;
    }

    static /* synthetic */ BlockingEventQueue access$200(QueueInputEventDispatcher x0) {
        return x0.eventQueue;
    }

    static /* synthetic */ String access$300(QueueInputEventDispatcher x0) {
        return x0.syncId;
    }

    static /* synthetic */ Log access$400(QueueInputEventDispatcher x0) {
        return x0.log;
    }

    static /* synthetic */ StreamDefinition access$500(QueueInputEventDispatcher x0) {
        return x0.streamDefinition;
    }

    class QueueInputEventDispatcherWorker
    implements Runnable {
        QueueInputEventDispatcherWorker() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                try {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(QueueInputEventDispatcher.access$000(QueueInputEventDispatcher.this));
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        try {
                            while (true) {
                                QueueInputEventDispatcher.access$100(QueueInputEventDispatcher.this).lock();
                                QueueInputEventDispatcher.access$100(QueueInputEventDispatcher.this).unlock();
                                event = QueueInputEventDispatcher.access$200(QueueInputEventDispatcher.this).take();
                                QueueInputEventDispatcher.access$100(QueueInputEventDispatcher.this).lock();
                                QueueInputEventDispatcher.access$100(QueueInputEventDispatcher.this).unlock();
                                if (QueueInputEventDispatcher.this.isContinueProcess()) {
                                    QueueInputEventDispatcher.this.callBack.sendEvent(event);
                                }
                                if (!QueueInputEventDispatcher.this.isSendToOther()) continue;
                                EventReceiverServiceValueHolder.getEventManagementService().syncEvent(QueueInputEventDispatcher.access$300(QueueInputEventDispatcher.this), Manager.ManagerType.Receiver, event);
                            }
                        }
                        catch (InterruptedException e) {
                            QueueInputEventDispatcher.access$400(QueueInputEventDispatcher.this).error((Object)"Interrupted while waiting to get an event from queue.", (Throwable)e);
                        }
                        catch (Throwable t) {
                            QueueInputEventDispatcher.access$400(QueueInputEventDispatcher.this).error((Object)("Error has occured while waiting to get an event from the queue which is belonging to tenentId:" + QueueInputEventDispatcher.access$000(QueueInputEventDispatcher.this) + " and Stream Definition: " + QueueInputEventDispatcher.access$500(QueueInputEventDispatcher.this)), t);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    QueueInputEventDispatcher.access$400(QueueInputEventDispatcher.this).error((Object)("Error in dispatching events:" + e.getMessage()), (Throwable)e);
                    PrivilegedCarbonContext.endTenantFlow();
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var2_5) {
                PrivilegedCarbonContext.endTenantFlow();
                throw var2_5;
            }
        }
    }
}

