/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal.management;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;

public class BlockingEventQueue
implements Serializable {
    private static final Log log = LogFactory.getLog(BlockingEventQueue.class);
    private final ReentrantLock takeLock = new ReentrantLock();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();
    private final Condition notEmpty = this.takeLock.newCondition();
    private int maxSizeInBytes;
    private BlockingQueue<WrappedEvent> queue;
    private AtomicInteger currentSize;
    private int currentEventSize;

    public BlockingEventQueue(int maxSizeInMb, int maxNumOfEvents) {
        this.maxSizeInBytes = maxSizeInMb * 1000000;
        this.queue = new LinkedBlockingQueue<WrappedEvent>(maxNumOfEvents);
        this.currentSize = new AtomicInteger(0);
        this.currentEventSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Event event, ReentrantLock threadBarrier) throws InterruptedException {
        ReentrantLock putLock = this.putLock;
        AtomicInteger currentSize = this.currentSize;
        int c = -1;
        putLock.lockInterruptibly();
        try {
            this.currentEventSize = EventReceiverUtil.getSize(event) + 4;
            while (currentSize.get() >= this.maxSizeInBytes) {
                this.notFull.await(1L, TimeUnit.SECONDS);
            }
            threadBarrier.lock();
            while (!this.queue.offer(new WrappedEvent(this.currentEventSize, event))) {
                threadBarrier.unlock();
                Thread.sleep(1000L);
                threadBarrier.lock();
            }
            threadBarrier.unlock();
            c = currentSize.getAndAdd(this.currentEventSize);
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current queue size in bytes : " + currentSize + ", remaining capacity : " + this.queue.remainingCapacity()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event take() throws InterruptedException {
        WrappedEvent wrappedEvent;
        int c = -1;
        ReentrantLock takeLock = this.takeLock;
        AtomicInteger currentSize = this.currentSize;
        takeLock.lockInterruptibly();
        try {
            while (currentSize.get() == 0) {
                this.notEmpty.await(1L, TimeUnit.SECONDS);
            }
            wrappedEvent = this.queue.take();
            c = currentSize.getAndAdd(-wrappedEvent.getSize());
        }
        finally {
            takeLock.unlock();
        }
        if (c >= this.maxSizeInBytes) {
            this.signalNotFull();
        }
        return wrappedEvent.getEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event poll() {
        AtomicInteger currentSize = this.currentSize;
        if (currentSize.get() == 0) {
            return null;
        }
        WrappedEvent wrappedEvent = null;
        int c = -1;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (currentSize.get() > 0 && (wrappedEvent = (WrappedEvent)this.queue.poll()) != null) {
                c = currentSize.getAndAdd(-wrappedEvent.getSize());
                if (currentSize.get() > 0) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            takeLock.unlock();
        }
        if (wrappedEvent != null && c >= this.maxSizeInBytes) {
            this.signalNotFull();
        }
        return wrappedEvent == null ? null : wrappedEvent.getEvent();
    }

    public Event peek() {
        WrappedEvent wrappedEvent = (WrappedEvent)this.queue.peek();
        if (wrappedEvent != null) {
            return wrappedEvent.getEvent();
        }
        return null;
    }

    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            putLock.unlock();
        }
    }

    private class WrappedEvent
    implements Serializable {
        private int size;
        private Event event;

        public WrappedEvent(int size, Event event) {
            this.size = size;
            this.event = event;
        }

        public int getSize() {
            return this.size;
        }

        public Event getEvent() {
            return this.event;
        }
    }
}

