/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.internal.CarbonEventReceiverService;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.stream.core.EventStreamListener;

public class EventStreamListenerImpl
implements EventStreamListener {
    private static final Log log = LogFactory.getLog(EventStreamListenerImpl.class);

    public void removedEventStream(int tenantId, String streamName, String streamVersion) {
        CarbonEventReceiverService carbonEventReceiverService = EventReceiverServiceValueHolder.getCarbonEventReceiverService();
        String streamNameWithVersion = DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)streamVersion);
        try {
            carbonEventReceiverService.deactivateActiveEventReceiverConfigurationsForStream(streamNameWithVersion, tenantId);
        }
        catch (EventReceiverConfigurationException e) {
            log.error((Object)"Exception occurred while un-deploying the Event receiver configuration files");
        }
    }

    public void addedEventStream(int tenantId, String streamName, String streamVersion) {
        CarbonEventReceiverService carbonEventReceiverService = EventReceiverServiceValueHolder.getCarbonEventReceiverService();
        String streamNameWithVersion = DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)streamVersion);
        try {
            carbonEventReceiverService.activateInactiveEventReceiverConfigurationsForStream(streamNameWithVersion, tenantId);
        }
        catch (EventReceiverConfigurationException e) {
            log.error((Object)"Exception occurred while re-deploying the Event receiver configuration files");
        }
    }
}

