/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal;

import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterSubscription;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.processor.manager.core.EventManagementUtil;
import org.wso2.carbon.event.processor.manager.core.EventSync;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.HAConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.Mode;
import org.wso2.carbon.event.receiver.core.InputMapper;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverProcessingException;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.management.AbstractInputEventDispatcher;
import org.wso2.carbon.event.receiver.core.internal.management.InputEventDispatcher;
import org.wso2.carbon.event.receiver.core.internal.management.QueueInputEventDispatcher;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.EventProducerCallback;

public class EventReceiver
implements EventProducer {
    private static final Log log = LogFactory.getLog(EventReceiver.class);
    private boolean isEventDuplicatedInCluster;
    private boolean traceEnabled = false;
    private boolean statisticsEnabled = false;
    private boolean customMappingEnabled = false;
    private boolean isWorkerNode = false;
    private boolean sufficientToSend = false;
    private Log trace = LogFactory.getLog((String)"EVENT_TRACE_LOGGER");
    private EventReceiverConfiguration eventReceiverConfiguration = null;
    private StreamDefinition exportedStreamDefinition;
    private InputMapper inputMapper = null;
    private String beforeTracerPrefix;
    private String afterTracerPrefix;
    private AbstractInputEventDispatcher inputEventDispatcher;
    private Mode mode;

    public EventReceiver(EventReceiverConfiguration eventReceiverConfiguration, StreamDefinition exportedStreamDefinition, Mode mode) throws EventReceiverConfigurationException {
        this.eventReceiverConfiguration = eventReceiverConfiguration;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.eventReceiverConfiguration != null) {
            this.traceEnabled = eventReceiverConfiguration.isTraceEnabled();
            this.statisticsEnabled = eventReceiverConfiguration.isStatisticsEnabled() && EventReceiverServiceValueHolder.isGlobalStatisticsEnabled();
            this.customMappingEnabled = eventReceiverConfiguration.getInputMapping().isCustomMappingEnabled();
            String mappingType = this.eventReceiverConfiguration.getInputMapping().getMappingType();
            this.inputMapper = EventReceiverServiceValueHolder.getMappingFactoryMap().get(mappingType).constructInputMapper(this.eventReceiverConfiguration, exportedStreamDefinition);
            String metricId = "WSO2_CEP.EventReceivers[+]." + eventReceiverConfiguration.getEventReceiverName() + "." + "ReceivedEvents";
            if (this.inputMapper != null) {
                if (this.customMappingEnabled) {
                    EventReceiverConfigurationHelper.validateExportedStream(eventReceiverConfiguration, exportedStreamDefinition, this.inputMapper);
                }
            } else {
                throw new EventReceiverConfigurationException("Could not create input mapper for mapping type " + mappingType + " for event receiver :" + eventReceiverConfiguration.getEventReceiverName());
            }
            this.exportedStreamDefinition = exportedStreamDefinition;
            if (this.statisticsEnabled) {
                // empty if block
            }
            if (this.traceEnabled) {
                this.beforeTracerPrefix = "TenantId : " + tenantId + ", " + "Event Receiver" + " : " + eventReceiverConfiguration.getEventReceiverName() + ", before processing " + System.getProperty("line.separator");
                this.afterTracerPrefix = "TenantId : " + tenantId + ", " + "Event Receiver" + " : " + eventReceiverConfiguration.getEventReceiverName() + ", " + "Event Stream" + " : " + EventReceiverUtil.getExportedStreamIdFrom(eventReceiverConfiguration) + ", after processing " + System.getProperty("line.separator");
            }
            String inputEventAdapterName = eventReceiverConfiguration.getFromAdapterConfiguration().getName();
            try {
                Object inputEventAdapterSubscription = this.customMappingEnabled ? new MappedEventSubscription() : new TypedEventSubscription();
                EventReceiverServiceValueHolder.getInputEventAdapterService().create(eventReceiverConfiguration.getFromAdapterConfiguration(), (InputEventAdapterSubscription)inputEventAdapterSubscription);
                this.isEventDuplicatedInCluster = EventReceiverServiceValueHolder.getInputEventAdapterService().isEventDuplicatedInCluster(eventReceiverConfiguration.getFromAdapterConfiguration().getName());
                DistributedConfiguration distributedConfiguration = EventReceiverServiceValueHolder.getEventManagementService().getManagementModeInfo().getDistributedConfiguration();
                if (distributedConfiguration != null) {
                    this.isWorkerNode = distributedConfiguration.isWorkerNode();
                }
                this.sufficientToSend = mode != Mode.Distributed || this.isWorkerNode && !this.isEventDuplicatedInCluster;
            }
            catch (InputEventAdapterException e) {
                throw new EventReceiverConfigurationException("Cannot subscribe to input event adapter :" + inputEventAdapterName + ", error in configuration. " + e.getMessage(), e);
            }
            catch (InputEventAdapterRuntimeException e) {
                throw new EventReceiverProcessingException("Cannot subscribe to input event adapter :" + inputEventAdapterName + ", error while connecting by adapter. " + e.getMessage(), e);
            }
            this.mode = mode;
            if (mode == Mode.HA) {
                HAConfiguration haConfiguration = EventReceiverServiceValueHolder.getEventManagementService().getManagementModeInfo().getHaConfiguration();
                Lock readLock = EventReceiverServiceValueHolder.getCarbonEventReceiverManagementService().getReadLock();
                this.inputEventDispatcher = new QueueInputEventDispatcher(tenantId, EventManagementUtil.constructEventSyncId((int)tenantId, (String)eventReceiverConfiguration.getEventReceiverName(), (Manager.ManagerType)Manager.ManagerType.Receiver), readLock, exportedStreamDefinition, haConfiguration.getEventSyncReceiverMaxQueueSizeInMb(), haConfiguration.getEventSyncReceiverQueueSize());
                this.inputEventDispatcher.setSendToOther(!this.isEventDuplicatedInCluster);
                EventReceiverServiceValueHolder.getEventManagementService().registerEventSync((EventSync)this.inputEventDispatcher, Manager.ManagerType.Receiver);
            } else {
                this.inputEventDispatcher = new InputEventDispatcher();
            }
            if (mode == Mode.HA && this.isEventDuplicatedInCluster) {
                EventReceiverServiceValueHolder.getInputEventAdapterService().start(inputEventAdapterName);
            }
        }
    }

    public StreamDefinition getExportedStreamDefinition() {
        return this.exportedStreamDefinition;
    }

    public EventReceiverConfiguration getEventReceiverConfiguration() {
        return this.eventReceiverConfiguration;
    }

    protected void processMappedEvent(Object object) {
        if (this.traceEnabled) {
            this.trace.info((Object)(this.beforeTracerPrefix + object.toString()));
        }
        if (object instanceof List) {
            for (Object obj : (List)object) {
                try {
                    this.processMappedEvent(obj);
                }
                catch (EventReceiverProcessingException e) {
                    log.error((Object)"Dropping event. Error processing event : ", (Throwable)e);
                }
            }
        } else {
            try {
                Object convertedEvent = this.inputMapper.convertToMappedInputEvent(object);
                if (convertedEvent != null) {
                    if (convertedEvent instanceof Event[]) {
                        Event[] arrayOfEvents;
                        for (Event event : arrayOfEvents = (Event[])convertedEvent) {
                            if (event == null) continue;
                            this.sendEvent(event);
                        }
                    }
                    this.sendEvent((Event)convertedEvent);
                }
                log.warn((Object)"Dropping the empty/null event, Event does not match with mapping");
            }
            catch (EventReceiverProcessingException e) {
                log.error((Object)"Dropping event. Error processing event : ", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)("Dropping event. Unexpected error while processing event : " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processTypedEvent(Object obj) {
        if (this.traceEnabled) {
            this.trace.info((Object)(this.beforeTracerPrefix + obj.toString()));
        }
        if (obj instanceof List) {
            for (Object object : (List)obj) {
                try {
                    this.processTypedEvent(object);
                }
                catch (EventReceiverProcessingException e) {
                    log.error((Object)("Dropping event. Error processing event: " + e.getMessage()), (Throwable)e);
                }
            }
            return;
        } else {
            try {
                Object convertedEvent = this.inputMapper.convertToTypedInputEvent(obj);
                if (convertedEvent == null) return;
                if (convertedEvent instanceof Event[]) {
                    Event[] arrayOfEvents;
                    for (Event event : arrayOfEvents = (Event[])convertedEvent) {
                        if (event == null) continue;
                        this.sendEvent(event);
                    }
                    return;
                }
                this.sendEvent((Event)convertedEvent);
                return;
            }
            catch (EventReceiverProcessingException e) {
                log.error((Object)("Dropping event. Error processing event: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void sendEvent(Event event) {
        if (this.traceEnabled) {
            this.trace.info((Object)(this.afterTracerPrefix + event));
        }
        if (this.statisticsEnabled) {
            // empty if block
        }
        if (this.sufficientToSend || EventReceiverServiceValueHolder.getCarbonEventReceiverManagementService().isReceiverCoordinator()) {
            this.inputEventDispatcher.onEvent(event);
        }
    }

    public AbstractInputEventDispatcher getInputEventDispatcher() {
        return this.inputEventDispatcher;
    }

    public String getStreamId() {
        return this.exportedStreamDefinition.getStreamId();
    }

    public void setCallBack(EventProducerCallback callBack) {
        this.inputEventDispatcher.setCallBack(callBack);
    }

    public void destroy() {
        EventReceiverServiceValueHolder.getInputEventAdapterService().destroy(this.eventReceiverConfiguration.getFromAdapterConfiguration().getName());
        if (this.mode == Mode.HA && this.inputEventDispatcher instanceof EventSync) {
            EventReceiverServiceValueHolder.getEventManagementService().unregisterEventSync(((EventSync)this.inputEventDispatcher).getStreamDefinition().getStreamId(), Manager.ManagerType.Receiver);
        }
    }

    public boolean isEventDuplicatedInCluster() {
        return this.isEventDuplicatedInCluster;
    }

    private class TypedEventSubscription
    implements InputEventAdapterSubscription {
        private TypedEventSubscription() {
        }

        public void onEvent(Object o) {
            EventReceiver.this.processTypedEvent(o);
        }
    }

    private class MappedEventSubscription
    implements InputEventAdapterSubscription {
        private MappedEventSubscription() {
        }

        public void onEvent(Object o) {
            EventReceiver.this.processMappedEvent(o);
        }
    }
}

