/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.input.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterSchema;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterService;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.receiver.core.EventReceiverDeployer;
import org.wso2.carbon.event.receiver.core.EventReceiverService;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfigurationFile;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverStreamValidationException;
import org.wso2.carbon.event.receiver.core.internal.EventReceiver;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverConfigurationBuilder;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverUtil;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationFileSystemInvoker;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.xml.sax.InputSource;

public class CarbonEventReceiverService
implements EventReceiverService {
    private static final Log log = LogFactory.getLog(CarbonEventReceiverService.class);
    private Map<Integer, Map<String, EventReceiver>> tenantSpecificEventReceiverConfigurationMap = new ConcurrentHashMap<Integer, Map<String, EventReceiver>>();
    private Map<Integer, List<EventReceiverConfigurationFile>> tenantSpecificEventReceiverConfigurationFileMap = new ConcurrentHashMap<Integer, List<EventReceiverConfigurationFile>>();
    private Map<Integer, EventReceiverDeployer> tenantSpecificDeployerMap = new ConcurrentHashMap<Integer, EventReceiverDeployer>();

    @Override
    public void deployEventReceiverConfiguration(EventReceiverConfiguration eventReceiverConfiguration) throws EventReceiverConfigurationException {
        String eventReceiverName = eventReceiverConfiguration.getEventReceiverName();
        OMElement omElement = EventReceiverConfigurationBuilder.eventReceiverConfigurationToOM(eventReceiverConfiguration);
        EventReceiverConfigurationHelper.validateEventReceiverConfiguration(omElement);
        String mappingType = EventReceiverConfigurationHelper.getInputMappingType(omElement);
        if (mappingType == null) {
            throw new EventReceiverConfigurationException("Mapping type of the Event Receiver " + eventReceiverConfiguration.getEventReceiverName() + " cannot be null");
        }
        String repoPath = EventAdapterUtil.getAxisConfiguration().getRepository().getPath();
        EventReceiverUtil.generateFilePath(eventReceiverName, repoPath);
        this.validateToRemoveInactiveEventReceiverConfiguration(eventReceiverConfiguration.getEventReceiverName());
        EventReceiverConfigurationFileSystemInvoker.encryptAndSave(omElement, eventReceiverName + ".xml");
    }

    @Override
    public void deployEventReceiverConfiguration(String eventReceiverConfigXml) throws EventReceiverConfigurationException {
        OMElement omElement;
        try {
            omElement = AXIOMUtil.stringToOM((String)eventReceiverConfigXml);
        }
        catch (XMLStreamException e) {
            throw new EventReceiverConfigurationException("Error parsing XML configuration of event receiver.", e);
        }
        EventReceiverConfigurationHelper.validateEventReceiverConfiguration(omElement);
        String eventReceiverName = EventReceiverConfigurationHelper.getEventReceiverName(omElement);
        String mappingType = EventReceiverConfigurationHelper.getInputMappingType(omElement);
        if (mappingType == null) {
            throw new EventReceiverConfigurationException("Mapping type of the Event Receiver " + eventReceiverName + " cannot be null");
        }
        String repoPath = EventAdapterUtil.getAxisConfiguration().getRepository().getPath();
        EventReceiverUtil.generateFilePath(eventReceiverName, repoPath);
        this.validateToRemoveInactiveEventReceiverConfiguration(eventReceiverName);
        EventReceiverConfigurationFileSystemInvoker.encryptAndSave(omElement, eventReceiverName + ".xml");
    }

    @Override
    public String getEventReceiverName(String eventReceiverConfigXml) throws EventReceiverConfigurationException {
        OMElement omElement;
        try {
            omElement = AXIOMUtil.stringToOM((String)eventReceiverConfigXml);
        }
        catch (XMLStreamException e) {
            throw new EventReceiverConfigurationException("Error parsing XML configuration of event receiver.", e);
        }
        EventReceiverConfigurationHelper.validateEventReceiverConfiguration(omElement);
        return EventReceiverConfigurationHelper.getEventReceiverName(omElement);
    }

    @Override
    public void undeployActiveEventReceiverConfiguration(String eventReceiverName) throws EventReceiverConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = this.getFileName(eventReceiverName);
        if (fileName == null) {
            throw new EventReceiverConfigurationException("Couldn't undeploy the Event Receiver configuration: " + eventReceiverName);
        }
        EventReceiverConfigurationFileSystemInvoker.delete(fileName);
    }

    @Override
    public void undeployInactiveEventReceiverConfiguration(String filename) throws EventReceiverConfigurationException {
        EventReceiverConfigurationFileSystemInvoker.delete(filename);
    }

    @Override
    public void editInactiveEventReceiverConfiguration(String eventReceiverConfiguration, String filename) throws EventReceiverConfigurationException {
        this.editEventReceiverConfiguration(filename, eventReceiverConfiguration, null);
    }

    @Override
    public void editActiveEventReceiverConfiguration(String eventReceiverConfiguration, String eventReceiverName) throws EventReceiverConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = this.getFileName(eventReceiverName);
        if (fileName == null) {
            fileName = eventReceiverName + ".xml";
        }
        this.editEventReceiverConfiguration(fileName, eventReceiverConfiguration, eventReceiverName);
    }

    @Override
    public EventReceiverConfiguration getActiveEventReceiverConfiguration(String eventReceiverName) {
        EventReceiver eventReceiver;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventReceiverConfiguration eventReceiverConfiguration = null;
        Map<String, EventReceiver> tenantSpecificEventReceiverMap = this.tenantSpecificEventReceiverConfigurationMap.get(tenantId);
        if (tenantSpecificEventReceiverMap != null && tenantSpecificEventReceiverMap.size() > 0 && (eventReceiver = tenantSpecificEventReceiverMap.get(eventReceiverName)) != null) {
            eventReceiverConfiguration = eventReceiver.getEventReceiverConfiguration();
        }
        return eventReceiverConfiguration;
    }

    @Override
    public List<EventReceiverConfiguration> getAllActiveEventReceiverConfigurations() {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ArrayList<EventReceiverConfiguration> eventReceiverConfigurations = new ArrayList<EventReceiverConfiguration>();
        Map<String, EventReceiver> tenantSpecificEventReceiverMap = this.tenantSpecificEventReceiverConfigurationMap.get(tenantId);
        if (tenantSpecificEventReceiverMap != null) {
            for (EventReceiver eventReceiver : tenantSpecificEventReceiverMap.values()) {
                eventReceiverConfigurations.add(eventReceiver.getEventReceiverConfiguration());
            }
        }
        return eventReceiverConfigurations;
    }

    @Override
    public List<EventReceiverConfiguration> getAllActiveEventReceiverConfigurations(String streamId) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ArrayList<EventReceiverConfiguration> eventReceiverConfigurations = new ArrayList<EventReceiverConfiguration>();
        Map<String, EventReceiver> tenantSpecificEventReceiverMap = this.tenantSpecificEventReceiverConfigurationMap.get(tenantId);
        if (tenantSpecificEventReceiverMap != null) {
            for (EventReceiver eventReceiver : tenantSpecificEventReceiverMap.values()) {
                String streamWithVersion = eventReceiver.getExportedStreamDefinition().getStreamId();
                if (!streamWithVersion.equals(streamId)) continue;
                eventReceiverConfigurations.add(eventReceiver.getEventReceiverConfiguration());
            }
        }
        return eventReceiverConfigurations;
    }

    @Override
    public List<EventReceiverConfigurationFile> getAllInactiveEventReceiverConfigurations() {
        ArrayList<EventReceiverConfigurationFile> undeployedEventReceiverConfigurationFileList = new ArrayList<EventReceiverConfigurationFile>();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId);
        if (eventReceiverConfigurationFiles != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFiles) {
                if (eventReceiverConfigurationFile.getStatus() == EventReceiverConfigurationFile.Status.DEPLOYED) continue;
                undeployedEventReceiverConfigurationFileList.add(eventReceiverConfigurationFile);
            }
        }
        return undeployedEventReceiverConfigurationFileList;
    }

    @Override
    public String getInactiveEventReceiverConfigurationContent(String fileName) throws EventReceiverConfigurationException {
        return EventReceiverConfigurationFileSystemInvoker.readEventReceiverConfigurationFile(fileName);
    }

    @Override
    public String getActiveEventReceiverConfigurationContent(String eventReceiverName) throws EventReceiverConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = this.getFileName(eventReceiverName);
        return EventReceiverConfigurationFileSystemInvoker.readEventReceiverConfigurationFile(fileName);
    }

    public List<String> getAllEventStreams(AxisConfiguration axisConfiguration) throws EventReceiverConfigurationException {
        ArrayList<String> streamList = new ArrayList<String>();
        EventStreamService eventStreamService = EventReceiverServiceValueHolder.getEventStreamService();
        try {
            List eventStreamDefinitionList = eventStreamService.getAllStreamDefinitions();
            if (eventStreamDefinitionList != null) {
                for (StreamDefinition streamDefinition : eventStreamDefinitionList) {
                    streamList.add(streamDefinition.getStreamId());
                }
            }
        }
        catch (EventStreamConfigurationException e) {
            throw new EventReceiverConfigurationException("Error while retrieving stream definition from store", e);
        }
        return streamList;
    }

    @Override
    public void setStatisticsEnabled(String eventReceiverName, boolean statisticsEnabled) throws EventReceiverConfigurationException {
        EventReceiverConfiguration eventReceiverConfiguration = this.getActiveEventReceiverConfiguration(eventReceiverName);
        eventReceiverConfiguration.setStatisticsEnabled(statisticsEnabled);
        this.editTracingStatistics(eventReceiverConfiguration, eventReceiverName);
    }

    @Override
    public void setTraceEnabled(String eventReceiverName, boolean traceEnabled) throws EventReceiverConfigurationException {
        EventReceiverConfiguration eventReceiverConfiguration = this.getActiveEventReceiverConfiguration(eventReceiverName);
        eventReceiverConfiguration.setTraceEnabled(traceEnabled);
        this.editTracingStatistics(eventReceiverConfiguration, eventReceiverName);
    }

    @Override
    public String getEventReceiverStatusAsString(String filename) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFileList = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId);
        if (eventReceiverConfigurationFileList != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFileList) {
                if (filename == null || !filename.equals(eventReceiverConfigurationFile.getFileName())) continue;
                String statusMsg = eventReceiverConfigurationFile.getDeploymentStatusMessage();
                if (eventReceiverConfigurationFile.getDependency() != null) {
                    statusMsg = statusMsg + " [Dependency: " + eventReceiverConfigurationFile.getDependency() + "]";
                }
                return statusMsg;
            }
        }
        return "No dependency information available for this event receiver";
    }

    public void addEventReceiverConfigurationFile(EventReceiverConfigurationFile eventReceiverConfigurationFile, int tenantId) {
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId);
        if (eventReceiverConfigurationFiles == null) {
            eventReceiverConfigurationFiles = new CopyOnWriteArrayList<EventReceiverConfigurationFile>();
        } else {
            for (EventReceiverConfigurationFile anEventReceiverConfigurationFileList : eventReceiverConfigurationFiles) {
                if (!anEventReceiverConfigurationFileList.getFileName().equals(eventReceiverConfigurationFile.getFileName())) continue;
                return;
            }
        }
        eventReceiverConfigurationFiles.add(eventReceiverConfigurationFile);
        this.tenantSpecificEventReceiverConfigurationFileMap.put(tenantId, eventReceiverConfigurationFiles);
    }

    public void addEventReceiverConfiguration(EventReceiverConfiguration eventReceiverConfiguration) throws EventReceiverConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        StreamDefinition exportedStreamDefinition = null;
        try {
            exportedStreamDefinition = EventReceiverServiceValueHolder.getEventStreamService().getStreamDefinition(eventReceiverConfiguration.getToStreamName(), eventReceiverConfiguration.getToStreamVersion());
        }
        catch (EventStreamConfigurationException e) {
            throw new EventReceiverConfigurationException("Error while retrieving stream definition for stream " + eventReceiverConfiguration.getToStreamName() + ":" + eventReceiverConfiguration.getToStreamVersion() + " from store", e);
        }
        if (exportedStreamDefinition == null) {
            throw new EventReceiverStreamValidationException("Stream " + eventReceiverConfiguration.getToStreamName() + ":" + eventReceiverConfiguration.getToStreamVersion() + " does not exist", eventReceiverConfiguration.getToStreamName() + ":" + eventReceiverConfiguration.getToStreamVersion());
        }
        Map<String, EventReceiver> eventReceiverConfigurationMap = this.tenantSpecificEventReceiverConfigurationMap.get(tenantId);
        if (eventReceiverConfigurationMap == null) {
            eventReceiverConfigurationMap = new ConcurrentHashMap<String, EventReceiver>();
        }
        EventReceiver eventReceiver = new EventReceiver(eventReceiverConfiguration, exportedStreamDefinition, EventReceiverServiceValueHolder.getEventManagementService().getManagementModeInfo().getMode());
        try {
            EventReceiverServiceValueHolder.getEventStreamService().subscribe((EventProducer)eventReceiver);
        }
        catch (EventStreamConfigurationException eventStreamConfigurationException) {
            // empty catch block
        }
        eventReceiverConfigurationMap.put(eventReceiverConfiguration.getEventReceiverName(), eventReceiver);
        this.tenantSpecificEventReceiverConfigurationMap.put(tenantId, eventReceiverConfigurationMap);
    }

    public void removeEventReceiverConfigurationFile(String fileName) throws EventReceiverConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFileList = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId);
        if (eventReceiverConfigurationFileList != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFileList) {
                if (!eventReceiverConfigurationFile.getFileName().equals(fileName)) continue;
                if (eventReceiverConfigurationFile.getStatus().equals((Object)EventReceiverConfigurationFile.Status.DEPLOYED)) {
                    String eventReceiverName = eventReceiverConfigurationFile.getEventReceiverName();
                    EventReceiver eventReceiver = this.tenantSpecificEventReceiverConfigurationMap.get(tenantId).remove(eventReceiverName);
                    if (eventReceiver != null) {
                        EventReceiverServiceValueHolder.getEventStreamService().unsubscribe((EventProducer)eventReceiver);
                        eventReceiver.destroy();
                    }
                }
                eventReceiverConfigurationFileList.remove(eventReceiverConfigurationFile);
                return;
            }
        }
    }

    public void activateInactiveEventReceiverConfigurationsForAdapter(String eventAdapterName) throws EventReceiverConfigurationException {
        ArrayList<EventReceiverConfigurationFile> fileList = new ArrayList<EventReceiverConfigurationFile>();
        if (this.tenantSpecificEventReceiverConfigurationFileMap != null && this.tenantSpecificEventReceiverConfigurationFileMap.size() > 0) {
            for (List list : this.tenantSpecificEventReceiverConfigurationFileMap.values()) {
                if (list == null) continue;
                for (EventReceiverConfigurationFile eventReceiverConfigurationFile : list) {
                    if (!eventReceiverConfigurationFile.getStatus().equals((Object)EventReceiverConfigurationFile.Status.WAITING_FOR_DEPENDENCY) || !eventReceiverConfigurationFile.getDependency().equalsIgnoreCase(eventAdapterName)) continue;
                    fileList.add(eventReceiverConfigurationFile);
                }
            }
        }
        for (EventReceiverConfigurationFile eventReceiverConfigurationFile : fileList) {
            try {
                EventReceiverConfigurationFileSystemInvoker.reload(eventReceiverConfigurationFile, this.tenantSpecificDeployerMap);
            }
            catch (Exception e) {
                log.error((Object)("Exception occurred while trying to deploy the Event Receiver configuration file: " + eventReceiverConfigurationFile.getFileName()), (Throwable)e);
            }
        }
    }

    public void activateInactiveEventReceiverConfigurationsForStream(String streamId, int tenantId) throws EventReceiverConfigurationException {
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles;
        ArrayList<EventReceiverConfigurationFile> fileList = new ArrayList<EventReceiverConfigurationFile>();
        if (this.tenantSpecificEventReceiverConfigurationFileMap != null && this.tenantSpecificEventReceiverConfigurationFileMap.size() > 0 && (eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId)) != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFiles) {
                if (!EventReceiverConfigurationFile.Status.WAITING_FOR_STREAM_DEPENDENCY.equals((Object)eventReceiverConfigurationFile.getStatus()) || !streamId.equalsIgnoreCase(eventReceiverConfigurationFile.getDependency())) continue;
                fileList.add(eventReceiverConfigurationFile);
            }
        }
        for (EventReceiverConfigurationFile receiverConfigurationFile : fileList) {
            try {
                EventReceiverConfigurationFileSystemInvoker.reload(receiverConfigurationFile, this.tenantSpecificDeployerMap);
            }
            catch (Exception e) {
                log.error((Object)("Exception occurred while trying to deploy the Event Receiver configuration file: " + receiverConfigurationFile.getFileName()), (Throwable)e);
            }
        }
    }

    public void deactivateActiveEventReceiverConfigurationsForAdapter(String dependency) throws EventReceiverConfigurationException {
        InputEventAdapterService eventAdapterService = EventReceiverServiceValueHolder.getInputEventAdapterService();
        ArrayList<EventReceiverConfigurationFile> fileList = new ArrayList<EventReceiverConfigurationFile>();
        if (this.tenantSpecificEventReceiverConfigurationMap != null && this.tenantSpecificEventReceiverConfigurationMap.size() > 0) {
            for (Map.Entry entry : this.tenantSpecificEventReceiverConfigurationMap.entrySet()) {
                if (entry.getValue() == null) continue;
                int tenantId = (Integer)entry.getKey();
                for (EventReceiver eventReceiver : ((Map)entry.getValue()).values()) {
                    EventReceiverConfigurationFile receiverConfigurationFile;
                    String eventAdapterType = eventReceiver.getEventReceiverConfiguration().getFromAdapterConfiguration().getType();
                    if (!eventAdapterType.equals(dependency) || (receiverConfigurationFile = this.getEventReceiverConfigurationFile(eventReceiver.getEventReceiverConfiguration().getEventReceiverName(), tenantId)) == null || eventAdapterService == null) continue;
                    fileList.add(receiverConfigurationFile);
                    eventAdapterService.destroy(eventReceiver.getEventReceiverConfiguration().getFromAdapterConfiguration().getName());
                }
            }
        }
        for (EventReceiverConfigurationFile eventReceiverConfigurationFile : fileList) {
            EventReceiverConfigurationFileSystemInvoker.reload(eventReceiverConfigurationFile, this.tenantSpecificDeployerMap);
            log.info((Object)("Event receiver : " + eventReceiverConfigurationFile.getEventReceiverName() + " in inactive state because dependency could not be found: " + dependency));
        }
    }

    public void deactivateActiveEventReceiverConfigurationsForStream(String streamId, int tenantId) throws EventReceiverConfigurationException {
        Map<String, EventReceiver> eventReceiverMap;
        InputEventAdapterService eventAdapterService = EventReceiverServiceValueHolder.getInputEventAdapterService();
        ArrayList<EventReceiverConfigurationFile> fileList = new ArrayList<EventReceiverConfigurationFile>();
        if (this.tenantSpecificEventReceiverConfigurationMap != null && this.tenantSpecificEventReceiverConfigurationMap.size() > 0 && (eventReceiverMap = this.tenantSpecificEventReceiverConfigurationMap.get(tenantId)) != null) {
            for (EventReceiver eventReceiver : eventReceiverMap.values()) {
                EventReceiverConfigurationFile receiverConfigurationFile;
                EventReceiverConfiguration eventReceiverConfiguration = eventReceiver.getEventReceiverConfiguration();
                String stream = EventReceiverUtil.getExportedStreamIdFrom(eventReceiverConfiguration);
                if (!streamId.equals(stream) || (receiverConfigurationFile = this.getEventReceiverConfigurationFile(eventReceiverConfiguration.getEventReceiverName(), tenantId)) == null) continue;
                fileList.add(receiverConfigurationFile);
                eventAdapterService.destroy(eventReceiverConfiguration.getFromAdapterConfiguration().getName());
            }
        }
        for (EventReceiverConfigurationFile receiverConfigurationFile : fileList) {
            EventReceiverConfigurationFileSystemInvoker.reload(receiverConfigurationFile, this.tenantSpecificDeployerMap);
            log.info((Object)("Event receiver : " + receiverConfigurationFile.getEventReceiverName() + " in inactive state because event stream dependency  could not be found: " + streamId));
        }
    }

    public boolean isEventReceiverAlreadyExists(int tenantId, String eventReceiverName) {
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles;
        if (this.tenantSpecificEventReceiverConfigurationFileMap.size() > 0 && (eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId)) != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFiles) {
                if (!eventReceiverConfigurationFile.getEventReceiverName().equals(eventReceiverName) || !eventReceiverConfigurationFile.getStatus().equals((Object)EventReceiverConfigurationFile.Status.DEPLOYED)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEventReceiverFileAlreadyExist(String eventReceiverFileName, int tenantId) {
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles;
        if (this.tenantSpecificEventReceiverConfigurationFileMap.size() > 0 && (eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId)) != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFiles) {
                if (!eventReceiverConfigurationFile.getFileName().equals(eventReceiverFileName)) continue;
                return true;
            }
        }
        return false;
    }

    private void editTracingStatistics(EventReceiverConfiguration eventReceiverConfiguration, String eventReceiverName) throws EventReceiverConfigurationException {
        String fileName = this.getFileName(eventReceiverName);
        this.undeployActiveEventReceiverConfiguration(eventReceiverName);
        OMElement omElement = EventReceiverConfigurationBuilder.eventReceiverConfigurationToOM(eventReceiverConfiguration);
        EventReceiverConfigurationFileSystemInvoker.delete(fileName);
        EventReceiverConfigurationFileSystemInvoker.encryptAndSave(omElement, fileName);
    }

    private String getFileName(String eventReceiverName) {
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (this.tenantSpecificEventReceiverConfigurationFileMap.size() > 0 && (eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId)) != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFiles) {
                if (!eventReceiverConfigurationFile.getEventReceiverName().equals(eventReceiverName) || !eventReceiverConfigurationFile.getStatus().equals((Object)EventReceiverConfigurationFile.Status.DEPLOYED)) continue;
                return new File(eventReceiverConfigurationFile.getFileName()).getName();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void editEventReceiverConfiguration(String filename, String eventReceiverConfigurationXml, String originalEventReceiverName) throws EventReceiverConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            DocumentBuilderFactory dbf = EventReceiverUtil.getSecuredDocumentBuilder();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(eventReceiverConfigurationXml)));
            OMElement omElement = XMLUtils.toOM((Element)document.getDocumentElement());
            omElement.build();
            EventReceiverConfigurationHelper.validateEventReceiverConfiguration(omElement);
            String mappingType = EventReceiverConfigurationHelper.getInputMappingType(omElement);
            if (mappingType == null) throw new EventReceiverConfigurationException("Mapping type of the Event Receiver " + originalEventReceiverName + " cannot be null");
            EventReceiverConfiguration eventReceiverConfigurationObject = EventReceiverConfigurationBuilder.getEventReceiverConfiguration(omElement, mappingType, true, tenantId);
            if (!eventReceiverConfigurationObject.getEventReceiverName().equals(originalEventReceiverName)) {
                if (this.isEventReceiverAlreadyExists(tenantId, eventReceiverConfigurationObject.getEventReceiverName())) throw new EventReceiverConfigurationException("There is already a Event Receiver " + eventReceiverConfigurationObject.getEventReceiverName() + " with the same name");
                EventReceiverConfigurationFileSystemInvoker.delete(filename);
                EventReceiverConfigurationFileSystemInvoker.encryptAndSave(omElement, filename);
                return;
            } else {
                EventReceiverConfigurationFileSystemInvoker.delete(filename);
                EventReceiverConfigurationFileSystemInvoker.encryptAndSave(omElement, filename);
            }
            return;
        }
        catch (Exception e) {
            throw new EventReceiverConfigurationException("Error while building XML configuration: " + e.getMessage(), e);
        }
    }

    private EventReceiverConfigurationFile getEventReceiverConfigurationFile(String eventReceiverName, int tenantId) {
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId);
        if (eventReceiverConfigurationFiles != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFiles) {
                if (!eventReceiverConfigurationFile.getEventReceiverName().equals(eventReceiverName)) continue;
                return eventReceiverConfigurationFile;
            }
        }
        return null;
    }

    private void validateToRemoveInactiveEventReceiverConfiguration(String eventReceiverName) throws EventReceiverConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String fileName = eventReceiverName + ".xml";
        List<EventReceiverConfigurationFile> eventReceiverConfigurationFiles = this.tenantSpecificEventReceiverConfigurationFileMap.get(tenantId);
        if (eventReceiverConfigurationFiles != null) {
            for (EventReceiverConfigurationFile eventReceiverConfigurationFile : eventReceiverConfigurationFiles) {
                if (!eventReceiverConfigurationFile.getFileName().equals(fileName) || eventReceiverConfigurationFile.getStatus().equals((Object)EventReceiverConfigurationFile.Status.DEPLOYED)) continue;
                EventReceiverConfigurationFileSystemInvoker.delete(fileName);
                break;
            }
        }
    }

    public List<String> getEncryptedProperties(String eventAdaptorType) {
        List properties;
        ArrayList<String> encryptedProperties = new ArrayList<String>(1);
        InputEventAdapterSchema inputEventAdapterSchema = EventReceiverServiceValueHolder.getInputEventAdapterService().getInputEventAdapterSchema(eventAdaptorType);
        if (inputEventAdapterSchema != null && (properties = inputEventAdapterSchema.getPropertyList()) != null) {
            for (Property prop : properties) {
                if (!prop.isEncrypted()) continue;
                encryptedProperties.add(prop.getPropertyName());
            }
        }
        return encryptedProperties;
    }

    public Map<Integer, Map<String, EventReceiver>> getTenantSpecificEventReceiverMap() {
        return this.tenantSpecificEventReceiverConfigurationMap;
    }

    public void start() {
        EventReceiverServiceValueHolder.getInputEventAdapterService().start();
    }

    public void startPolling() {
        EventReceiverServiceValueHolder.getInputEventAdapterService().startPolling();
    }

    public Map<Integer, EventReceiverDeployer> getTenantSpecificDeployerMap() {
        return this.tenantSpecificDeployerMap;
    }
}

