/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.manager.core.EventReceiverManagementService;
import org.wso2.carbon.event.processor.manager.core.exception.EventManagementException;
import org.wso2.carbon.event.receiver.core.internal.EventReceiver;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.siddhi.core.util.snapshot.ByteSerializer;

public class CarbonEventReceiverManagementService
extends EventReceiverManagementService {
    private Log log = LogFactory.getLog(CarbonEventReceiverManagementService.class);
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private boolean isReceiverCoordinator = false;

    public byte[] getState() {
        Map<Integer, Map<String, EventReceiver>> tenantSpecificEventAdapters = EventReceiverServiceValueHolder.getCarbonEventReceiverService().getTenantSpecificEventReceiverMap();
        HashMap data = new HashMap();
        for (Map.Entry<Integer, Map<String, EventReceiver>> pair : tenantSpecificEventAdapters.entrySet()) {
            Map<String, EventReceiver> map = pair.getValue();
            int tenantId = pair.getKey();
            HashMap<String, byte[]> tenantData = new HashMap<String, byte[]>();
            for (Map.Entry<String, EventReceiver> receiverEntry : map.entrySet()) {
                if (!receiverEntry.getValue().isEventDuplicatedInCluster()) continue;
                byte[] state = receiverEntry.getValue().getInputEventDispatcher().getState();
                tenantData.put(receiverEntry.getKey(), state);
            }
            data.put(tenantId, tenantData);
        }
        return ByteSerializer.OToB(data);
    }

    public void syncState(byte[] bytes) {
        HashMap snapshotDataList = (HashMap)ByteSerializer.BToO((byte[])bytes);
        Map<Integer, Map<String, EventReceiver>> tenantSpecificEventAdapters = EventReceiverServiceValueHolder.getCarbonEventReceiverService().getTenantSpecificEventReceiverMap();
        for (Map.Entry tenantEntry : snapshotDataList.entrySet()) {
            for (Map.Entry eventReceiverData : ((HashMap)tenantEntry.getValue()).entrySet()) {
                Map<String, EventReceiver> eventReceiverMap = tenantSpecificEventAdapters.get(tenantEntry.getKey());
                if (eventReceiverMap != null) {
                    EventReceiver eventReceiver = eventReceiverMap.get(eventReceiverData.getKey());
                    if (eventReceiver != null) {
                        eventReceiver.getInputEventDispatcher().syncState((byte[])eventReceiverData.getValue());
                        continue;
                    }
                    throw new EventManagementException("No event receiver with name '" + (String)eventReceiverData.getKey() + "' exist for tenant  " + tenantEntry.getKey());
                }
                throw new EventManagementException("No event receiver exist for tenant  " + tenantEntry.getKey());
            }
        }
    }

    public void pause() {
        this.readWriteLock.writeLock().lock();
    }

    public void resume() {
        this.readWriteLock.writeLock().unlock();
    }

    public void start() {
        EventReceiverServiceValueHolder.getCarbonEventReceiverService().start();
    }

    public void startPolling() {
        EventReceiverServiceValueHolder.getCarbonEventReceiverService().startPolling();
    }

    public boolean isReceiverCoordinator() {
        return this.isReceiverCoordinator;
    }

    public Lock getReadLock() {
        return this.readWriteLock.readLock();
    }

    public void setReceiverCoordinator(boolean isReceiverCoordinator) {
        this.isReceiverCoordinator = isReceiverCoordinator;
    }
}

