/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.application.deployer.EventProcessingDeployer;
import org.wso2.carbon.event.input.adapter.core.TenantConfigHolder;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfigurationFile;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverConfigurationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverStreamValidationException;
import org.wso2.carbon.event.receiver.core.exception.EventReceiverValidationException;
import org.wso2.carbon.event.receiver.core.internal.CarbonEventReceiverService;
import org.wso2.carbon.event.receiver.core.internal.ds.EventReceiverServiceValueHolder;
import org.wso2.carbon.event.receiver.core.internal.util.EventReceiverConfigurationBuilder;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationFileSystemInvoker;
import org.wso2.carbon.event.receiver.core.internal.util.helper.EventReceiverConfigurationHelper;

public class EventReceiverDeployer
extends AbstractDeployer
implements EventProcessingDeployer {
    private static Log log = LogFactory.getLog(EventReceiverDeployer.class);
    private ConfigurationContext configurationContext;
    private Set<String> deployedEventReceiverFilePaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> undeployedEventReceiverFilePaths = Collections.newSetFromMap(new ConcurrentHashMap());

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        TenantConfigHolder.addTenantConfig((int)PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(), (ConfigurationContext)configurationContext);
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String path = deploymentFileData.getAbsolutePath();
        if (!this.deployedEventReceiverFilePaths.contains(path)) {
            try {
                this.processDeployment(deploymentFileData);
            }
            catch (Throwable e) {
                log.error((Object)("Cannot deploy event receiver : " + deploymentFileData.getName()), e);
                throw new DeploymentException("Event receiver file " + deploymentFileData.getName() + " is not deployed ", e);
            }
        } else {
            this.deployedEventReceiverFilePaths.remove(path);
        }
    }

    private OMElement getEventReceiverConfigOMElement(File ebConfigFile) throws DeploymentException {
        OMElement ebConfigElement = null;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(ebConfigFile));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder receiver = new StAXOMBuilder(parser);
            ebConfigElement = receiver.getDocumentElement();
            ebConfigElement.build();
        }
        catch (FileNotFoundException e) {
            String errorMessage = ebConfigFile.getName() + " cannot be found";
            log.error((Object)errorMessage, (Throwable)e);
            throw new DeploymentException(errorMessage, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Invalid XML for " + ebConfigFile.getName();
            log.error((Object)errorMessage, (Throwable)e);
            throw new DeploymentException(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorMessage = "Error parsing configuration syntax: " + ebConfigFile.getName();
            log.error((Object)errorMessage, (Throwable)e);
            throw new DeploymentException(errorMessage, (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                String errorMessage = "Cannot close the input stream";
                log.error((Object)errorMessage, (Throwable)e);
            }
        }
        return ebConfigElement;
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String filePath) throws DeploymentException {
        if (!this.undeployedEventReceiverFilePaths.contains(filePath)) {
            try {
                this.processUndeployment(filePath);
            }
            catch (Throwable e) {
                log.error((Object)("Cannot undeploy event receiver : " + new File(filePath).getName()), e);
                throw new DeploymentException("Event receiver file " + new File(filePath).getName() + " is not undeployed properly", e);
            }
        } else {
            this.undeployedEventReceiverFilePaths.remove(filePath);
        }
    }

    public void setDirectory(String directory) {
    }

    public void processDeployment(DeploymentFileData deploymentFileData) throws DeploymentException, EventReceiverConfigurationException {
        File eventReceiverFile = deploymentFileData.getFile();
        boolean isEditable = !eventReceiverFile.getAbsolutePath().contains(File.separator + "carbonapps" + File.separator);
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        CarbonEventReceiverService carbonEventReceiverService = EventReceiverServiceValueHolder.getCarbonEventReceiverService();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String eventReceiverName = "";
        carbonEventReceiverService.getTenantSpecificDeployerMap().put(tenantId, this);
        Object streamNameWithVersion = null;
        OMElement eventReceiverOMElement = null;
        if (!carbonEventReceiverService.isEventReceiverFileAlreadyExist(eventReceiverFile.getName(), tenantId)) {
            try {
                EventReceiverConfiguration eventReceiverConfiguration;
                eventReceiverOMElement = this.getEventReceiverConfigOMElement(eventReceiverFile);
                if (!eventReceiverOMElement.getLocalName().equals("eventReceiver")) {
                    throw new EventReceiverConfigurationException("Wrong event receiver configuration file, Invalid root element " + eventReceiverOMElement.getQName() + " in " + eventReceiverFile.getName());
                }
                boolean isEncrypted = EventReceiverConfigurationHelper.validateEncryptedProperties(eventReceiverOMElement);
                if (isEditable && !isEncrypted) {
                    String fileName = eventReceiverFile.getName();
                    EventReceiverConfigurationFileSystemInvoker.delete(fileName);
                    EventReceiverConfigurationFileSystemInvoker.encryptAndSave(eventReceiverOMElement, fileName);
                    return;
                }
                EventReceiverConfigurationHelper.validateEventReceiverConfiguration(eventReceiverOMElement);
                eventReceiverName = eventReceiverOMElement.getAttributeValue(new QName("name"));
                String mappingType = EventReceiverConfigurationHelper.getInputMappingType(eventReceiverOMElement);
                if (mappingType != null) {
                    mappingType = mappingType.toLowerCase();
                    eventReceiverConfiguration = EventReceiverConfigurationBuilder.getEventReceiverConfiguration(eventReceiverOMElement, mappingType, isEditable, tenantId);
                    eventReceiverName = eventReceiverConfiguration.getEventReceiverName();
                    String type = eventReceiverConfiguration.getFromAdapterConfiguration().getType();
                    if (!EventReceiverServiceValueHolder.getInputEventAdapterTypes().contains(type)) {
                        throw new EventReceiverValidationException("Event Adapter with type: " + type + " does not exist", type);
                    }
                    if (carbonEventReceiverService.isEventReceiverAlreadyExists(tenantId, eventReceiverName)) {
                        throw new EventReceiverConfigurationException("Event Receiver not deployed and in inactive state, since there is a event receiver registered with the same name in this tenant:" + eventReceiverFile.getName());
                    }
                } else {
                    throw new EventReceiverConfigurationException("Event Receiver not deployed and in inactive state, since it does not contain a proper mapping type : " + eventReceiverFile.getName());
                }
                carbonEventReceiverService.addEventReceiverConfiguration(eventReceiverConfiguration);
                carbonEventReceiverService.addEventReceiverConfigurationFile(this.createEventReceiverConfigurationFile(eventReceiverName, deploymentFileData.getFile(), EventReceiverConfigurationFile.Status.DEPLOYED, tenantId, null, null), tenantId);
                log.info((Object)("Event Receiver configuration successfully deployed and in active state: " + eventReceiverName));
            }
            catch (EventReceiverConfigurationException e) {
                if (isEditable) {
                    log.error((Object)("Error, Event Receiver not deployed and in inactive state, " + e.getMessage()), (Throwable)e);
                    carbonEventReceiverService.addEventReceiverConfigurationFile(this.createEventReceiverConfigurationFile(eventReceiverName, deploymentFileData.getFile(), EventReceiverConfigurationFile.Status.ERROR, tenantId, "Exception when deploying event receiver configuration file: " + e.getMessage(), null), tenantId);
                }
                throw new EventReceiverConfigurationException(e.getMessage(), e);
            }
            catch (EventReceiverValidationException e) {
                carbonEventReceiverService.addEventReceiverConfigurationFile(this.createEventReceiverConfigurationFile(eventReceiverName, deploymentFileData.getFile(), EventReceiverConfigurationFile.Status.WAITING_FOR_DEPENDENCY, tenantId, e.getMessage(), e.getDependency()), tenantId);
                log.info((Object)("Event receiver deployment held back and in inactive state: " + eventReceiverFile.getName() + ", waiting for Input Event Adapter dependency: " + e.getDependency()));
            }
            catch (EventReceiverStreamValidationException e) {
                carbonEventReceiverService.addEventReceiverConfigurationFile(this.createEventReceiverConfigurationFile(eventReceiverName, deploymentFileData.getFile(), EventReceiverConfigurationFile.Status.WAITING_FOR_STREAM_DEPENDENCY, tenantId, e.getMessage(), e.getDependency()), tenantId);
                log.info((Object)("Event receiver deployment held back and in inactive state: " + eventReceiverFile.getName() + ", Stream validation exception: " + e.getMessage()));
            }
            catch (Throwable e) {
                if (isEditable) {
                    log.error((Object)("Event Receiver not deployed, invalid configuration found at " + eventReceiverFile.getName() + ", and in inactive state, " + e.getMessage()), e);
                    carbonEventReceiverService.addEventReceiverConfigurationFile(this.createEventReceiverConfigurationFile(eventReceiverName, deploymentFileData.getFile(), EventReceiverConfigurationFile.Status.ERROR, tenantId, "Deployment exception: " + e.getMessage(), null), tenantId);
                }
                throw new EventReceiverConfigurationException(e);
            }
        } else {
            throw new EventReceiverConfigurationException("Event Receiver " + eventReceiverFile.getName() + " is already registered with this tenant (" + tenantId + ")");
        }
    }

    private EventReceiverConfigurationFile createEventReceiverConfigurationFile(String eventReceiverName, File file, EventReceiverConfigurationFile.Status status, int tenantId, String deploymentStatusMessage, String dependency) {
        EventReceiverConfigurationFile eventReceiverConfigurationFile = new EventReceiverConfigurationFile();
        eventReceiverConfigurationFile.setFileName(file.getName());
        eventReceiverConfigurationFile.setFilePath(file.getAbsolutePath());
        eventReceiverConfigurationFile.setEventReceiverName(eventReceiverName);
        eventReceiverConfigurationFile.setStatus(status);
        eventReceiverConfigurationFile.setDependency(dependency);
        eventReceiverConfigurationFile.setDeploymentStatusMessage(deploymentStatusMessage);
        eventReceiverConfigurationFile.setTenantId(tenantId);
        return eventReceiverConfigurationFile;
    }

    public void processUndeployment(String filePath) throws EventReceiverConfigurationException {
        String fileName = new File(filePath).getName();
        log.info((Object)("Event Receiver undeployed successfully: " + fileName));
        CarbonEventReceiverService carbonEventReceiverService = EventReceiverServiceValueHolder.getCarbonEventReceiverService();
        carbonEventReceiverService.removeEventReceiverConfigurationFile(fileName);
    }

    public void executeManualDeployment(DeploymentFileData deploymentFileData) throws EventReceiverConfigurationException {
        try {
            this.processDeployment(deploymentFileData);
        }
        catch (DeploymentException e) {
            throw new EventReceiverConfigurationException("Error while attempting manual deployment: " + e.getMessage(), e);
        }
    }

    public void executeManualUndeployment(String filePath) throws EventReceiverConfigurationException {
        this.processUndeployment(filePath);
    }

    public Set<String> getDeployedEventReceiverFilePaths() {
        return this.deployedEventReceiverFilePaths;
    }

    public Set<String> getUndeployedEventReceiverFilePaths() {
        return this.undeployedEventReceiverFilePaths;
    }
}

