/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.utils.CarbonUtils;

public class OpenIDClaimMapper {
    public static final String LN_CLAIM_MAPPER = "ClaimMapper";
    public static final String LN_CLAIM = "Claim";
    public static final String LN_SREG = "SReg";
    public static final String LN_AXSCHEMA = "AxSchema";
    public static final String LN_OPENID_SCHEMA = "OpenIDSchema";
    private static final String OPENID_CLAIM_MAPPER_FILE_PATH = "/openid-claim-mapper.xml";
    private static HashMap<String, String> axMapping = new HashMap();
    private static HashMap<String, String> sregMapping = new HashMap();
    private static OpenIDClaimMapper instance;

    private OpenIDClaimMapper() throws Exception {
        this.process(CarbonUtils.getCarbonConfigDirPath() + OPENID_CLAIM_MAPPER_FILE_PATH);
    }

    public static OpenIDClaimMapper getInstance() throws Exception {
        if (instance == null) {
            instance = new OpenIDClaimMapper();
        }
        return instance;
    }

    public HashMap<String, String> getAxMapping() {
        return axMapping;
    }

    public HashMap<String, String> getSregMapping() {
        return sregMapping;
    }

    private void process(String filePath) throws Exception {
        StAXOMBuilder builder = new StAXOMBuilder(filePath);
        OMElement elem = builder.getDocumentElement();
        this.process(elem);
    }

    private void process(OMElement initialClaims) throws Exception {
        Iterator claims = initialClaims.getChildrenWithName(new QName(LN_CLAIM));
        OMElement claimElement = null;
        OMElement sreg = null;
        OMElement axSchema = null;
        OMElement openidSchema = null;
        while (claims.hasNext()) {
            claimElement = (OMElement)claims.next();
            sreg = claimElement.getFirstChildWithName(new QName(LN_SREG));
            axSchema = claimElement.getFirstChildWithName(new QName(LN_AXSCHEMA));
            openidSchema = claimElement.getFirstChildWithName(new QName(LN_OPENID_SCHEMA));
            if (openidSchema != null && axSchema != null) {
                if (axMapping.containsKey(openidSchema.getText())) {
                    throw new Exception("Found duplicate key entries in openID claim mapper");
                }
                axMapping.put(openidSchema.getText(), axSchema.getText());
            }
            if (sreg != null && openidSchema != null) {
                if (sregMapping.containsKey(openidSchema.getText())) {
                    throw new Exception("Found duplicate key entries in openID claim mapper");
                }
                sregMapping.put(openidSchema.getText(), sreg.getText());
            }
            if (sreg == null || axSchema == null) continue;
            if (sregMapping.containsKey(axSchema.getText())) {
                throw new Exception("Found duplicate key entries in openID claim mapper");
            }
            sregMapping.put(axSchema.getText(), sreg.getText());
        }
    }
}

