/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.Utils;
import org.wso2.carbon.identity.base.IdentityConstants;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.internal.IdentityCoreServiceComponent;
import org.wso2.carbon.identity.core.model.IdentityCacheConfig;
import org.wso2.carbon.identity.core.model.IdentityCacheConfigKey;
import org.wso2.carbon.identity.core.model.IdentityCookieConfig;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfigKey;
import org.wso2.carbon.identity.core.model.LegacyFeatureConfig;
import org.wso2.carbon.identity.core.model.ReverseProxyConfig;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityCoreConstants;
import org.wso2.carbon.identity.core.util.IdentityLogTokenParser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class IdentityUtil {
    public static final ThreadLocal<Map<String, Object>> threadLocalProperties = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private static final char[] ppidDisplayCharMap = new char[]{'Q', 'L', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final String DEFAULT_FILE_NAME_REGEX = "^(?!(?:CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\.[^.]*)?$)[^<>:\"/\\\\|?*\\x00-\\x1F]*[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]$";
    private static final String ENABLE_RECOVERY_ENDPOINT = "EnableRecoveryEndpoint";
    private static final String ENABLE_SELF_SIGN_UP_ENDPOINT = "EnableSelfSignUpEndpoint";
    private static final String ENABLE_EMAIL_USERNAME = "EnableEmailUserName";
    private static Log log = LogFactory.getLog(IdentityUtil.class);
    private static Map<String, Object> configuration = new HashMap<String, Object>();
    private static Map<IdentityEventListenerConfigKey, IdentityEventListenerConfig> eventListenerConfiguration = new HashMap<IdentityEventListenerConfigKey, IdentityEventListenerConfig>();
    private static Map<IdentityCacheConfigKey, IdentityCacheConfig> identityCacheConfigurationHolder = new HashMap<IdentityCacheConfigKey, IdentityCacheConfig>();
    private static Map<String, IdentityCookieConfig> identityCookiesConfigurationHolder = new HashMap<String, IdentityCookieConfig>();
    private static Map<String, LegacyFeatureConfig> legacyFeatureConfigurationHolder = new HashMap<String, LegacyFeatureConfig>();
    private static Map<String, ReverseProxyConfig> reverseProxyConfigurationHolder = new HashMap<String, ReverseProxyConfig>();
    private static Document importerDoc = null;
    private static ThreadLocal<IdentityErrorMsgContext> IdentityError = new ThreadLocal();
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    public static final String PEM_BEGIN_CERTFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String PEM_END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String APPLICATION_DOMAIN = "Application";
    private static final String WORKFLOW_DOMAIN = "Workflow";
    public static final String PROP_TRUST_STORE_UPDATE_REQUIRED = "org.wso2.carbon.identity.core.util.TRUST_STORE_UPDATE_REQUIRED";

    public static IdentityErrorMsgContext getIdentityErrorMsg() {
        if (IdentityError.get() == null) {
            return null;
        }
        return IdentityError.get();
    }

    public static void setIdentityErrorMsg(IdentityErrorMsgContext error) {
        IdentityError.set(error);
    }

    public static void clearIdentityErrorMsg() {
        IdentityError.remove();
    }

    public static String getProperty(String key) {
        Object value = configuration.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            value = ((List)value).get(0);
        }
        String strValue = value instanceof String ? (String)value : String.valueOf(value);
        strValue = IdentityUtil.fillURLPlaceholders(strValue);
        return strValue;
    }

    public static IdentityEventListenerConfig readEventListenerProperty(String type, String name) {
        IdentityEventListenerConfigKey identityEventListenerConfigKey = new IdentityEventListenerConfigKey(type, name);
        IdentityEventListenerConfig identityEventListenerConfig = eventListenerConfiguration.get(identityEventListenerConfigKey);
        return identityEventListenerConfig;
    }

    public static IdentityCacheConfig getIdentityCacheConfig(String cacheManagerName, String cacheName) {
        IdentityCacheConfigKey configKey = new IdentityCacheConfigKey(cacheManagerName, cacheName);
        IdentityCacheConfig identityCacheConfig = identityCacheConfigurationHolder.get(configKey);
        if (identityCacheConfig == null && cacheName.startsWith("$__local__$.")) {
            configKey = new IdentityCacheConfigKey(cacheManagerName, cacheName.replace("$__local__$.", ""));
            identityCacheConfig = identityCacheConfigurationHolder.get(configKey);
        }
        return identityCacheConfig;
    }

    public static IdentityCookieConfig getIdentityCookieConfig(String cookieName) {
        return identityCookiesConfigurationHolder.get(cookieName);
    }

    public static Map<String, IdentityCookieConfig> getIdentityCookiesConfigurationHolder() {
        return identityCookiesConfigurationHolder;
    }

    public static boolean isLegacyFeatureEnabled(String legacyFeatureId, String legacyFeatureVersion) {
        if (StringUtils.isBlank((String)legacyFeatureId)) {
            return false;
        }
        String legacyFeatureConfig = StringUtils.isBlank((String)legacyFeatureVersion) ? legacyFeatureId.trim() : legacyFeatureId.trim() + legacyFeatureVersion.trim();
        if (StringUtils.isNotBlank((String)legacyFeatureConfig)) {
            LegacyFeatureConfig legacyFeatureConfiguration = legacyFeatureConfigurationHolder.get(legacyFeatureConfig);
            if (legacyFeatureConfiguration != null && legacyFeatureConfiguration.isEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Legacy feature id: " + legacyFeatureConfiguration.getId() + " legacy feature version : " + legacyFeatureConfiguration.getVersion() + " is enabled: " + legacyFeatureConfiguration.isEnabled()));
                }
                return legacyFeatureConfiguration.isEnabled();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Legacy feature is not configured or the configured legacy feature is empty. Hence returning false.");
            }
        }
        return false;
    }

    public static String getProxyContext(String defaultContext) {
        if (StringUtils.isNotBlank((String)defaultContext)) {
            ReverseProxyConfig reverseProxyConfig = reverseProxyConfigurationHolder.get(defaultContext);
            if (reverseProxyConfig != null && StringUtils.isNotBlank((String)reverseProxyConfig.getProxyContext())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Returning the proxy context: " + reverseProxyConfig.getProxyContext() + " for the default context " + defaultContext));
                }
                return reverseProxyConfig.getProxyContext();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Proxy context is not configured or the configured proxy context is empty. Hence returning the default context: " + defaultContext));
            }
        }
        return defaultContext;
    }

    public static void populateProperties() {
        configuration = IdentityConfigParser.getInstance().getConfiguration();
        IdentityConfigParser.getInstance();
        eventListenerConfiguration = IdentityConfigParser.getEventListenerConfiguration();
        IdentityConfigParser.getInstance();
        identityCacheConfigurationHolder = IdentityConfigParser.getIdentityCacheConfigurationHolder();
        identityCookiesConfigurationHolder = IdentityConfigParser.getIdentityCookieConfigurationHolder();
        legacyFeatureConfigurationHolder = IdentityConfigParser.getLegacyFeatureConfigurationHolder();
        IdentityConfigParser.getInstance();
        reverseProxyConfigurationHolder = IdentityConfigParser.getReverseProxyConfigurationHolder();
    }

    public static String getPPIDDisplayValue(String value) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating display value of PPID : " + value));
        }
        byte[] rawPpid = Base64.getDecoder().decode(value);
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        sha1.update(rawPpid);
        byte[] hashId = sha1.digest();
        char[] returnChars = new char[10];
        for (int i = 0; i < 10; ++i) {
            int rawValue = (hashId[i] + 128) % 32;
            returnChars[i] = ppidDisplayCharMap[rawValue];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(returnChars, 0, 3);
        sb.append("-");
        sb.append(returnChars, 3, 4);
        sb.append("-");
        sb.append(returnChars, 6, 3);
        return sb.toString();
    }

    public static String nodeToString(Node node) {
        return DOM2Writer.nodeToString((Node)node);
    }

    public static String getHMAC(String secretKey, String baseString) throws SignatureException {
        try {
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(key);
            byte[] rawHmac = mac.doFinal(baseString.getBytes());
            return Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage(), e);
        }
    }

    public static String generateUUID() throws Exception {
        try {
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            String randomNum = Integer.toString(prng.nextInt());
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            byte[] digest = sha.digest(randomNum.getBytes());
            return new String(Hex.encodeHex((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Failed to generate UUID ", e);
        }
    }

    public static String getRandomNumber() throws IdentityException {
        try {
            String secretKey = UUIDGenerator.generateUUID();
            String baseString = UUIDGenerator.generateUUID();
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(key);
            byte[] rawHmac = mac.doFinal(baseString.getBytes());
            String random = Base64.getEncoder().encodeToString(rawHmac);
            random = random.replace("/", "_");
            random = random.replace("=", "a");
            random = random.replace("+", "f");
            return random;
        }
        catch (Exception e) {
            log.error((Object)"Error when generating a random number.", (Throwable)e);
            throw IdentityException.error((String)"Error when generating a random number.", (Throwable)e);
        }
    }

    public static int getRandomInteger() throws IdentityException {
        try {
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            int number = prng.nextInt();
            while (number < 0) {
                number = prng.nextInt();
            }
            return number;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Error when generating a random number.", (Throwable)e);
            throw IdentityException.error((String)"Error when generating a random number.", (Throwable)e);
        }
    }

    public static String getIdentityConfigDirPath() {
        return CarbonUtils.getCarbonConfigDirPath() + File.separator + "identity";
    }

    public static String getEndpointURIPath(String endpoint, boolean addProxyContextPath, boolean addWebContextRoot) throws IdentityRuntimeException {
        StringBuilder serverUrl = new StringBuilder();
        IdentityUtil.appendContextToUri(endpoint, addProxyContextPath, addWebContextRoot, serverUrl);
        return serverUrl.toString();
    }

    public static String getServerURL(String endpoint, boolean addProxyContextPath, boolean addWebContextRoot) throws IdentityRuntimeException {
        String hostName = ServerConfiguration.getInstance().getFirstProperty("HostName");
        try {
            if (hostName == null) {
                hostName = NetworkUtils.getLocalHostname();
            }
        }
        catch (SocketException e) {
            throw IdentityRuntimeException.error((String)"Error while trying to read hostname.", (Throwable)e);
        }
        String mgtTransport = CarbonUtils.getManagementTransport();
        AxisConfiguration axisConfiguration = IdentityCoreServiceComponent.getConfigurationContextService().getServerConfigContext().getAxisConfiguration();
        int mgtTransportPort = CarbonUtils.getTransportProxyPort((AxisConfiguration)axisConfiguration, (String)mgtTransport);
        if (mgtTransportPort <= 0) {
            mgtTransportPort = CarbonUtils.getTransportPort((AxisConfiguration)axisConfiguration, (String)mgtTransport);
        }
        if (hostName.endsWith("/")) {
            hostName = hostName.substring(0, hostName.length() - 1);
        }
        StringBuilder serverUrl = new StringBuilder(mgtTransport).append("://").append(hostName.toLowerCase());
        if (mgtTransportPort != 443) {
            serverUrl.append(":").append(mgtTransportPort);
        }
        IdentityUtil.appendContextToUri(endpoint, addProxyContextPath, addWebContextRoot, serverUrl);
        return serverUrl.toString();
    }

    private static void appendContextToUri(String endpoint, boolean addProxyContextPath, boolean addWebContextRoot, StringBuilder serverUrl) {
        String webContextRoot;
        String proxyContextPath;
        if (addProxyContextPath && StringUtils.isNotBlank((String)(proxyContextPath = ServerConfiguration.getInstance().getFirstProperty("ProxyContextPath")))) {
            if (proxyContextPath.trim().charAt(0) != '/') {
                serverUrl.append("/").append(proxyContextPath.trim());
            } else {
                serverUrl.append(proxyContextPath.trim());
            }
        }
        if (addWebContextRoot && StringUtils.isNotBlank((String)(webContextRoot = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot")))) {
            if (webContextRoot.trim().charAt(0) != '/') {
                serverUrl.append("/").append(webContextRoot.trim());
            } else {
                serverUrl.append(webContextRoot.trim());
            }
        }
        if (StringUtils.isNotBlank((String)endpoint)) {
            if (!serverUrl.toString().endsWith("/") && endpoint.trim().charAt(0) != '/') {
                serverUrl.append("/").append(endpoint.trim());
            } else if (serverUrl.toString().endsWith("/") && endpoint.trim().charAt(0) == '/') {
                serverUrl.append(endpoint.trim().substring(1));
            } else {
                serverUrl.append(endpoint.trim());
            }
        }
        if (serverUrl.toString().endsWith("/")) {
            serverUrl.setLength(serverUrl.length() - 1);
        }
    }

    public static String getServicePath() {
        return IdentityCoreServiceComponent.getConfigurationContextService().getServerConfigContext().getServicePath();
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd or secure-processing.");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static TransformerFactory getSecuredTransformerFactory() {
        TransformerFactory trfactory = TransformerFactory.newInstance();
        try {
            trfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature http://javax.xml.XMLConstants/feature/secure-processing for secure-processing.");
        }
        trfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        trfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return trfactory;
    }

    public static boolean isUserStoreInUsernameCaseSensitive(String username) {
        boolean isUsernameCaseSensitive = true;
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            int tenantId = IdentityTenantUtil.getRealmService().getTenantManager().getTenantId(tenantDomain);
            return IdentityUtil.isUserStoreInUsernameCaseSensitive(username, tenantId);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while reading user store property CaseInsensitiveUsername. Considering as case sensitive.");
            }
            return isUsernameCaseSensitive;
        }
    }

    public static boolean isUserStoreInUsernameCaseSensitive(String username, int tenantId) {
        return IdentityUtil.isUserStoreCaseSensitive(IdentityUtil.extractDomainFromName(username), tenantId);
    }

    public static boolean isUserStoreCaseSensitive(String userStoreDomain, int tenantId) {
        boolean isUsernameCaseSensitive;
        block4: {
            isUsernameCaseSensitive = true;
            if (tenantId == -1) {
                return true;
            }
            try {
                UserRealm tenantUserRealm = IdentityTenantUtil.getRealmService().getTenantUserRealm(tenantId);
                if (tenantUserRealm != null) {
                    UserStoreManager userStoreManager = (UserStoreManager)tenantUserRealm.getUserStoreManager();
                    UserStoreManager userAvailableUserStoreManager = userStoreManager.getSecondaryUserStoreManager(userStoreDomain);
                    return IdentityUtil.isUserStoreCaseSensitive(userAvailableUserStoreManager);
                }
            }
            catch (UserStoreException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Error while reading user store property CaseInsensitiveUsername. Considering as case sensitive.");
            }
        }
        return isUsernameCaseSensitive;
    }

    public static boolean isUserStoreCaseSensitive(UserStoreManager userStoreManager) {
        if (userStoreManager == null) {
            return true;
        }
        String caseInsensitiveUsername = userStoreManager.getRealmConfiguration().getUserStoreProperty("CaseInsensitiveUsername");
        if (caseInsensitiveUsername == null && log.isDebugEnabled()) {
            log.debug((Object)"Error while reading user store property CaseInsensitiveUsername. Considering as case sensitive.");
        }
        return !Boolean.parseBoolean(caseInsensitiveUsername);
    }

    public static boolean isUseCaseSensitiveUsernameForCacheKeys(UserStoreManager userStoreManager) {
        if (userStoreManager == null) {
            return true;
        }
        String useCaseSensitiveUsernameForCacheKeys = userStoreManager.getRealmConfiguration().getUserStoreProperty("UseCaseSensitiveUsernameForCacheKeys");
        if (StringUtils.isBlank((String)useCaseSensitiveUsernameForCacheKeys)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to read user store property UseCaseSensitiveUsernameForCacheKeys. Considering as case sensitive.");
            }
            return true;
        }
        return Boolean.parseBoolean(useCaseSensitiveUsernameForCacheKeys);
    }

    public static boolean isNotBlank(String input) {
        return StringUtils.isNotBlank((String)input) && !"null".equals(input.trim());
    }

    public static boolean isBlank(String input) {
        return StringUtils.isBlank((String)input) || "null".equals(input.trim());
    }

    public static long getCleanUpTimeout() {
        String cleanUpTimeout = IdentityUtil.getProperty("JDBCPersistenceManager.SessionDataPersist.SessionDataCleanUp.CleanUpTimeout");
        if (StringUtils.isBlank((String)cleanUpTimeout)) {
            cleanUpTimeout = "20160";
        } else if (!StringUtils.isNumeric((String)cleanUpTimeout)) {
            cleanUpTimeout = "20160";
        }
        return Long.parseLong(cleanUpTimeout);
    }

    public static long getCleanUpPeriod(String tenantDomain) {
        String cleanUpPeriod = IdentityUtil.getProperty("JDBCPersistenceManager.SessionDataPersist.SessionDataCleanUp.CleanUpPeriod");
        if (StringUtils.isBlank((String)cleanUpPeriod)) {
            cleanUpPeriod = "1140";
        } else if (!StringUtils.isNumeric((String)cleanUpPeriod)) {
            cleanUpPeriod = "1140";
        }
        return Long.parseLong(cleanUpPeriod);
    }

    public static long getOperationCleanUpTimeout() {
        String cleanUpTimeout = IdentityUtil.getProperty("JDBCPersistenceManager.SessionDataPersist.OperationDataCleanUp.CleanUpTimeout");
        if (StringUtils.isBlank((String)cleanUpTimeout)) {
            cleanUpTimeout = "1";
        } else if (!StringUtils.isNumeric((String)cleanUpTimeout)) {
            cleanUpTimeout = "1";
        }
        return Long.parseLong(cleanUpTimeout);
    }

    public static long getTempDataCleanUpTimeout() {
        String cleanUpTimeout = IdentityUtil.getProperty("JDBCPersistenceManager.SessionDataPersist.TempDataCleanup.CleanUpTimeout");
        if (StringUtils.isBlank((String)cleanUpTimeout)) {
            cleanUpTimeout = "1";
        } else if (!StringUtils.isNumeric((String)cleanUpTimeout)) {
            cleanUpTimeout = "1";
        }
        return Long.parseLong(cleanUpTimeout);
    }

    public static long getOperationCleanUpPeriod(String tenantDomain) {
        String cleanUpPeriod = IdentityUtil.getProperty("JDBCPersistenceManager.SessionDataPersist.OperationDataCleanUp.CleanUpPeriod");
        if (StringUtils.isBlank((String)cleanUpPeriod)) {
            cleanUpPeriod = "720";
        } else if (!StringUtils.isNumeric((String)cleanUpPeriod)) {
            cleanUpPeriod = "720";
        }
        return Long.parseLong(cleanUpPeriod);
    }

    public static String extractDomainFromName(String nameWithDomain) {
        if (nameWithDomain.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) > 0) {
            String domain = nameWithDomain.substring(0, nameWithDomain.indexOf(UserCoreConstants.DOMAIN_SEPARATOR));
            if ("Internal".equalsIgnoreCase(domain) || WORKFLOW_DOMAIN.equalsIgnoreCase(domain) || APPLICATION_DOMAIN.equalsIgnoreCase(domain)) {
                return domain.substring(0, 1).toUpperCase() + domain.substring(1).toLowerCase();
            }
            return domain.toUpperCase();
        }
        return IdentityUtil.getPrimaryDomainName();
    }

    public static String addDomainToName(String name, String domainName) {
        if (domainName != null && name != null && !name.contains(UserCoreConstants.DOMAIN_SEPARATOR) && !"PRIMARY".equalsIgnoreCase(domainName)) {
            name = "Internal".equalsIgnoreCase(domainName) || WORKFLOW_DOMAIN.equalsIgnoreCase(domainName) || APPLICATION_DOMAIN.equalsIgnoreCase(domainName) ? domainName.substring(0, 1).toUpperCase() + domainName.substring(1).toLowerCase() + UserCoreConstants.DOMAIN_SEPARATOR + name : domainName.toUpperCase() + UserCoreConstants.DOMAIN_SEPARATOR + name;
        }
        return name;
    }

    public static String getPrimaryDomainName() {
        RealmConfiguration realmConfiguration = IdentityTenantUtil.getRealmService().getBootstrapRealmConfiguration();
        if (realmConfiguration.getUserStoreProperty("DomainName") != null) {
            return realmConfiguration.getUserStoreProperty("DomainName").toUpperCase();
        }
        return "PRIMARY";
    }

    public static boolean isValidFileName(String fileName) {
        String fileNameRegEx = ServerConfiguration.getInstance().getFirstProperty("FileNameRegEx");
        if (IdentityUtil.isBlank(fileNameRegEx)) {
            fileNameRegEx = DEFAULT_FILE_NAME_REGEX;
        }
        Pattern pattern = Pattern.compile(fileNameRegEx, 70);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.matches();
    }

    public static String fillURLPlaceholders(String urlWithPlaceholders) {
        String mgtTransport;
        if (StringUtils.isBlank((String)urlWithPlaceholders)) {
            return urlWithPlaceholders;
        }
        if (StringUtils.contains((String)(urlWithPlaceholders = Utils.replaceSystemProperty((String)urlWithPlaceholders)), (String)"${carbon.host}")) {
            String hostName = ServerConfiguration.getInstance().getFirstProperty("HostName");
            if (hostName == null) {
                try {
                    hostName = NetworkUtils.getLocalHostname();
                }
                catch (SocketException e) {
                    throw IdentityRuntimeException.error((String)"Error while trying to read hostname.", (Throwable)e);
                }
            }
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${carbon.host}", (String)hostName);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${carbon.management.port}")) {
            mgtTransport = CarbonUtils.getManagementTransport();
            AxisConfiguration axisConfiguration = IdentityCoreServiceComponent.getConfigurationContextService().getServerConfigContext().getAxisConfiguration();
            int mgtTransportProxyPort = CarbonUtils.getTransportProxyPort((AxisConfiguration)axisConfiguration, (String)mgtTransport);
            String mgtTransportPort = Integer.toString(mgtTransportProxyPort);
            if (mgtTransportProxyPort <= 0) {
                mgtTransportPort = StringUtils.equals((String)mgtTransport, (String)"http") ? System.getProperty("mgt.transport.http.port") : System.getProperty("mgt.transport.https.port");
            }
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${carbon.management.port}", (String)mgtTransportPort);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${mgt.transport.http.port}")) {
            String httpPort = System.getProperty("mgt.transport.http.port");
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${mgt.transport.http.port}", (String)httpPort);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${mgt.transport.https.port}")) {
            String httpsPort = System.getProperty("mgt.transport.https.port");
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${mgt.transport.https.port}", (String)httpsPort);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${carbon.protocol}")) {
            mgtTransport = CarbonUtils.getManagementTransport();
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${carbon.protocol}", (String)mgtTransport);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${carbon.proxycontextpath}")) {
            String proxyContextPath = ServerConfiguration.getInstance().getFirstProperty("ProxyContextPath");
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${carbon.proxycontextpath}", (String)proxyContextPath);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${carbon.webcontextroot}")) {
            String webContextRoot = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot");
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${carbon.webcontextroot}", (String)webContextRoot);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${carbon.home}")) {
            String carbonHome = CarbonUtils.getCarbonHome();
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${carbon.home}", (String)carbonHome);
        }
        if (StringUtils.contains((String)urlWithPlaceholders, (String)"${carbon.context}")) {
            String carbonContext = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot");
            if (carbonContext.equals("/")) {
                carbonContext = "";
            }
            urlWithPlaceholders = StringUtils.replace((String)urlWithPlaceholders, (String)"${carbon.context}", (String)carbonContext);
        }
        return urlWithPlaceholders;
    }

    public static boolean isTokenLoggable(String tokenName) {
        IdentityLogTokenParser identityLogTokenParser = IdentityLogTokenParser.getInstance();
        Map<String, String> logTokenMap = identityLogTokenParser.getLogTokenMap();
        return Boolean.valueOf(logTokenMap.get(tokenName));
    }

    public static String getHostName() {
        String hostName = ServerConfiguration.getInstance().getFirstProperty("HostName");
        if (hostName == null) {
            try {
                hostName = NetworkUtils.getLocalHostname();
            }
            catch (SocketException e) {
                throw IdentityRuntimeException.error((String)"Error while trying to read hostname.", (Throwable)e);
            }
        }
        return hostName;
    }

    public static String buildQueryString(Map<String, String[]> parameterMap) throws UnsupportedEncodingException {
        return "?" + IdentityUtil.buildQueryComponent(parameterMap);
    }

    public static String buildFragmentString(Map<String, String[]> parameterMap) throws UnsupportedEncodingException {
        return "#" + IdentityUtil.buildQueryComponent(parameterMap);
    }

    public static String buildQueryUrl(String baseUrl, Map<String, String[]> parameterMap) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)baseUrl)) {
            throw IdentityRuntimeException.error((String)("Base URL is blank: " + baseUrl));
        }
        if (baseUrl.contains("#")) {
            throw IdentityRuntimeException.error((String)("Query URL cannot contain '#': " + baseUrl));
        }
        StringBuilder queryString = new StringBuilder(baseUrl);
        if (parameterMap != null && parameterMap.size() > 0) {
            if (queryString.indexOf("?") < 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            queryString.append(IdentityUtil.buildQueryComponent(parameterMap));
        }
        return queryString.toString();
    }

    public static String buildFragmentUrl(String baseUrl, Map<String, String[]> parameterMap) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)baseUrl)) {
            throw IdentityRuntimeException.error((String)("Base URL is blank: " + baseUrl));
        }
        if (baseUrl.contains("?")) {
            throw IdentityRuntimeException.error((String)("Fragment URL cannot contain '?': " + baseUrl));
        }
        StringBuilder queryString = new StringBuilder(baseUrl);
        if (queryString.indexOf("#") < 0) {
            queryString.append("#");
        }
        queryString.append(IdentityUtil.buildQueryComponent(parameterMap));
        return queryString.toString();
    }

    public static String buildQueryComponent(Map<String, String[]> parameterMap) throws UnsupportedEncodingException {
        if (MapUtils.isEmpty(parameterMap)) {
            return "";
        }
        StringBuilder queryString = new StringBuilder("");
        boolean isFirst = true;
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            if (StringUtils.isBlank((String)entry.getKey()) || entry.getValue() == null) continue;
            for (String paramValue : entry.getValue()) {
                if (paramValue == null) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    queryString.append("&");
                }
                queryString.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name()));
                queryString.append("=");
                queryString.append(URLEncoder.encode(paramValue, StandardCharsets.UTF_8.name()));
            }
        }
        return queryString.toString();
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        for (String header : IdentityConstants.HEADERS_WITH_IP) {
            String ip = request.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return IdentityUtil.getFirstIP(ip);
        }
        return request.getRemoteAddr();
    }

    public static String getFirstIP(String commaSeparatedIPs) {
        if (StringUtils.isNotEmpty((String)commaSeparatedIPs) && commaSeparatedIPs.contains(",")) {
            return commaSeparatedIPs.split(",")[0];
        }
        return commaSeparatedIPs;
    }

    public static int getClockSkewInSeconds() {
        String clockSkewConfigValue = IdentityUtil.getProperty("ClockSkew");
        if (StringUtils.isBlank((String)clockSkewConfigValue) || !StringUtils.isNumeric((String)clockSkewConfigValue)) {
            clockSkewConfigValue = "300";
        }
        return Integer.parseInt(clockSkewConfigValue);
    }

    public static boolean isFederatedUserAssociationEnabled() {
        String enableFedUserAssocicationConfigValue = IdentityUtil.getProperty("EnableFederatedUserAssociation");
        if (StringUtils.isBlank((String)enableFedUserAssocicationConfigValue)) {
            enableFedUserAssocicationConfigValue = "false";
        }
        return Boolean.parseBoolean(enableFedUserAssocicationConfigValue);
    }

    public static boolean isSupportedByUserStore(UserStoreManager userStoreManager, String operation) {
        String isOperationSupportedProperty;
        boolean isOperationSupported = true;
        if (userStoreManager != null && StringUtils.isNotBlank((String)(isOperationSupportedProperty = userStoreManager.getRealmConfiguration().getUserStoreProperty(operation)))) {
            isOperationSupported = Boolean.parseBoolean(isOperationSupportedProperty);
        }
        return isOperationSupported;
    }

    public static boolean isRecoveryEPAvailable() {
        String enableRecoveryEPUrlProperty = IdentityUtil.getProperty(ENABLE_RECOVERY_ENDPOINT);
        return Boolean.parseBoolean(enableRecoveryEPUrlProperty);
    }

    public static boolean isSelfSignUpEPAvailable() {
        String enableSelfSignEPUpUrlProperty = IdentityUtil.getProperty(ENABLE_SELF_SIGN_UP_ENDPOINT);
        return Boolean.parseBoolean(enableSelfSignEPUpUrlProperty);
    }

    public static boolean isEmailUsernameEnabled() {
        String enableEmailUsernameProperty = ServerConfiguration.getInstance().getFirstProperty(ENABLE_EMAIL_USERNAME);
        return Boolean.parseBoolean(enableEmailUsernameProperty);
    }

    public static Certificate convertPEMEncodedContentToCertificate(String certificateContent) throws CertificateException {
        certificateContent = IdentityUtil.getCertificateString(certificateContent);
        byte[] bytes = org.apache.axiom.om.util.Base64.decode((String)certificateContent);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
        return certificate;
    }

    public static String getCertificateString(String certificateContent) {
        String certificateContentString = null;
        if (certificateContent != null) {
            String certificateContentWithoutPemBegin = certificateContent.startsWith(PEM_BEGIN_CERTFICATE) ? certificateContent.substring(certificateContent.indexOf(PEM_BEGIN_CERTFICATE) + PEM_BEGIN_CERTFICATE.length()) : certificateContent;
            certificateContentString = certificateContentWithoutPemBegin.endsWith(PEM_END_CERTIFICATE) ? certificateContentWithoutPemBegin.substring(0, certificateContentWithoutPemBegin.indexOf(PEM_END_CERTIFICATE)) : certificateContentWithoutPemBegin;
        }
        return certificateContentString;
    }

    public static String convertCertificateToPEM(Certificate certificate) throws CertificateException {
        byte[] encodedCertificate = org.apache.commons.codec.binary.Base64.encodeBase64((byte[])certificate.getEncoded());
        String encodedPEM = String.format("%s\n%s\n%s", PEM_BEGIN_CERTFICATE, new String(encodedCertificate), PEM_END_CERTIFICATE);
        return encodedPEM;
    }

    public static boolean isValidPEMCertificate(String certificateContent) {
        if (StringUtils.isBlank((String)certificateContent)) {
            return true;
        }
        try {
            IdentityUtil.convertPEMEncodedContentToCertificate(certificateContent);
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    public static String base58Encode(byte[] input) {
        int zeros;
        if (input.length == 0) {
            return "";
        }
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        input = Arrays.copyOf(input, input.length);
        char[] encoded = new char[input.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < input.length) {
            encoded[--outputStart] = IdentityCoreConstants.ALPHABET[IdentityUtil.divmod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == IdentityCoreConstants.ENCODED_ZERO) {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = IdentityCoreConstants.ENCODED_ZERO;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    public static byte[] base58Decode(String input) throws RuntimeException {
        int zeros;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            int digit;
            char c = input.charAt(i);
            int n = digit = c < '\u0080' ? IdentityCoreConstants.INDEXES[c] : -1;
            if (digit < 0) {
                throw new RuntimeException(String.format("Invalid character %s at %s", Character.valueOf(c), i));
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = IdentityUtil.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    public static int getMaximumItemPerPage() {
        int maximumItemsPerPage = 100;
        String maximumItemsPerPagePropertyValue = IdentityUtil.getProperty("MaximumItemsPerPage");
        if (StringUtils.isNotBlank((String)maximumItemsPerPagePropertyValue)) {
            try {
                maximumItemsPerPage = Integer.parseInt(maximumItemsPerPagePropertyValue);
            }
            catch (NumberFormatException e) {
                maximumItemsPerPage = 100;
                log.warn((Object)"Error occurred while parsing the 'MaximumItemsPerPage' property value in identity.xml.", (Throwable)e);
            }
        }
        return maximumItemsPerPage;
    }

    public static int getDefaultItemsPerPage() {
        int defaultItemsPerPage = 15;
        try {
            int defaultItemsPerPageConfig;
            String defaultItemsPerPageProperty = IdentityUtil.getProperty("DefaultItemsPerPage");
            if (StringUtils.isNotBlank((String)defaultItemsPerPageProperty) && (defaultItemsPerPageConfig = Integer.parseInt(defaultItemsPerPageProperty)) > 0) {
                defaultItemsPerPage = defaultItemsPerPageConfig;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultItemsPerPage;
    }
}

