/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class IdentityTenantUtil {
    private static RealmService realmService;
    private static RegistryService registryService;
    private static Log log;
    private static TenantRegistryLoader tenantRegistryLoader;
    private static BundleContext bundleContext;
    protected static ConcurrentHashMap<Integer, Boolean> tenantIdMap;

    public static TenantRegistryLoader getTenantRegistryLoader() {
        return tenantRegistryLoader;
    }

    public static void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        IdentityTenantUtil.tenantRegistryLoader = tenantRegistryLoader;
    }

    public static Registry getConfigRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    public static Registry getRegistry(String domainName, String username) throws IdentityException {
        HttpSession httpSess = IdentityTenantUtil.getHttpSession();
        if (httpSess != null && httpSess.getAttribute("wso2carbon.admin.logged.in") != null) {
            try {
                return AdminServicesUtil.getSystemRegistry();
            }
            catch (CarbonException e) {
                log.error((Object)"Error obtaining a registry instance", (Throwable)e);
                throw IdentityException.error((String)"Error obtaining a registry instance", (Throwable)e);
            }
        }
        return IdentityTenantUtil.getRegistryForAnonymousSession(domainName, username);
    }

    public static Registry getRegistry() throws IdentityException {
        try {
            return AdminServicesUtil.getSystemRegistry();
        }
        catch (CarbonException e) {
            log.error((Object)"Error obtaining a registry instance", (Throwable)e);
            throw IdentityException.error((String)"Error obtaining a registry instance", (Throwable)e);
        }
    }

    public static UserRealm getRealm(String domainName, String username) throws IdentityException {
        return IdentityTenantUtil.getRealmForAnonymousSession(domainName, username);
    }

    private static Registry getRegistryForAnonymousSession(String domainName, String username) throws IdentityException {
        try {
            if (domainName == null && username == null) {
                domainName = "carbon.super";
            }
            if (username == null) {
                return AnonymousSessionUtil.getSystemRegistryByDomainName((RegistryService)registryService, (RealmService)realmService, (String)domainName);
            }
            return AnonymousSessionUtil.getSystemRegistryByUserName((RegistryService)registryService, (RealmService)realmService, (String)username);
        }
        catch (CarbonException e) {
            log.error((Object)"Error obtaining a registry instance", (Throwable)e);
            throw IdentityException.error((String)"Error obtaining a registry instance", (Throwable)e);
        }
    }

    private static UserRealm getRealmForAnonymousSession(String domainName, String username) throws IdentityException {
        try {
            if (username != null) {
                return AnonymousSessionUtil.getRealmByUserName((RegistryService)registryService, (RealmService)realmService, (String)username);
            }
            if (domainName == null) {
                domainName = "carbon.super";
            }
            return AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)domainName);
        }
        catch (CarbonException e) {
            throw IdentityException.error((String)("Error Obtaining a realm for user name: " + username + " and domain:" + domainName), (Throwable)e);
        }
    }

    public static String getGlobalUserName(String userName) {
        if (userName != null && userName.indexOf("@") > 0) {
            return userName;
        }
        String domain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (domain != null) {
            return userName + "@" + domain;
        }
        return userName;
    }

    private static HttpSession getHttpSession() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        HttpSession httpSess = null;
        if (msgCtx != null) {
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSess = request.getSession();
        }
        return httpSess;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static void setRegistryService(RegistryService registryService) {
        IdentityTenantUtil.registryService = registryService;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        IdentityTenantUtil.bundleContext = bundleContext;
    }

    @Deprecated
    public static RealmService getRealmService() {
        return realmService;
    }

    @Deprecated
    public static void setRealmService(RealmService realmService) {
        IdentityTenantUtil.realmService = realmService;
    }

    @Deprecated
    public static void initializeRegistry(int tenantId, String tenantDomain) throws IdentityException {
        IdentityTenantUtil.initializeRegistry(tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeRegistry(int tenantId) throws IdentityException {
        block10: {
            String tenantDomain = IdentityTenantUtil.getTenantDomain(tenantId);
            if (!(tenantIdMap.get(tenantId) != null && tenantIdMap.get(tenantId).booleanValue() || tenantId == -1234)) {
                try {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    carbonContext.setTenantDomain(tenantDomain, true);
                    BundleContext bundleContext = IdentityTenantUtil.getBundleContext();
                    if (bundleContext == null) break block10;
                    ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
                    tracker.open();
                    Object[] services = tracker.getServices();
                    if (services != null) {
                        for (Object service : services) {
                            ((AuthenticationObserver)service).startedAuthentication(tenantId);
                        }
                    }
                    tracker.close();
                    try {
                        IdentityTenantUtil.getTenantRegistryLoader().loadTenantRegistry(tenantId);
                    }
                    catch (RegistryException e) {
                        throw IdentityException.error((String)("Error loading tenant registry for tenant domain " + tenantDomain), (Throwable)e);
                    }
                    try {
                        registryService.getGovernanceSystemRegistry(tenantId);
                        tenantIdMap.put(tenantId, true);
                    }
                    catch (RegistryException e) {
                        throw IdentityException.error((String)("Error obtaining governance system registry for tenant domain " + tenantDomain), (Throwable)e);
                    }
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
        }
    }

    public static int getTenantId(String tenantDomain) throws IdentityRuntimeException {
        int tenantId = -1;
        try {
            if (realmService != null) {
                tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            }
        }
        catch (UserStoreException e) {
            throw IdentityRuntimeException.error((String)("Error occurred while retrieving tenantId for tenantDomain: " + tenantDomain + e.getMessage()), (Throwable)e);
        }
        if (tenantId == -1) {
            throw IdentityRuntimeException.error((String)("Invalid tenant domain " + tenantDomain));
        }
        return tenantId;
    }

    public static String getTenantDomain(int tenantId) throws IdentityRuntimeException {
        String tenantDomain = null;
        try {
            tenantDomain = realmService.getTenantManager().getDomain(tenantId);
        }
        catch (UserStoreException e) {
            throw IdentityRuntimeException.error((String)("Error occurred while retrieving tenantDomain for tenantId: " + tenantId + e.getMessage()), (Throwable)e);
        }
        if (tenantDomain == null) {
            throw IdentityRuntimeException.error((String)("Can not find the tenant domain for the tenant id " + tenantId));
        }
        return tenantDomain;
    }

    public static int getTenantIdOfUser(String username) throws IdentityRuntimeException {
        int tenantId = -1;
        String domainName = MultitenantUtils.getTenantDomain((String)username);
        if (domainName != null) {
            try {
                TenantManager tenantManager = IdentityTenantUtil.getRealmService().getTenantManager();
                tenantId = tenantManager.getTenantId(domainName);
            }
            catch (UserStoreException e) {
                String errorMsg = "Error when getting the tenant id from the tenant domain : " + domainName;
                throw IdentityRuntimeException.error((String)errorMsg, (Throwable)e);
            }
        }
        if (tenantId == -1) {
            throw IdentityRuntimeException.error((String)("Invalid tenant domain of user " + username));
        }
        return tenantId;
    }

    public static String getTenantDomainFromContext() {
        return (String)IdentityUtil.threadLocalProperties.get().get("TenantNameFromContext");
    }

    public static boolean isTenantQualifiedUrlsEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty("EnableTenantQualifiedUrls"));
    }

    public static boolean isLegacySaaSAuthenticationEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty("EnableLegacySaaSAuthentication"));
    }

    static {
        log = LogFactory.getLog(IdentityTenantUtil.class);
        tenantIdMap = new ConcurrentHashMap();
    }
}

