/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.utils.CarbonUtils;

class IdentityLogTokenParser {
    private static IdentityLogTokenParser identityLogTokenParser;
    private static Map<String, String> logTokenMap;
    private static String filePath;
    private static final Object lock;
    private static Log log;

    private IdentityLogTokenParser() {
        boolean readProperties = Boolean.valueOf(System.getProperty("Read_Log_Token_Properties"));
        if (readProperties) {
            IdentityLogTokenParser.buildConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityLogTokenParser getInstance() {
        if (identityLogTokenParser == null) {
            Object object = lock;
            synchronized (object) {
                if (identityLogTokenParser == null) {
                    identityLogTokenParser = new IdentityLogTokenParser();
                }
            }
        }
        return identityLogTokenParser;
    }

    Map<String, String> getLogTokenMap() {
        return logTokenMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildConfiguration() {
        if (filePath == null) {
            filePath = CarbonUtils.getCarbonSecurityConfigDirPath() + File.separator + "identity_log_tokens.properties";
        }
        FileInputStream fileInput = null;
        try {
            File file = new File(filePath);
            fileInput = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInput);
            for (String propertyName : properties.stringPropertyNames()) {
                logTokenMap.put(propertyName, properties.getProperty(propertyName));
            }
        }
        catch (IOException e) {
            log.error((Object)"An error occur while reading the file", (Throwable)e);
        }
        finally {
            try {
                if (fileInput != null) {
                    fileInput.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing the file", (Throwable)e);
            }
        }
    }

    static {
        logTokenMap = new HashMap<String, String>();
        lock = new Object();
        log = LogFactory.getLog(IdentityConfigParser.class);
    }
}

