/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentityIOStreamUtils {
    private static final Log log = LogFactory.getLog(IdentityIOStreamUtils.class);

    public static void closeAllStreams(InputStream input, OutputStream output) {
        IdentityIOStreamUtils.closeInputStream(input);
        IdentityIOStreamUtils.closeOutputStream(output);
    }

    public static void closeInputStream(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Error occurred while closing Input stream", (Throwable)ioe);
        }
    }

    public static void closeOutputStream(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Error occurred while closing Output stream", (Throwable)ioe);
        }
    }

    public static void flushOutputStream(OutputStream output) {
        try {
            if (output != null) {
                output.flush();
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Error occurred while flushing Output stream", (Throwable)ioe);
        }
    }

    public static void closeReader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Error occurred while closing Reader", (Throwable)ioe);
        }
    }
}

