/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.persistence.JDBCPersistenceManager;
import org.wso2.carbon.identity.core.persistence.UmPersistenceManager;

public class IdentityDatabaseUtil {
    private static final Log log = LogFactory.getLog(IdentityDatabaseUtil.class);

    @Deprecated
    public static Connection getDBConnection() throws IdentityRuntimeException {
        return IdentityDatabaseUtil.getDBConnection(true);
    }

    public static Connection getDBConnection(boolean shouldApplyTransaction) throws IdentityRuntimeException {
        return JDBCPersistenceManager.getInstance().getDBConnection(shouldApplyTransaction);
    }

    public static DataSource getDataSource() {
        return JDBCPersistenceManager.getInstance().getDataSource();
    }

    public static void closeAllConnections(Connection dbConnection, ResultSet rs, PreparedStatement prepStmt) {
        IdentityDatabaseUtil.closeResultSet(rs);
        IdentityDatabaseUtil.closeStatement(prepStmt);
        IdentityDatabaseUtil.closeConnection(dbConnection);
    }

    public static void closeConnection(Connection dbConnection) {
        if (dbConnection != null) {
            try {
                dbConnection.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close result set  - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Deprecated
    public static void rollBack(Connection dbConnection) {
        IdentityDatabaseUtil.rollbackTransaction(dbConnection);
    }

    public static void rollbackTransaction(Connection dbConnection) {
        JDBCPersistenceManager.getInstance().rollbackTransaction(dbConnection);
    }

    public static void commitTransaction(Connection dbConnection) {
        JDBCPersistenceManager.getInstance().commitTransaction(dbConnection);
    }

    @Deprecated
    public static Connection getUserDBConnection() throws IdentityRuntimeException {
        Connection connection;
        try {
            connection = UmPersistenceManager.getInstance().getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw IdentityRuntimeException.error((String)"Database error. Could not get a connection", (Throwable)e);
        }
        return connection;
    }

    public static Connection getUserDBConnection(boolean shouldApplyTransaction) throws IdentityRuntimeException {
        return UmPersistenceManager.getInstance().getDBConnection(shouldApplyTransaction);
    }

    public static void commitUserDBTransaction(Connection dbConnection) {
        UmPersistenceManager.getInstance().commitTransaction(dbConnection);
    }

    public static void rollbackUserDBTransaction(Connection dbConnection) {
        UmPersistenceManager.getInstance().rollbackTransaction(dbConnection);
    }
}

