/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.SameSiteCookie;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.model.IdentityCacheConfig;
import org.wso2.carbon.identity.core.model.IdentityCacheConfigKey;
import org.wso2.carbon.identity.core.model.IdentityCookieConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfigKey;
import org.wso2.carbon.identity.core.model.LegacyFeatureConfig;
import org.wso2.carbon.identity.core.model.ReverseProxyConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class IdentityConfigParser {
    private static Map<String, Object> configuration = new HashMap<String, Object>();
    private static Map<IdentityEventListenerConfigKey, IdentityEventListenerConfig> eventListenerConfiguration = new HashMap<IdentityEventListenerConfigKey, IdentityEventListenerConfig>();
    private static Map<IdentityCacheConfigKey, IdentityCacheConfig> identityCacheConfigurationHolder = new HashMap<IdentityCacheConfigKey, IdentityCacheConfig>();
    private static Map<String, IdentityCookieConfig> identityCookieConfigurationHolder = new HashMap<String, IdentityCookieConfig>();
    private static Map<String, ReverseProxyConfig> reverseProxyConfigurationHolder = new HashMap<String, ReverseProxyConfig>();
    private static Map<String, LegacyFeatureConfig> legacyFeatureConfigurationHolder = new HashMap<String, LegacyFeatureConfig>();
    public static final String IS_DISTRIBUTED_CACHE = "isDistributed";
    public static final String IS_TEMPORARY = "isTemporary";
    private static final String SERVICE_PROVIDER_CACHE = "ServiceProviderCache";
    private static final String SERVICE_PROVIDER_AUTH_KEY_CACHE = "ServiceProvideCache.InboundAuth";
    private static final String SERVICE_PROVIDER_ID_CACHE = "ServiceProviderCache.ID";
    private static IdentityConfigParser parser;
    private static SecretResolver secretResolver;
    private static Object lock;
    private static Log log;
    private static String configFilePath;
    private OMElement rootElement;

    private IdentityConfigParser() {
        this.buildConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IdentityConfigParser getInstance() {
        if (parser == null) {
            Object object = lock;
            synchronized (object) {
                if (parser == null) {
                    parser = new IdentityConfigParser();
                }
            }
        }
        return parser;
    }

    public static IdentityConfigParser getInstance(String filePath) {
        configFilePath = filePath;
        return IdentityConfigParser.getInstance();
    }

    public Map<String, Object> getConfiguration() {
        return configuration;
    }

    public static Map<IdentityEventListenerConfigKey, IdentityEventListenerConfig> getEventListenerConfiguration() {
        return eventListenerConfiguration;
    }

    public static Map<IdentityCacheConfigKey, IdentityCacheConfig> getIdentityCacheConfigurationHolder() {
        return identityCacheConfigurationHolder;
    }

    public static Map<String, IdentityCookieConfig> getIdentityCookieConfigurationHolder() {
        return identityCookieConfigurationHolder;
    }

    public static Map<String, ReverseProxyConfig> getReverseProxyConfigurationHolder() {
        return reverseProxyConfigurationHolder;
    }

    public static Map<String, LegacyFeatureConfig> getLegacyFeatureConfigurationHolder() {
        return legacyFeatureConfigurationHolder;
    }

    private void buildConfiguration() {
        InputStream inStream = null;
        StAXOMBuilder builder = null;
        String warningMessage = "";
        try {
            File identityConfigXml;
            if (configFilePath != null) {
                identityConfigXml = new File(configFilePath);
                if (identityConfigXml.exists()) {
                    inStream = new FileInputStream(identityConfigXml);
                }
            } else {
                identityConfigXml = new File(IdentityUtil.getIdentityConfigDirPath(), "identity.xml");
                if (identityConfigXml.exists()) {
                    inStream = new FileInputStream(identityConfigXml);
                }
            }
            if (inStream == null) {
                String message = "Identity configuration not found at: " + configFilePath + " . Cause - " + warningMessage;
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new FileNotFoundException(message);
            }
            builder = new StAXOMBuilder(inStream);
            this.rootElement = builder.getDocumentElement();
            Stack<String> nameStack = new Stack<String>();
            secretResolver = SecretResolverFactory.create((OMElement)this.rootElement, (boolean)true);
            this.readChildElements(this.rootElement, nameStack);
            this.buildEventListenerData();
            this.buildCacheConfig();
            this.buildCookieConfig();
            this.buildLegacyFeatureConfig();
            this.buildReverseProxyConfig();
        }
        catch (IOException | XMLStreamException e) {
            throw IdentityRuntimeException.error((String)"Error occurred while building configuration from identity.xml", (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error closing the input stream for identity.xml", (Throwable)e);
            }
        }
    }

    private void buildEventListenerData() {
        Iterator eventListener;
        OMElement eventListeners = this.getConfigElement("EventListeners");
        if (eventListeners != null && (eventListener = eventListeners.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "EventListener"))) != null) {
            while (eventListener.hasNext()) {
                OMElement eventListenerElement = (OMElement)eventListener.next();
                String eventListenerType = eventListenerElement.getAttributeValue(new QName("type"));
                String eventListenerName = eventListenerElement.getAttributeValue(new QName("name"));
                int order = Integer.parseInt(eventListenerElement.getAttributeValue(new QName("orderId")));
                String enable = eventListenerElement.getAttributeValue(new QName("enable"));
                Iterator propertyElements = eventListenerElement.getChildrenWithName(new QName("Property"));
                Properties properties = new Properties();
                while (propertyElements.hasNext()) {
                    OMElement propertyElem = (OMElement)propertyElements.next();
                    String propertyName = propertyElem.getAttributeValue(new QName("name"));
                    String propertyValue = propertyElem.getText();
                    properties.setProperty(propertyName, propertyValue);
                }
                if (StringUtils.isBlank((String)eventListenerType) || StringUtils.isBlank((String)eventListenerName)) {
                    throw IdentityRuntimeException.error((String)"eventListenerType or eventListenerName is not defined correctly");
                }
                IdentityEventListenerConfigKey configKey = new IdentityEventListenerConfigKey(eventListenerType, eventListenerName);
                IdentityEventListenerConfig identityEventListenerConfig = new IdentityEventListenerConfig(enable, order, configKey, properties);
                eventListenerConfiguration.put(configKey, identityEventListenerConfig);
            }
        }
    }

    private void buildCacheConfig() {
        Iterator cacheManagers;
        OMElement cacheConfig = this.getConfigElement("CacheConfig");
        if (cacheConfig != null && (cacheManagers = cacheConfig.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "CacheManager"))) != null) {
            while (cacheManagers.hasNext()) {
                OMElement cacheManager = (OMElement)cacheManagers.next();
                String cacheManagerName = cacheManager.getAttributeValue(new QName("name"));
                if (StringUtils.isBlank((String)cacheManagerName)) {
                    throw IdentityRuntimeException.error((String)"CacheManager name not defined correctly");
                }
                Iterator caches = cacheManager.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Cache"));
                if (caches != null) {
                    while (caches.hasNext()) {
                        String isTemporaryCache;
                        String isDistributedCache;
                        String capacity;
                        String timeout;
                        OMElement cache = (OMElement)caches.next();
                        String cacheName = cache.getAttributeValue(new QName("name"));
                        if (StringUtils.isBlank((String)cacheName)) {
                            throw IdentityRuntimeException.error((String)"Cache name not defined correctly");
                        }
                        IdentityCacheConfigKey identityCacheConfigKey = new IdentityCacheConfigKey(cacheManagerName, cacheName);
                        IdentityCacheConfig identityCacheConfig = new IdentityCacheConfig(identityCacheConfigKey);
                        String enable = cache.getAttributeValue(new QName("enable"));
                        if (StringUtils.isNotBlank((String)enable)) {
                            identityCacheConfig.setEnabled(Boolean.parseBoolean(enable));
                        }
                        if (StringUtils.isNotBlank((String)(timeout = cache.getAttributeValue(new QName("timeout"))))) {
                            identityCacheConfig.setTimeout(Integer.parseInt(timeout));
                        }
                        if (StringUtils.isNotBlank((String)(capacity = cache.getAttributeValue(new QName("capacity"))))) {
                            identityCacheConfig.setCapacity(Integer.parseInt(capacity));
                        }
                        if (StringUtils.isNotBlank((String)(isDistributedCache = cache.getAttributeValue(new QName(IS_DISTRIBUTED_CACHE))))) {
                            identityCacheConfig.setDistributed(Boolean.parseBoolean(isDistributedCache));
                        }
                        if (StringUtils.isNotBlank((String)(isTemporaryCache = cache.getAttributeValue(new QName(IS_TEMPORARY))))) {
                            identityCacheConfig.setTemporary(Boolean.parseBoolean(isTemporaryCache));
                        }
                        identityCacheConfigurationHolder.put(identityCacheConfigKey, identityCacheConfig);
                    }
                }
                IdentityCacheConfigKey spCacheKey = new IdentityCacheConfigKey(cacheManagerName, SERVICE_PROVIDER_CACHE);
                IdentityCacheConfig identityCacheConfig = identityCacheConfigurationHolder.get(spCacheKey);
                IdentityCacheConfigKey key = new IdentityCacheConfigKey(cacheManagerName, SERVICE_PROVIDER_AUTH_KEY_CACHE);
                identityCacheConfigurationHolder.putIfAbsent(key, identityCacheConfig);
                key = new IdentityCacheConfigKey(cacheManagerName, SERVICE_PROVIDER_ID_CACHE);
                identityCacheConfigurationHolder.putIfAbsent(key, identityCacheConfig);
            }
        }
    }

    private void buildCookieConfig() {
        Iterator cookies;
        OMElement cookiesConfig = this.getConfigElement("Cookies");
        if (cookiesConfig != null && (cookies = cookiesConfig.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Cookie"))) != null) {
            while (cookies.hasNext()) {
                String sameSiteString;
                String httpOnly;
                String secure;
                String magAge;
                String version;
                String comment;
                String path;
                OMElement cookie = (OMElement)cookies.next();
                String cookieName = cookie.getAttributeValue(new QName("name"));
                if (StringUtils.isBlank((String)cookieName)) {
                    throw IdentityRuntimeException.error((String)"Cookie name not defined correctly");
                }
                IdentityCookieConfig cookieConfig = new IdentityCookieConfig(cookieName);
                String domain = cookie.getAttributeValue(new QName("domain"));
                if (StringUtils.isNotBlank((String)domain)) {
                    cookieConfig.setDomain(domain);
                }
                if (StringUtils.isNotBlank((String)(path = cookie.getAttributeValue(new QName("path"))))) {
                    cookieConfig.setPath(path);
                }
                if (StringUtils.isNotBlank((String)(comment = cookie.getAttributeValue(new QName("comment"))))) {
                    cookieConfig.setComment(comment);
                }
                if (StringUtils.isNotBlank((String)(version = cookie.getAttributeValue(new QName("version"))))) {
                    cookieConfig.setVersion(Integer.valueOf(version));
                }
                if (StringUtils.isNotBlank((String)(magAge = cookie.getAttributeValue(new QName("maxAge"))))) {
                    cookieConfig.setMaxAge(Integer.valueOf(magAge));
                }
                if (StringUtils.isNotBlank((String)(secure = cookie.getAttributeValue(new QName("secure"))))) {
                    cookieConfig.setSecure(Boolean.valueOf(secure));
                }
                if (StringUtils.isNotBlank((String)(httpOnly = cookie.getAttributeValue(new QName("httpOnly"))))) {
                    cookieConfig.setIsHttpOnly(Boolean.valueOf(httpOnly));
                }
                if (StringUtils.isNotEmpty((String)(sameSiteString = cookie.getAttributeValue(new QName("sameSite"))))) {
                    try {
                        SameSiteCookie sameSite = SameSiteCookie.valueOf((String)sameSiteString);
                        cookieConfig.setSameSite(sameSite);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IllegalArgumentException("sameSite value should be Strict or Lax or None. ", ex);
                    }
                }
                identityCookieConfigurationHolder.put(cookieName, cookieConfig);
            }
        }
    }

    public void buildLegacyFeatureConfig() {
        OMElement legacyFeaturesConfigElement = this.getConfigElement("LegacyFeatures");
        if (legacyFeaturesConfigElement != null) {
            int legacyFeaturesConfigElementIndex = 0;
            Iterator legacyFeatures = legacyFeaturesConfigElement.getChildrenWithName(this.getQNameWithIdentityNS("LegacyFeature"));
            if (legacyFeatures != null) {
                while (legacyFeatures.hasNext()) {
                    ++legacyFeaturesConfigElementIndex;
                    OMElement legacyFeature = (OMElement)legacyFeatures.next();
                    OMElement legacyFeatureIdElement = legacyFeature.getFirstChildWithName(this.getQNameWithIdentityNS("Id"));
                    OMElement legacyFeatureVersionElement = legacyFeature.getFirstChildWithName(this.getQNameWithIdentityNS("Version"));
                    OMElement legacyFeatureEnableElement = legacyFeature.getFirstChildWithName(this.getQNameWithIdentityNS("Enable"));
                    boolean isLegacyFeatureEnable = false;
                    if (legacyFeatureIdElement != null && legacyFeatureVersionElement != null && legacyFeatureEnableElement != null) {
                        String legacyFeatureEnable;
                        String legacyFeatureVersion;
                        String legacyFeatureId = legacyFeatureIdElement.getText();
                        if (StringUtils.isNotBlank((String)legacyFeatureId)) {
                            legacyFeatureId = legacyFeatureId.trim();
                        }
                        if (StringUtils.isNotBlank((String)(legacyFeatureVersion = legacyFeatureVersionElement.getText()))) {
                            legacyFeatureVersion = legacyFeatureVersion.trim();
                        }
                        if (StringUtils.isNotBlank((String)(legacyFeatureEnable = legacyFeatureEnableElement.getText()))) {
                            isLegacyFeatureEnable = Boolean.parseBoolean(legacyFeatureEnable.trim());
                        }
                        String legacyFeatureConfigKey = legacyFeatureId + legacyFeatureVersion;
                        LegacyFeatureConfig legacyFeatureConfig = new LegacyFeatureConfig(legacyFeatureId, legacyFeatureVersion, isLegacyFeatureEnable);
                        legacyFeatureConfigurationHolder.put(legacyFeatureConfigKey, legacyFeatureConfig);
                        continue;
                    }
                    log.warn((Object)("Configured <LegacyFeature> element at index: " + legacyFeaturesConfigElementIndex + " contains invalid entry."));
                }
            }
        }
    }

    private void buildReverseProxyConfig() {
        OMElement reverseProxyConfigElement = this.getConfigElement("ReverseProxyConfig");
        if (reverseProxyConfigElement != null) {
            int reverseProxyConfigElementIndex = 0;
            Iterator reverseProxies = reverseProxyConfigElement.getChildrenWithName(this.getQNameWithIdentityNS("ReverseProxy"));
            if (reverseProxies != null) {
                while (reverseProxies.hasNext()) {
                    ++reverseProxyConfigElementIndex;
                    OMElement reverseProxy = (OMElement)reverseProxies.next();
                    OMElement defaultContextElement = reverseProxy.getFirstChildWithName(this.getQNameWithIdentityNS("DefaultContext"));
                    OMElement proxyContextElement = reverseProxy.getFirstChildWithName(this.getQNameWithIdentityNS("ProxyContext"));
                    if (defaultContextElement != null && proxyContextElement != null) {
                        String proxyContext;
                        String defaultContext = defaultContextElement.getText();
                        if (StringUtils.isNotBlank((String)defaultContext)) {
                            defaultContext = defaultContext.trim();
                        }
                        if (StringUtils.isNotBlank((String)(proxyContext = proxyContextElement.getText()))) {
                            proxyContext = proxyContext.trim();
                        }
                        ReverseProxyConfig reverseProxyConfig = new ReverseProxyConfig(defaultContext, proxyContext);
                        reverseProxyConfigurationHolder.put(defaultContext, reverseProxyConfig);
                        continue;
                    }
                    log.warn((Object)("Configured <ReverseProxy> element at index: " + reverseProxyConfigElementIndex + " contains invalid entry."));
                }
            }
        }
    }

    private void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                Object currentObject = configuration.get(key);
                String value = this.replaceSystemProperty(element.getText());
                if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected(key)) {
                    value = secretResolver.resolve(key);
                }
                if (currentObject == null) {
                    configuration.put(key, value);
                } else if (currentObject instanceof ArrayList) {
                    ArrayList list = (ArrayList)currentObject;
                    if (!list.contains(value)) {
                        list.add(value);
                        configuration.put(key, list);
                    }
                } else if (!value.equals(currentObject)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(currentObject);
                    arrayList.add(value);
                    configuration.put(key, arrayList);
                }
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    private String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!sysProp.equals("carbon.home") || !System.getProperty("carbon.home").equals(".")) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }

    public OMElement getConfigElement(String localPart) {
        return this.rootElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", localPart));
    }

    public QName getQNameWithIdentityNS(String localPart) {
        return new QName("http://wso2.org/projects/carbon/carbon.xml", localPart);
    }

    static {
        lock = new Object();
        log = LogFactory.getLog(IdentityConfigParser.class);
    }
}

