/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.util;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.base.IdentityException;

public class ClientAuthX509TrustManager
implements X509TrustManager {
    private static Log log = LogFactory.getLog(ClientAuthX509TrustManager.class);
    private X509TrustManager trustManager;
    private static final ServerConfiguration config = ServerConfiguration.getInstance();
    private static final String TRUST_STORE_LOCATION = config.getFirstProperty("Security.TrustStore.Location");
    private static final String TRUST_STORE_TYPE = config.getFirstProperty("Security.TrustStore.Type");

    public ClientAuthX509TrustManager() throws Exception {
        this.setupTrustManager();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            if (Boolean.parseBoolean(System.getProperty("org.wso2.carbon.identity.core.util.TRUST_STORE_UPDATE_REQUIRED"))) {
                this.setupTrustManager();
            }
            this.trustManager.checkClientTrusted(x509Certificates, s);
        }
        catch (Exception e) {
            throw new CertificateException("Error occurred while setting up trust manager." + e.getCause(), e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.trustManager.checkServerTrusted(x509Certificates, s);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        try {
            this.setupTrustManager();
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while reloading trust-store.");
        }
        return this.trustManager.getAcceptedIssuers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupTrustManager() throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        try (FileInputStream trustStoreInputStream = new FileInputStream(TRUST_STORE_LOCATION);){
            TrustManager[] trustManagers;
            KeyStore clientTrustStore = KeyStore.getInstance(TRUST_STORE_TYPE);
            clientTrustStore.load(trustStoreInputStream, null);
            trustManagerFactory.init(clientTrustStore);
            TrustManager[] trustManagerArray = trustManagers = trustManagerFactory.getTrustManagers();
            int n = trustManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                TrustManager t = trustManagerArray[n2];
                if (t instanceof X509TrustManager) {
                    this.trustManager = (X509TrustManager)t;
                    System.setProperty("org.wso2.carbon.identity.core.util.TRUST_STORE_UPDATE_REQUIRED", Boolean.FALSE.toString());
                    return;
                }
                ++n2;
            }
            throw new IdentityException("No X509TrustManager in TrustManagerFactory");
        }
    }
}

