/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.persistence.registry;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.persistence.registry.RegistryResourceMgtService;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;

public class RegistryResourceMgtServiceImpl
implements RegistryResourceMgtService {
    private static final Log log = LogFactory.getLog(RegistryResourceMgtServiceImpl.class);
    private static final RegistryService registryService = IdentityTenantUtil.getRegistryService();
    private static final String EN_US = "en_us";
    private static final String BLACKLIST_REGEX = ".*[/\\\\<>`\"].*";
    private static final String MSG_RESOURCE_PERSIST = "Resource persisted at %s in %s tenant registry.";
    private static final String ERROR_GET_RESOURCE = "Error retrieving registry resource from %s for tenant %s.";
    private static final String ERROR_ADD_RESOURCE = "Error adding registry resource to %s tenant at %s. Resource already exists at the path";
    private static final String ERROR_DELETE_RESOURCE = "Error deleting registry resource of tenant : %s at %s.";
    private static final String ERROR_PERSIST_RESOURCE = "Error persisting registry resource of %s tenant at %s";
    private static final String ERROR_NO_RESOURCE_FOUND = "Resource does not exist at %s in %s tenant domain.";

    @Override
    public Resource getIdentityResource(String path, String tenantDomain, String locale) throws IdentityRuntimeException {
        path = this.getRegistryPath(path, locale);
        return this.getIdentityResource(path, tenantDomain);
    }

    @Override
    public void putIdentityResource(Resource identityResource, String path, String tenantDomain, String locale) throws IdentityRuntimeException {
        path = this.getRegistryPath(path, locale);
        this.putIdentityResource(identityResource, path, tenantDomain);
    }

    @Override
    public void addIdentityResource(Resource identityResource, String path, String tenantDomain, String locale) throws IdentityRuntimeException {
        path = this.getRegistryPath(path, locale);
        this.addIdentityResource(identityResource, path, tenantDomain);
    }

    @Override
    public void deleteIdentityResource(String path, String tenantDomain, String locale) throws IdentityRuntimeException {
        path = this.getRegistryPath(path, locale);
        this.deleteIdentityResource(path, tenantDomain);
    }

    @Override
    public boolean isResourceExists(String path, String tenantDomain, String locale) throws IdentityRuntimeException {
        path = this.getRegistryPath(path, locale);
        return this.isResourceExists(path, tenantDomain);
    }

    @Override
    public Resource getIdentityResource(String path, String tenantDomain) throws IdentityRuntimeException {
        this.startTenantFlow(tenantDomain);
        try {
            Registry registry = this.getRegistryForTenant(tenantDomain);
            Resource resource = null;
            if (registry.resourceExists(path)) {
                resource = registry.get(path);
            }
            Resource resource2 = resource;
            return resource2;
        }
        catch (RegistryException e) {
            String errorMsg = String.format(ERROR_GET_RESOURCE, path, tenantDomain);
            throw IdentityRuntimeException.error((String)errorMsg, (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public void putIdentityResource(Resource identityResource, String path, String tenantDomain) throws IdentityRuntimeException {
        this.startTenantFlow(tenantDomain);
        try {
            Registry registry = this.getRegistryForTenant(tenantDomain);
            registry.put(path, identityResource);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format(MSG_RESOURCE_PERSIST, path, tenantDomain));
            }
        }
        catch (RegistryException e) {
            String errorMsg = String.format(ERROR_PERSIST_RESOURCE, tenantDomain, path);
            throw IdentityRuntimeException.error((String)errorMsg, (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public void addIdentityResource(Resource identityResource, String path, String tenantDomain) throws IdentityRuntimeException {
        this.startTenantFlow(tenantDomain);
        try {
            Registry registry = this.getRegistryForTenant(tenantDomain);
            if (registry.get(path) != null) {
                String errorMsg = String.format(ERROR_ADD_RESOURCE, tenantDomain, path);
                throw IdentityRuntimeException.error((String)errorMsg);
            }
            registry.put(path, identityResource);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format(MSG_RESOURCE_PERSIST, path, tenantDomain));
            }
        }
        catch (RegistryException e) {
            String errorMsg = String.format(ERROR_PERSIST_RESOURCE, tenantDomain, path);
            throw IdentityRuntimeException.error((String)errorMsg, (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Override
    public void deleteIdentityResource(String path, String tenantDomain) throws IdentityRuntimeException {
        block6: {
            this.startTenantFlow(tenantDomain);
            try {
                Registry registry = this.getRegistryForTenant(tenantDomain);
                if (registry.resourceExists(path)) {
                    registry.delete(path);
                    break block6;
                }
                String errorMsg = String.format(ERROR_NO_RESOURCE_FOUND, path, tenantDomain);
                log.error((Object)errorMsg);
                throw IdentityRuntimeException.error((String)errorMsg);
            }
            catch (RegistryException e) {
                String errorMsg = String.format(ERROR_DELETE_RESOURCE, tenantDomain, path);
                throw IdentityRuntimeException.error((String)errorMsg, (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    @Override
    public boolean isResourceExists(String path, String tenantDomain) throws IdentityRuntimeException {
        this.startTenantFlow(tenantDomain);
        try {
            Registry registry = this.getRegistryForTenant(tenantDomain);
            boolean bl = registry.resourceExists(path);
            return bl;
        }
        catch (RegistryException e) {
            String errorMsg = "Error when checking for resource existence at %s in %s tenant domain.";
            throw IdentityRuntimeException.error((String)String.format(errorMsg, path, tenantDomain), (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private Registry getRegistryForTenant(String tenantDomain) throws RegistryException {
        int tenantId = IdentityTenantUtil.getTenantId(tenantDomain);
        return registryService.getConfigSystemRegistry(tenantId);
    }

    private String getRegistryPath(String path, String locale) {
        locale = this.validateLocale(locale);
        path = path + "/" + locale;
        return path;
    }

    private void startTenantFlow(String tenantDomain) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
    }

    private String validateLocale(String locale) {
        String localeString;
        String string = localeString = StringUtils.isBlank((String)locale) ? EN_US : locale.toLowerCase();
        if (localeString.matches(BLACKLIST_REGEX)) {
            throw new IllegalArgumentException("Locale contains invalid special characters : " + locale);
        }
        return localeString;
    }
}

