/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class UmPersistenceManager {
    private static DataSource dataSource;
    private static UmPersistenceManager umPersistenceManager;
    private static final String PG_ACTIVE_SQL_TRANSACTION_STATE = "25001";
    private static final String POSTGRESQL_DATABASE = "PostgreSQL";
    private static Log log;

    private UmPersistenceManager() {
        this.initDatasource();
    }

    public static UmPersistenceManager getInstance() {
        return umPersistenceManager;
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    private void initDatasource() {
        try {
            dataSource = DatabaseUtil.getRealmDataSource((RealmConfiguration)CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration());
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while retrieving user management data source", (Throwable)e);
        }
    }

    public Connection getDBConnection(boolean shouldApplyTransaction) throws IdentityRuntimeException {
        try {
            Connection dbConnection;
            block5: {
                dbConnection = dataSource.getConnection();
                if (shouldApplyTransaction) {
                    dbConnection.setAutoCommit(false);
                    try {
                        dbConnection.setTransactionIsolation(2);
                    }
                    catch (SQLException e) {
                        if (!dbConnection.getMetaData().getDriverName().contains(POSTGRESQL_DATABASE) || !PG_ACTIVE_SQL_TRANSACTION_STATE.equals(e.getSQLState())) break block5;
                        dbConnection.commit();
                        dbConnection.setTransactionIsolation(2);
                    }
                }
            }
            return dbConnection;
        }
        catch (SQLException e) {
            String errMsg = "Error when getting a database connection object from the UM data source.";
            throw IdentityRuntimeException.error((String)errMsg, (Throwable)e);
        }
    }

    public void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions.", (Throwable)e1);
        }
    }

    public void commitTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.commit();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while commit transactions.", (Throwable)e1);
        }
    }

    static {
        umPersistenceManager = new UmPersistenceManager();
        log = LogFactory.getLog(UmPersistenceManager.class);
    }
}

