/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.persistence.IdentityDBInitializer;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;

public class JDBCPersistenceManager {
    private static Log log = LogFactory.getLog(JDBCPersistenceManager.class);
    private static volatile JDBCPersistenceManager instance;
    private DataSource dataSource;
    private static final String PG_ACTIVE_SQL_TRANSACTION_STATE = "25001";
    private static final String POSTGRESQL_DATABASE = "PostgreSQL";

    private JDBCPersistenceManager() {
        this.initDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JDBCPersistenceManager getInstance() {
        if (instance != null) return instance;
        Class<JDBCPersistenceManager> clazz = JDBCPersistenceManager.class;
        synchronized (JDBCPersistenceManager.class) {
            if (instance != null) return instance;
            instance = new JDBCPersistenceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initDataSource() {
        OMElement persistenceManagerConfigElem = IdentityConfigParser.getInstance().getConfigElement("JDBCPersistenceManager");
        try {
            if (persistenceManagerConfigElem == null) {
                String errorMsg = "Identity Persistence Manager configuration is not available in identity.xml file. Terminating the JDBC Persistence Manager initialization. This may affect certain functionality.";
                throw IdentityRuntimeException.error((String)errorMsg);
            }
            OMElement dataSourceElem = persistenceManagerConfigElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "DataSource"));
            if (dataSourceElem == null) {
                String errorMsg = "DataSource Element is not available for JDBC Persistence Manager in identity.xml file. Terminating the JDBC Persistence Manager initialization. This might affect certain features.";
                throw IdentityRuntimeException.error((String)errorMsg);
            }
            OMElement dataSourceNameElem = dataSourceElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Name"));
            if (dataSourceNameElem != null) {
                String dataSourceName = dataSourceNameElem.getText();
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(dataSourceName);
            }
        }
        catch (NamingException e) {
            String errorMsg = "Error when looking up the Identity Data Source.";
            throw IdentityRuntimeException.error((String)errorMsg, (Throwable)e);
        }
    }

    public void initializeDatabase() {
        IdentityDBInitializer dbInitializer = new IdentityDBInitializer(this.dataSource);
        dbInitializer.createIdentityDatabase();
    }

    @Deprecated
    public Connection getDBConnection() throws IdentityRuntimeException {
        return this.getDBConnection(true);
    }

    public Connection getDBConnection(boolean shouldApplyTransaction) throws IdentityRuntimeException {
        try {
            Connection dbConnection;
            block5: {
                dbConnection = this.dataSource.getConnection();
                if (shouldApplyTransaction) {
                    dbConnection.setAutoCommit(false);
                    try {
                        dbConnection.setTransactionIsolation(2);
                    }
                    catch (SQLException e) {
                        if (!dbConnection.getMetaData().getDriverName().contains(POSTGRESQL_DATABASE) || !PG_ACTIVE_SQL_TRANSACTION_STATE.equals(e.getSQLState())) break block5;
                        dbConnection.commit();
                        dbConnection.setTransactionIsolation(2);
                    }
                }
            }
            return dbConnection;
        }
        catch (SQLException e) {
            String errMsg = "Error when getting a database connection object from the Identity data source.";
            throw IdentityRuntimeException.error((String)errMsg, (Throwable)e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }

    public void commitTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.commit();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while commit transactions. ", (Throwable)e1);
        }
    }
}

