/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.persistence;

import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.dao.OpenIDAdminDAO;
import org.wso2.carbon.identity.core.dao.OpenIDUserDAO;
import org.wso2.carbon.identity.core.dao.ParameterDAO;
import org.wso2.carbon.identity.core.dao.SAMLSSOServiceProviderDAO;
import org.wso2.carbon.identity.core.dao.XMPPSettingsDAO;
import org.wso2.carbon.identity.core.model.OpenIDAdminDO;
import org.wso2.carbon.identity.core.model.OpenIDUserDO;
import org.wso2.carbon.identity.core.model.ParameterDO;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.core.model.XMPPSettingsDO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.user.core.UserRealm;

public class IdentityPersistenceManager {
    private static IdentityPersistenceManager manager = new IdentityPersistenceManager();

    private IdentityPersistenceManager() {
    }

    public static IdentityPersistenceManager getPersistanceManager() throws IdentityException {
        return manager;
    }

    public void createOrUpdateParameter(Registry registry, String paramName, String value) throws IdentityException {
        if (paramName == null || value == null) {
            throw IdentityException.error((String)"Invalid inputs");
        }
        ParameterDO param = null;
        param = new ParameterDO();
        paramName = paramName.trim();
        param.setName(paramName);
        param.setValue(value);
        ParameterDAO dao = new ParameterDAO(registry);
        dao.createOrUpdateParameter(param);
    }

    public String getParameterValue(Registry registry, String paramName) throws IdentityException {
        String value = null;
        ParameterDO param = null;
        param = this.getParameter(registry, paramName);
        if (param != null) {
            value = param.getValue();
        }
        return value;
    }

    public ParameterDO getParameter(Registry registry, String paramName) throws IdentityException {
        ParameterDAO dao = new ParameterDAO(registry);
        return dao.getParameter(paramName);
    }

    public void removeParameter(Registry registry, ParameterDO parameterDO) throws IdentityException {
        ParameterDAO dao = new ParameterDAO(registry);
        dao.removeParameter(parameterDO);
    }

    public void addXmppSettings(Registry registry, String userId, String xmppServer, String xmppUserName, String xmppUserCode, boolean enabled, boolean isPINEnabled) throws IdentityException {
        XMPPSettingsDAO dao = new XMPPSettingsDAO(registry);
        dao.addXmppSettings(userId, xmppServer, xmppUserName, xmppUserCode, enabled, isPINEnabled);
    }

    public XMPPSettingsDO getXmppSettings(Registry registry, String userId) {
        XMPPSettingsDAO dao = new XMPPSettingsDAO(registry);
        return dao.getXmppSettings(userId);
    }

    public void updateXmppSettings(Registry registry, String userId, String xmppServer, String xmppUserName, String xmppUserCode, boolean enabled, boolean isPINEnabled) throws IdentityException {
        XMPPSettingsDAO dao = new XMPPSettingsDAO(registry);
        dao.updateXmppSettings(userId, xmppServer, xmppUserName, xmppUserCode, enabled, isPINEnabled);
    }

    public boolean isXmppSettingsEnabled(Registry registry, String userId) {
        XMPPSettingsDAO dao = new XMPPSettingsDAO(registry);
        return dao.isXmppSettingsEnabled(userId);
    }

    public boolean hasXMPPSettings(Registry registry, String userId) {
        XMPPSettingsDAO dao = new XMPPSettingsDAO(registry);
        return dao.hasXmppSettings(userId);
    }

    public boolean doOpenIdSignUp(Registry registry, UserRealm realm, String openId, String userId) {
        OpenIDUserDO userDO = new OpenIDUserDO();
        userDO.setUserName(userId);
        userDO.setOpenID(openId);
        OpenIDUserDAO userDOA = new OpenIDUserDAO(registry, realm);
        return userDOA.addAssociation(userDO);
    }

    public String getUserIdForOpenIDSignUp(Registry registry, UserRealm realm, String openId) {
        OpenIDUserDAO userDOA = new OpenIDUserDAO(registry, realm);
        return userDOA.getUserIdForAssociation(openId);
    }

    public boolean hasSignedUpForOpenId(Registry registry, UserRealm realm, String openID) {
        OpenIDUserDAO userDOA = new OpenIDUserDAO(registry, realm);
        return userDOA.hasAssociation(openID);
    }

    public String[] getOpenIDsForUser(Registry registry, UserRealm realm, String username) {
        OpenIDUserDAO openIDUserDOA = new OpenIDUserDAO(registry, realm);
        return openIDUserDOA.getOpenIDsForUser(username);
    }

    public void removeOpenIDSignUp(Registry registry, UserRealm realm, String openID) {
        OpenIDUserDAO userDOA = new OpenIDUserDAO(registry, realm);
        userDOA.removeOpenIDSignUp(openID);
    }

    public boolean addServiceProvider(Registry registry, SAMLSSOServiceProviderDO serviceProviderDO) throws IdentityException {
        SAMLSSOServiceProviderDAO serviceProviderDAO = new SAMLSSOServiceProviderDAO(registry);
        return serviceProviderDAO.addServiceProvider(serviceProviderDO);
    }

    public SAMLSSOServiceProviderDO uploadServiceProvider(Registry registry, SAMLSSOServiceProviderDO samlssoServiceProviderDO) throws IdentityException {
        SAMLSSOServiceProviderDAO serviceProviderDAO = new SAMLSSOServiceProviderDAO(registry);
        return serviceProviderDAO.uploadServiceProvider(samlssoServiceProviderDO);
    }

    public SAMLSSOServiceProviderDO[] getServiceProviders(Registry registry) throws IdentityException {
        SAMLSSOServiceProviderDAO serviceProviderDOA = new SAMLSSOServiceProviderDAO(registry);
        return serviceProviderDOA.getServiceProviders();
    }

    public boolean removeServiceProvider(Registry registry, String issuer) throws IdentityException {
        SAMLSSOServiceProviderDAO serviceProviderDAO = new SAMLSSOServiceProviderDAO(registry);
        return serviceProviderDAO.removeServiceProvider(issuer);
    }

    public SAMLSSOServiceProviderDO getServiceProvider(Registry registry, String issuer) throws IdentityException {
        SAMLSSOServiceProviderDAO serviceProviderDAO = new SAMLSSOServiceProviderDAO(registry);
        return serviceProviderDAO.getServiceProvider(issuer);
    }

    public boolean isServiceProviderExists(Registry registry, String issuer) throws IdentityException {
        SAMLSSOServiceProviderDAO serviceProviderDAO = new SAMLSSOServiceProviderDAO(registry);
        return serviceProviderDAO.isServiceProviderExists(issuer);
    }

    public void createOrUpdateOpenIDAdmin(Registry registry, OpenIDAdminDO opAdmin) throws IdentityException {
        OpenIDAdminDAO opDAO = new OpenIDAdminDAO(registry);
        opDAO.createOrUpdate(opAdmin);
    }

    public OpenIDAdminDO getOpenIDAdmin(Registry registry) throws IdentityException {
        OpenIDAdminDAO opDAO = new OpenIDAdminDAO(registry);
        return opDAO.getOpenIDAdminDO();
    }
}

