/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.persistence;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;

public class IdentityDBInitializer {
    private static final String DB_CHECK_SQL = "SELECT * FROM IDN_BASE_TABLE";
    private static Log log = LogFactory.getLog(IdentityDBInitializer.class);
    Statement statement;
    private DataSource dataSource;
    private String delimiter = ";";

    IdentityDBInitializer(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static String getDatabaseType(Connection conn) throws IdentityRuntimeException {
        String type;
        block13: {
            type = null;
            try {
                if (conn == null || conn.isClosed()) break block13;
                DatabaseMetaData metaData = conn.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                if (databaseProductName.matches("(?i).*hsql.*")) {
                    type = "hsql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*derby.*")) {
                    type = "derby";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*mysql.*")) {
                    type = "mysql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*mariadb.*")) {
                    type = "mariadb";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*oracle.*")) {
                    type = "oracle";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*microsoft.*")) {
                    type = "mssql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*h2.*")) {
                    type = "h2";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*db2.*")) {
                    type = "db2";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*postgresql.*")) {
                    type = "postgresql";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*openedge.*")) {
                    type = "openedge";
                    break block13;
                }
                if (databaseProductName.matches("(?i).*informix.*")) {
                    type = "informix";
                    break block13;
                }
                String msg = "Unsupported database: " + databaseProductName + ". Database will not be created automatically by the WSO2 Identity Server. Please create the database using appropriate database scripts for the database.";
                throw IdentityRuntimeException.error((String)msg);
            }
            catch (SQLException e) {
                String msg = "Failed to create identity database." + e.getMessage();
                throw IdentityRuntimeException.error((String)msg, (Throwable)e);
            }
        }
        return type;
    }

    public static boolean checkStringBufferEndsWith(StringBuffer buffer, String suffix) {
        if (suffix.length() > buffer.length()) {
            return false;
        }
        int bufferIndex = buffer.length() - 1;
        for (int endIndex = suffix.length() - 1; endIndex >= 0; --endIndex) {
            if (buffer.charAt(bufferIndex) != suffix.charAt(endIndex)) {
                return false;
            }
            --bufferIndex;
        }
        return true;
    }

    void createIdentityDatabase() {
        if (!this.isDatabaseStructureCreated()) {
            Connection conn = null;
            try {
                conn = this.dataSource.getConnection();
                conn.setAutoCommit(false);
                this.statement = conn.createStatement();
                this.executeSQLScript();
                conn.commit();
                log.debug((Object)"Identity tables are created successfully.");
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    throw new IdentityRuntimeException("SQL transaction rollback connection error occurred while create database tables for Identity meta-data store.", (Throwable)e1);
                }
                String msg = "Failed to create database tables for Identity meta-data store. " + e.getMessage();
                throw IdentityRuntimeException.error((String)msg, (Throwable)e);
            }
            finally {
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Failed to close statement.", (Throwable)e);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Failed to close database connection.", (Throwable)e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Database already exists. Not creating a new database.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDatabaseStructureCreated() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Running a query to test the database tables existence");
            }
            Connection conn = this.dataSource.getConnection();
            Statement statement = null;
            try {
                statement = conn.createStatement();
                ResultSet rs = statement.executeQuery(DB_CHECK_SQL);
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private void executeSQLScript() {
        String databaseType = null;
        try {
            databaseType = IdentityDBInitializer.getDatabaseType(this.dataSource.getConnection());
        }
        catch (Exception e) {
            throw IdentityRuntimeException.error((String)"Error occurred while getting database type");
        }
        boolean keepFormat = false;
        if ("oracle".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("db2".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("openedge".equals(databaseType)) {
            this.delimiter = "/";
            keepFormat = true;
        }
        String dbScriptLocation = this.getDbScriptLocation(databaseType);
        StringBuffer sql = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream is = new FileInputStream(dbScriptLocation);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String token;
                StringTokenizer st;
                line = line.trim();
                if (!keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
                sql.append(keepFormat ? "\n" : " ").append(line);
                if (!keepFormat && line.contains("--")) {
                    sql.append("\n");
                }
                if (!IdentityDBInitializer.checkStringBufferEndsWith(sql, this.delimiter)) continue;
                this.executeSQL(sql.substring(0, sql.length() - this.delimiter.length()));
                sql.replace(0, sql.length(), "");
            }
            if (sql.length() > 0) {
                this.executeSQL(sql.toString());
            }
        }
        catch (IOException e) {
            throw IdentityRuntimeException.error((String)"Error occurred while executing SQL script for creating identity database", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurred while closing stream for Identity SQL script", (Throwable)e);
                }
            }
        }
    }

    protected String getDbScriptLocation(String databaseType) {
        String scriptName = databaseType + ".sql";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading database script from :" + scriptName));
        }
        String carbonHome = System.getProperty("carbon.home");
        return carbonHome + "/dbscripts/identity/" + scriptName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(String sql) {
        block27: {
            if ("".equals(sql.trim())) {
                return;
            }
            ResultSet resultSet = null;
            Connection conn = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SQL : " + sql));
                }
                int updateCountTotal = 0;
                boolean ret = this.statement.execute(sql);
                int updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
                do {
                    if (!ret && updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                    if (!(ret = this.statement.getMoreResults())) continue;
                    updateCount = this.statement.getUpdateCount();
                    resultSet = this.statement.getResultSet();
                } while (ret);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sql + " : " + updateCountTotal + " rows affected"));
                }
                conn = this.dataSource.getConnection();
                for (SQLWarning warning = conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    log.debug((Object)(warning + " sql warning"));
                }
                conn.clearWarnings();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("X0Y32") || e.getSQLState().equals("42710")) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)"Table Already Exists. Hence, skipping table creation");
                    }
                    break block27;
                }
                throw IdentityRuntimeException.error((String)("Error occurred while executing : " + sql), (Throwable)e);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error occurred while closing result set.", (Throwable)e);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error occurred while closing sql connection.", (Throwable)e);
                    }
                }
            }
        }
    }
}

