/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.model;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ua_parser.Device;
import ua_parser.OS;
import ua_parser.Parser;

public class UserAgent {
    private static final Log LOG = LogFactory.getLog(UserAgent.class);
    private static Parser parser;
    private String rawString;
    private ua_parser.UserAgent browser;
    private OS platform;
    private Device device;

    public UserAgent(String rawString) {
        this.rawString = rawString;
    }

    public static synchronized Parser getParser() {
        if (parser == null) {
            try {
                parser = new Parser();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to initialize the user agent parser: ", (Throwable)e);
            }
        }
        return parser;
    }

    public String getRawString() {
        return this.rawString;
    }

    public void setRawString(String rawString) {
        this.rawString = rawString;
        this.browser = null;
        this.platform = null;
        this.device = null;
    }

    public String getBrowser() {
        if (this.browser == null) {
            this.browser = UserAgent.getParser().parseUserAgent(this.rawString);
        }
        return this.browser.family;
    }

    public String getPlatform() {
        if (this.platform == null) {
            this.platform = UserAgent.getParser().parseOS(this.rawString);
        }
        return this.platform.family;
    }

    public String getDevice() {
        if (this.device == null) {
            this.device = UserAgent.getParser().parseDevice(this.rawString);
        }
        return this.device.family;
    }
}

