/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.model;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class SAMLSSOServiceProviderDO
implements Serializable {
    private static final long serialVersionUID = 7998724745099007704L;
    String tenantDomain;
    private String issuer;
    private String issuerQualifier;
    private String assertionConsumerUrl;
    private String[] assertionConsumerUrls;
    private List<String> assertionConsumerUrlList;
    private String defaultAssertionConsumerUrl;
    private String certAlias;
    private String sloResponseURL;
    private String sloRequestURL;
    private boolean doSingleLogout;
    private String loginPageURL;
    private boolean doSignResponse;
    private boolean doSignAssertions;
    private String attributeConsumingServiceIndex;
    private String[] requestedClaims;
    private List<String> requestedClaimsList;
    private String[] requestedAudiences;
    private List<String> requestedAudiencesList;
    private String[] requestedRecipients;
    private List<String> requestedRecipientsList;
    private boolean enableAttributesByDefault;
    private String nameIdClaimUri;
    private String nameIDFormat;
    private boolean isIdPInitSSOEnabled;
    private boolean idPInitSLOEnabled;
    private String[] idpInitSLOReturnToURLs;
    private List<String> idpInitSLOReturnToURLList;
    private boolean doEnableEncryptedAssertion;
    private boolean doValidateSignatureInRequests;
    private boolean doValidateSignatureInArtifactResolve;
    private String signingAlgorithmUri = StringUtils.isNotBlank((String)IdentityUtil.getProperty("SSOService.SAMLDefaultSigningAlgorithmURI")) ? IdentityUtil.getProperty("SSOService.SAMLDefaultSigningAlgorithmURI").trim() : "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String digestAlgorithmUri = StringUtils.isNotBlank((String)IdentityUtil.getProperty("SSOService.SAMLDefaultDigestAlgorithmURI")) ? IdentityUtil.getProperty("SSOService.SAMLDefaultDigestAlgorithmURI").trim() : "http://www.w3.org/2000/09/xmldsig#sha1";
    private String assertionEncryptionAlgorithmUri = StringUtils.isNotBlank((String)IdentityUtil.getProperty("SSOService.SAMLDefaultAssertionEncryptionAlgorithmURI")) ? IdentityUtil.getProperty("SSOService.SAMLDefaultAssertionEncryptionAlgorithmURI").trim() : "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private String keyEncryptionAlgorithmUri = StringUtils.isNotBlank((String)IdentityUtil.getProperty("SSOService.SAMLDefaultKeyEncryptionAlgorithmURI")) ? IdentityUtil.getProperty("SSOService.SAMLDefaultKeyEncryptionAlgorithmURI").trim() : "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private String signingCertificate;
    private String encryptionCertificate;
    private X509Certificate x509Certificate;
    private boolean isAssertionQueryRequestProfileEnabled;
    private String supportedAssertionQueryRequestTypes;
    private boolean enableSAML2ArtifactBinding;
    private boolean samlECP;
    private String idpEntityIDAlias;
    private boolean doFrontChannelLogout;
    private String frontChannelLogoutBinding;

    public void setDoValidateSignatureInArtifactResolve(boolean doValidateSignatureInArtifactResolve) {
        this.doValidateSignatureInArtifactResolve = doValidateSignatureInArtifactResolve;
    }

    public boolean isDoValidateSignatureInArtifactResolve() {
        return this.doValidateSignatureInArtifactResolve;
    }

    public void setEnableSAML2ArtifactBinding(boolean enableSAML2ArtifactBinding) {
        this.enableSAML2ArtifactBinding = enableSAML2ArtifactBinding;
    }

    public boolean isEnableSAML2ArtifactBinding() {
        return this.enableSAML2ArtifactBinding;
    }

    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(String signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public String getNameIDFormat() {
        return this.nameIDFormat;
    }

    public void setNameIDFormat(String nameIDFormat) {
        this.nameIDFormat = nameIDFormat;
    }

    public String getEncryptionCertificatee() {
        return this.encryptionCertificate;
    }

    public void setEncryptionCertificate(String encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
    }

    public String getNameIdClaimUri() {
        return this.nameIdClaimUri;
    }

    public void setNameIdClaimUri(String nameIdClaimUri) {
        this.nameIdClaimUri = nameIdClaimUri;
    }

    public boolean isEnableAttributesByDefault() {
        return this.enableAttributesByDefault;
    }

    public void setEnableAttributesByDefault(boolean enableAttributesByDefault) {
        this.enableAttributesByDefault = enableAttributesByDefault;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        if (issuer != null) {
            this.issuer = issuer.replaceAll("[\n\r]", "").trim();
        }
    }

    public boolean isDoFrontChannelLogout() {
        return this.doFrontChannelLogout;
    }

    public void setDoFrontChannelLogout(boolean doFrontChannelLogout) {
        this.doFrontChannelLogout = doFrontChannelLogout;
    }

    public String getFrontChannelLogoutBinding() {
        return this.frontChannelLogoutBinding;
    }

    public void setFrontChannelLogoutBinding(String frontChannelLogoutBinding) {
        this.frontChannelLogoutBinding = frontChannelLogoutBinding;
    }

    public String getIssuerQualifier() {
        return this.issuerQualifier;
    }

    public void setIssuerQualifier(String issuerQualifier) {
        if (StringUtils.isNotBlank((String)issuerQualifier)) {
            this.issuerQualifier = issuerQualifier;
        }
    }

    public String getAssertionConsumerUrl() {
        return this.assertionConsumerUrl;
    }

    public void setAssertionConsumerUrl(String assertionConsumerUrl) {
        if (assertionConsumerUrl != null) {
            this.assertionConsumerUrl = assertionConsumerUrl.replaceAll("[\n\r]", "").trim();
        }
    }

    public boolean isAssertionQueryRequestProfileEnabled() {
        return this.isAssertionQueryRequestProfileEnabled;
    }

    public void setAssertionQueryRequestProfileEnabled(boolean isAssertionQueryRequestProfileEnabled) {
        this.isAssertionQueryRequestProfileEnabled = isAssertionQueryRequestProfileEnabled;
    }

    public String getSupportedAssertionQueryRequestTypes() {
        return this.supportedAssertionQueryRequestTypes;
    }

    public void setSupportedAssertionQueryRequestTypes(String supportedAssertionQueryRequestTypes) {
        this.supportedAssertionQueryRequestTypes = supportedAssertionQueryRequestTypes;
    }

    public String getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public String getSloResponseURL() {
        return this.sloResponseURL;
    }

    public void setSloResponseURL(String sloResponseURL) {
        if (sloResponseURL != null) {
            this.sloResponseURL = sloResponseURL.replaceAll("[\n\r]", "").trim();
        }
    }

    public boolean isDoSingleLogout() {
        return this.doSingleLogout;
    }

    public void setDoSingleLogout(boolean doSingleLogout) {
        this.doSingleLogout = doSingleLogout;
    }

    public String getLoginPageURL() {
        return this.loginPageURL;
    }

    public void setLoginPageURL(String loginPageURL) {
        this.loginPageURL = StringUtils.isNotBlank((String)loginPageURL) ? loginPageURL.replaceAll("[\n\r]", "").trim() : null;
    }

    public boolean isDoSignAssertions() {
        return this.doSignAssertions;
    }

    public void setDoSignAssertions(boolean doSignAssertions) {
        this.doSignAssertions = doSignAssertions;
    }

    public String getAttributeConsumingServiceIndex() {
        return this.attributeConsumingServiceIndex;
    }

    public void setAttributeConsumingServiceIndex(String attributeConsumingServiceIndex) {
        this.attributeConsumingServiceIndex = attributeConsumingServiceIndex;
    }

    public String getSigningAlgorithmUri() {
        return this.signingAlgorithmUri;
    }

    public void setSigningAlgorithmUri(String signingAlgorithmUri) {
        if (StringUtils.isNotEmpty((String)signingAlgorithmUri)) {
            this.signingAlgorithmUri = signingAlgorithmUri;
        }
    }

    public String getDigestAlgorithmUri() {
        return this.digestAlgorithmUri;
    }

    public void setDigestAlgorithmUri(String digestAlgorithmUri) {
        if (StringUtils.isNotEmpty((String)digestAlgorithmUri)) {
            this.digestAlgorithmUri = digestAlgorithmUri;
        }
    }

    public String getAssertionEncryptionAlgorithmUri() {
        return this.assertionEncryptionAlgorithmUri;
    }

    public void setAssertionEncryptionAlgorithmUri(String assertionEncryptionAlgorithmUri) {
        if (StringUtils.isNotBlank((String)assertionEncryptionAlgorithmUri)) {
            this.assertionEncryptionAlgorithmUri = assertionEncryptionAlgorithmUri;
        }
    }

    public String getKeyEncryptionAlgorithmUri() {
        return this.keyEncryptionAlgorithmUri;
    }

    public void setKeyEncryptionAlgorithmUri(String keyEncryptionAlgorithmUri) {
        if (StringUtils.isNotBlank((String)keyEncryptionAlgorithmUri)) {
            this.keyEncryptionAlgorithmUri = keyEncryptionAlgorithmUri;
        }
    }

    public String[] getRequestedClaims() {
        if (this.requestedClaims != null) {
            return (String[])this.requestedClaims.clone();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void setRequestedClaims(List<String> requestedClaims) {
        if (requestedClaims != null) {
            this.requestedClaimsList = requestedClaims;
            this.requestedClaims = requestedClaims.toArray(new String[requestedClaims.size()]);
        }
    }

    public void setRequestedClaims(String[] requestedClaims) {
        if (requestedClaims != null) {
            this.requestedClaims = (String[])requestedClaims.clone();
            this.requestedClaimsList = Arrays.asList(requestedClaims);
        }
    }

    public List<String> getRequestedClaimsList() {
        if (this.requestedClaimsList != null) {
            return this.requestedClaimsList;
        }
        return Collections.emptyList();
    }

    public String[] getRequestedAudiences() {
        if (this.requestedAudiences != null) {
            return (String[])this.requestedAudiences.clone();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void setRequestedAudiences(List<String> requestedAudiences) {
        if (requestedAudiences != null) {
            this.requestedAudiencesList = requestedAudiences;
            this.requestedAudiences = requestedAudiences.toArray(new String[this.requestedAudiencesList.size()]);
        }
    }

    public void setRequestedAudiences(String[] requestedAudiences) {
        if (requestedAudiences != null) {
            this.requestedAudiences = (String[])requestedAudiences.clone();
            this.requestedAudiencesList = Arrays.asList(requestedAudiences);
        }
    }

    public List<String> getRequestedAudiencesList() {
        if (this.requestedAudiencesList != null) {
            return this.requestedAudiencesList;
        }
        return Collections.emptyList();
    }

    public String[] getRequestedRecipients() {
        if (this.requestedRecipients != null) {
            return (String[])this.requestedRecipients.clone();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void setRequestedRecipients(List<String> requestedRecipientsList) {
        this.requestedRecipientsList = requestedRecipientsList;
        this.requestedRecipients = requestedRecipientsList != null ? requestedRecipientsList.toArray(new String[requestedRecipientsList.size()]) : null;
    }

    public void setRequestedRecipients(String[] requestedRecipients) {
        if (requestedRecipients != null) {
            this.requestedRecipients = (String[])requestedRecipients.clone();
            this.requestedRecipientsList = Arrays.asList(requestedRecipients);
        } else {
            this.requestedRecipients = null;
            this.requestedRecipientsList = null;
        }
    }

    public List<String> getRequestedRecipientsList() {
        if (this.requestedRecipientsList != null) {
            return this.requestedRecipientsList;
        }
        return Collections.emptyList();
    }

    public boolean isDoSignResponse() {
        return this.doSignResponse;
    }

    public void setDoSignResponse(boolean doSignResponse) {
        this.doSignResponse = doSignResponse;
    }

    public boolean isIdPInitSSOEnabled() {
        return this.isIdPInitSSOEnabled;
    }

    public void setIdPInitSSOEnabled(boolean idPInitSSOEnabled) {
        this.isIdPInitSSOEnabled = idPInitSSOEnabled;
    }

    public boolean isDoEnableEncryptedAssertion() {
        return this.doEnableEncryptedAssertion;
    }

    public void setDoEnableEncryptedAssertion(boolean doEnableEncryptedAssertion) {
        this.doEnableEncryptedAssertion = doEnableEncryptedAssertion;
    }

    public boolean isDoValidateSignatureInRequests() {
        return this.doValidateSignatureInRequests;
    }

    public void setDoValidateSignatureInRequests(boolean doValidateSignatureInRequests) {
        this.doValidateSignatureInRequests = doValidateSignatureInRequests;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public String[] getAssertionConsumerUrls() {
        if (this.assertionConsumerUrls != null) {
            return (String[])this.assertionConsumerUrls.clone();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public List<String> getAssertionConsumerUrlList() {
        if (this.assertionConsumerUrlList != null) {
            return this.assertionConsumerUrlList;
        }
        return Collections.emptyList();
    }

    public void setAssertionConsumerUrls(String[] assertionConsumerUrls) {
        if (assertionConsumerUrls != null) {
            this.assertionConsumerUrls = (String[])assertionConsumerUrls.clone();
            this.assertionConsumerUrlList = Arrays.asList(assertionConsumerUrls);
        } else {
            this.assertionConsumerUrls = null;
            this.assertionConsumerUrlList = null;
        }
    }

    public void setAssertionConsumerUrls(List<String> assertionConsumerUrlList) {
        this.assertionConsumerUrlList = assertionConsumerUrlList;
        this.assertionConsumerUrls = assertionConsumerUrlList != null ? assertionConsumerUrlList.toArray(new String[assertionConsumerUrlList.size()]) : null;
    }

    public String getDefaultAssertionConsumerUrl() {
        return this.defaultAssertionConsumerUrl;
    }

    public void setDefaultAssertionConsumerUrl(String defaultAssertionConsumerUrl) {
        this.defaultAssertionConsumerUrl = StringUtils.isNotBlank((String)defaultAssertionConsumerUrl) ? defaultAssertionConsumerUrl.replaceAll("[\n\r]", "").trim() : null;
    }

    public String getSloRequestURL() {
        return this.sloRequestURL;
    }

    public void setSloRequestURL(String sloRequestURL) {
        this.sloRequestURL = StringUtils.isNotBlank((String)sloRequestURL) ? sloRequestURL.replaceAll("[\n\r]", "").trim() : null;
    }

    public boolean isIdPInitSLOEnabled() {
        return this.idPInitSLOEnabled;
    }

    public void setIdPInitSLOEnabled(boolean idPInitSLOEnabled) {
        this.idPInitSLOEnabled = idPInitSLOEnabled;
    }

    public String[] getIdpInitSLOReturnToURLs() {
        if (this.idpInitSLOReturnToURLs != null) {
            return (String[])this.idpInitSLOReturnToURLs.clone();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void setIdpInitSLOReturnToURLs(String[] idpInitSLOReturnToURLs) {
        if (idpInitSLOReturnToURLs != null) {
            this.idpInitSLOReturnToURLs = (String[])idpInitSLOReturnToURLs.clone();
            this.idpInitSLOReturnToURLList = Arrays.asList(idpInitSLOReturnToURLs);
        } else {
            this.idpInitSLOReturnToURLs = null;
            this.idpInitSLOReturnToURLList = null;
        }
    }

    public List<String> getIdpInitSLOReturnToURLList() {
        if (this.idpInitSLOReturnToURLList != null) {
            return this.idpInitSLOReturnToURLList;
        }
        return Collections.emptyList();
    }

    public void setIdpInitSLOReturnToURLs(List<String> idpInitSLOReturnToURLList) {
        this.idpInitSLOReturnToURLList = idpInitSLOReturnToURLList;
        this.idpInitSLOReturnToURLs = idpInitSLOReturnToURLList != null ? idpInitSLOReturnToURLList.toArray(new String[idpInitSLOReturnToURLList.size()]) : null;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public void setSamlECP(boolean samlECP) {
        this.samlECP = samlECP;
    }

    public boolean isSamlECP() {
        return this.samlECP;
    }

    public String getIdpEntityIDAlias() {
        return this.idpEntityIDAlias;
    }

    public void setIdpEntityIDAlias(String idpEntityIDAlias) {
        this.idpEntityIDAlias = idpEntityIDAlias;
    }
}

