/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.model;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.ExpressionNode;
import org.wso2.carbon.identity.core.model.Node;
import org.wso2.carbon.identity.core.model.OperationNode;

public class FilterTreeBuilder {
    private List<String> tokenList;
    private String symbol;
    private Node root;

    public FilterTreeBuilder(String filterString) throws IOException {
        StreamTokenizer input = new StreamTokenizer(new StringReader(filterString));
        input.resetSyntax();
        input.wordChars(97, 122);
        input.wordChars(65, 90);
        input.wordChars(160, 255);
        input.whitespaceChars(0, 32);
        input.commentChar(47);
        input.quoteChar(34);
        input.quoteChar(39);
        input.wordChars(64, 64);
        input.wordChars(58, 58);
        input.wordChars(95, 95);
        input.wordChars(48, 57);
        input.wordChars(45, 45);
        input.wordChars(43, 43);
        input.wordChars(46, 46);
        input.wordChars(42, 42);
        input.wordChars(47, 47);
        this.tokenList = new ArrayList<String>();
        StringBuilder concatenatedString = new StringBuilder();
        while (input.nextToken() != -1) {
            if (input.ttype == 40) {
                this.tokenList.add("(");
                continue;
            }
            if (input.ttype == 41) {
                concatenatedString = new StringBuilder(concatenatedString.toString().trim());
                this.tokenList.add(concatenatedString.toString());
                concatenatedString = new StringBuilder();
                this.tokenList.add(")");
                continue;
            }
            if (input.ttype == -3) {
                if (!(input.sval.equalsIgnoreCase("and") || input.sval.equalsIgnoreCase("or") || input.sval.equalsIgnoreCase("not"))) {
                    concatenatedString.append(" ").append(input.sval);
                    continue;
                }
                if (!(concatenatedString = new StringBuilder(concatenatedString.toString().trim())).toString().equals("")) {
                    this.tokenList.add(concatenatedString.toString());
                    concatenatedString = new StringBuilder();
                }
                this.tokenList.add(input.sval);
                continue;
            }
            if (input.ttype != 34 && input.ttype != 39) continue;
            concatenatedString.append(" ").append(input.sval);
        }
        if (!concatenatedString.toString().equals("")) {
            this.tokenList.add(concatenatedString.toString());
        }
    }

    public Node buildTree() throws IdentityException {
        this.expression();
        return this.root;
    }

    private void expression() throws IdentityException {
        this.term();
        while (this.symbol.equals(String.valueOf("or"))) {
            OperationNode or = new OperationNode("or");
            or.setLeftNode(this.root);
            this.term();
            or.setRightNode(this.root);
            this.root = or;
        }
    }

    private void term() throws IdentityException {
        this.factor();
        while (this.symbol.equals(String.valueOf("and"))) {
            OperationNode and = new OperationNode("and");
            and.setLeftNode(this.root);
            this.factor();
            and.setRightNode(this.root);
            this.root = and;
        }
    }

    private void factor() throws IdentityException {
        this.symbol = this.nextSymbol();
        if (this.symbol.equals(String.valueOf("not"))) {
            OperationNode not = new OperationNode("not");
            this.factor();
            not.setRightNode(this.root);
            this.root = not;
        } else if (this.symbol.equals(String.valueOf("("))) {
            this.expression();
            this.symbol = this.nextSymbol();
        } else if (!this.symbol.equals(String.valueOf(")"))) {
            ExpressionNode expressionNode = new ExpressionNode();
            this.validateAndBuildFilterExpression(this.symbol, expressionNode);
            this.root = expressionNode;
            this.symbol = this.nextSymbol();
        } else {
            throw new IdentityException("Invalid argument: Identity Provider filter name value is empty or invalid symbol: " + this.symbol);
        }
    }

    private void validateAndBuildFilterExpression(String filterString, ExpressionNode expressionNode) throws IdentityException {
        if (StringUtils.isNotBlank((String)filterString) && !filterString.equals("-1")) {
            String trimmedFilter = filterString.trim();
            if (Pattern.compile(Pattern.quote(" eq "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" eq | EQ | eQ | Eq ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " eq ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" ne "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" ne | NE | nE | Ne ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " ne ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" co "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" co | CO | cO | Co ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " co ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" sw "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" sw | SW | sW | Sw ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " sw ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" ew "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" ew | EW | eW | Ew ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " ew ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" pr"), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" pr| PR| pR| Pr");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " pr", null, expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" gt "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" gt | GT | gT | Gt ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " gt ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" ge "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" ge | GE | gE | Ge ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " ge ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" lt "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" lt | LT | lT | Lt ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " lt ", filterParts[1], expressionNode);
                }
            } else if (Pattern.compile(Pattern.quote(" le "), 2).matcher(filterString).find()) {
                String[] filterParts = trimmedFilter.split(" le | LE | lE | Le ");
                if (filterParts.length >= 2) {
                    this.setExpressionNodeValues(filterParts[0], " le ", filterParts[1], expressionNode);
                }
            } else {
                throw new IdentityException("Given filter operator is not supported. Filter attribute: " + filterString);
            }
        }
    }

    private void setExpressionNodeValues(String attributeValue, String operation, String value, ExpressionNode expressionNode) throws IdentityException {
        if (StringUtils.isNotBlank((String)attributeValue) || StringUtils.isNotBlank((String)operation)) {
            expressionNode.setAttributeValue(attributeValue.trim());
            expressionNode.setOperation(operation.trim());
            if (value != null) {
                expressionNode.setValue(value.trim());
            }
        } else {
            throw new IdentityException("Given filter value is empty. attributeValue: " + attributeValue + "operation: " + operation);
        }
    }

    private String nextSymbol() {
        if (this.tokenList.size() == 0) {
            return String.valueOf(-1);
        }
        String value = this.tokenList.get(0);
        this.tokenList.remove(0);
        return value;
    }
}

