/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.model;

import javax.servlet.http.Cookie;
import org.wso2.carbon.core.SameSiteCookie;
import org.wso2.carbon.core.ServletCookie;

public class CookieBuilder {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path = "/";
    private boolean secure = true;
    private int version = 0;
    private boolean isHttpOnly = true;
    private SameSiteCookie sameSite = SameSiteCookie.STRICT;

    public CookieBuilder(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public CookieBuilder setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public CookieBuilder setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public CookieBuilder setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CookieBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public CookieBuilder setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public CookieBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    public CookieBuilder setHttpOnly(boolean isHttpOnly) {
        this.isHttpOnly = isHttpOnly;
        return this;
    }

    public CookieBuilder setSameSite(SameSiteCookie sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    public Cookie build() {
        return new IdentityCookie(this);
    }

    private static class IdentityCookie
    extends ServletCookie {
        private IdentityCookie(CookieBuilder builder) {
            super(builder.name, builder.value);
            this.setComment(builder.comment);
            if (builder.domain != null) {
                this.setDomain(builder.domain);
            }
            this.setHttpOnly(builder.isHttpOnly);
            this.setPath(builder.path);
            this.setMaxAge(builder.maxAge);
            this.setSecure(builder.secure);
            this.setVersion(builder.version);
            this.setSameSite(builder.sameSite);
        }
    }
}

