/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.core.KeyProviderService;
import org.wso2.carbon.identity.core.KeyStoreManagerExtension;
import org.wso2.carbon.identity.core.ServiceURLBuilderFactory;
import org.wso2.carbon.identity.core.internal.DefaultKeyProviderService;
import org.wso2.carbon.identity.core.internal.DefaultKeystoreManagerExtension;
import org.wso2.carbon.identity.core.migrate.MigrationClient;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.persistence.JDBCPersistenceManager;
import org.wso2.carbon.identity.core.persistence.UmPersistenceManager;
import org.wso2.carbon.identity.core.persistence.registry.RegistryResourceMgtService;
import org.wso2.carbon.identity.core.persistence.registry.RegistryResourceMgtServiceImpl;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEventImpl;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.core.component", immediate=true)
public class IdentityCoreServiceComponent {
    private static Log log = LogFactory.getLog(IdentityCoreServiceComponent.class);
    private static ServerConfigurationService serverConfigurationService = null;
    private static MigrationClient migrationClient = null;
    private static BundleContext bundleContext = null;
    private static ConfigurationContextService configurationContextService = null;
    private static ServiceURLBuilderFactory serviceURLBuilderFactory = new ServiceURLBuilderFactory();
    private ServiceRegistration<KeyProviderService> defaultKeystoreManagerServiceRef;
    private DefaultKeystoreManagerExtension defaultKeystoreManagerExtension = new DefaultKeystoreManagerExtension();
    private DefaultKeyProviderService defaultKeyProviderService = new DefaultKeyProviderService(this.defaultKeystoreManagerExtension);

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    @Reference(name="server.configuration.service", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Set the ServerConfiguration Service");
        }
        IdentityCoreServiceComponent.serverConfigurationService = serverConfigurationService;
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unset the ServerConfiguration Service");
        }
        IdentityCoreServiceComponent.serverConfigurationService = null;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    @Activate
    protected void activate(ComponentContext ctxt) throws MigrationClientException {
        IdentityTenantUtil.setBundleContext(ctxt.getBundleContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Core bundle is activated");
        }
        try {
            IdentityUtil.populateProperties();
            bundleContext = ctxt.getBundleContext();
            String skipSchemaCreation = IdentityUtil.getProperty("JDBCPersistenceManager.SkipDBSchemaCreation");
            JDBCPersistenceManager jdbcPersistenceManager = JDBCPersistenceManager.getInstance();
            if ("true".equals(skipSchemaCreation)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Identity Provider Database initialization attempt was skipped since 'JDBCPersistenceManager.SkipDBSchemaCreation' property has been set to 'true'");
                }
            } else if (System.getProperty("setup") == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Identity Database schema initialization check was skipped since 'setup' variable was not given during startup");
                }
            } else {
                jdbcPersistenceManager.initializeDatabase();
            }
            UmPersistenceManager.getInstance();
            String migrate = System.getProperty("migrate");
            String component = System.getProperty("component");
            if (Boolean.parseBoolean(migrate) && component != null && component.contains("identity")) {
                if (migrationClient == null) {
                    log.warn((Object)"Waiting for migration client.");
                    throw new MigrationClientException("Migration client not found");
                }
                log.info((Object)("Executing Migration client : " + migrationClient.getClass().getName()));
                migrationClient.execute();
            }
            try {
                KeyStoreManager.getInstance((int)-1234).getPrimaryKeyStore();
            }
            catch (Exception e) {
                log.error((Object)"Error while initializing primary key store.", (Throwable)e);
            }
            ServiceRegistration registryServiceSR = ctxt.getBundleContext().registerService(RegistryResourceMgtService.class.getName(), (Object)new RegistryResourceMgtServiceImpl(), null);
            if (registryServiceSR != null && log.isDebugEnabled()) {
                log.debug((Object)"Identity Registry Management Service registered successfully.");
            }
            ctxt.getBundleContext().registerService(IdentityCoreInitializedEvent.class.getName(), (Object)new IdentityCoreInitializedEventImpl(), null);
            this.defaultKeystoreManagerServiceRef = ctxt.getBundleContext().registerService(KeyProviderService.class, (Object)this.defaultKeyProviderService, null);
        }
        catch (MigrationClientException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while populating identity configuration properties", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        this.defaultKeystoreManagerServiceRef.unregister();
        IdentityTenantUtil.setBundleContext(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Core bundle is deactivated");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        IdentityTenantUtil.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        IdentityTenantUtil.setRegistryService(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        IdentityTenantUtil.setRealmService(realmService);
        this.defaultKeystoreManagerExtension.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        this.defaultKeystoreManagerExtension.setRealmService(null);
        IdentityTenantUtil.setRealmService(null);
    }

    @Reference(name="registry.loader.default", service=TenantRegistryLoader.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTenantRegistryLoader")
    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is set in the SAML SSO bundle");
        }
        IdentityTenantUtil.setTenantRegistryLoader(tenantRegistryLoader);
    }

    protected void unsetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is unset in the SAML SSO bundle");
        }
        IdentityTenantUtil.setTenantRegistryLoader(null);
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService service) {
        configurationContextService = service;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService service) {
        configurationContextService = null;
    }

    @Reference(name="is.migration.client", service=MigrationClient.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetMigrationClient")
    protected void setMigrationClient(MigrationClient client) {
        migrationClient = client;
    }

    protected void unsetMigrationClient(MigrationClient client) {
        migrationClient = null;
    }

    protected void setKeyStoreManagerExtension(KeyStoreManagerExtension keyStoreManagerExtension) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("KeyStoreManagerExtension is being set by an OSGI component. The extension class is: " + keyStoreManagerExtension));
        }
        this.defaultKeyProviderService.setKeyStoreManagerExtension(keyStoreManagerExtension);
    }

    protected void unsetKeyStoreManagerExtension(KeyStoreManagerExtension keyStoreManagerExtension) {
        this.defaultKeyProviderService.setKeyStoreManagerExtension(this.defaultKeystoreManagerExtension);
    }

    @Reference(name="url.builder.factory", service=ServiceURLBuilderFactory.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetServiceURLBuilderFactory")
    protected void setServiceURLBuilderFactory(ServiceURLBuilderFactory serviceURLBuilderFactory) {
        IdentityCoreServiceComponent.serviceURLBuilderFactory = serviceURLBuilderFactory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ServiceURLBuilderFactory service set to: " + IdentityCoreServiceComponent.serviceURLBuilderFactory.getClass().getName()));
        }
    }

    protected void unsetServiceURLBuilderFactory(ServiceURLBuilderFactory serviceURLBuilderFactory) {
        IdentityCoreServiceComponent.serviceURLBuilderFactory = new ServiceURLBuilderFactory();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ServiceURLBuilderFactory service reverted to: " + IdentityCoreServiceComponent.serviceURLBuilderFactory.getClass().getName()));
        }
    }

    public static ServiceURLBuilderFactory getServiceURLBuilderFactory() {
        return serviceURLBuilderFactory;
    }
}

