/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.internal;

import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.ServiceURL;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.internal.IdentityCoreServiceComponent;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;

public class DefaultServiceURLBuilder
implements ServiceURLBuilder {
    private String fragment;
    private String[] urlPaths;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> fragmentParams = new HashMap<String, String>();

    @Override
    public ServiceURLBuilder addPath(String ... paths) {
        this.urlPaths = paths;
        return this;
    }

    @Override
    public ServiceURL build() throws URLBuilderException {
        String protocol = this.fetchProtocol();
        String proxyHostName = this.fetchProxyHostName();
        String internalHostName = this.fetchInternalHostName();
        int proxyPort = this.fetchPort();
        int transportPort = this.fetchTransportPort();
        String tenantDomain = this.resolveTenantDomain();
        String proxyContextPath = ServerConfiguration.getInstance().getFirstProperty("ProxyContextPath");
        String resolvedFragment = this.buildFragment(this.fragment, this.fragmentParams);
        String urlPath = this.getResolvedUrlPath(tenantDomain);
        return new ServiceURLImpl(protocol, proxyHostName, internalHostName, proxyPort, transportPort, tenantDomain, proxyContextPath, urlPath, this.parameters, resolvedFragment);
    }

    private String getResolvedUrlPath(String tenantDomain) {
        String resolvedUrlContext = this.buildUrlPath(this.urlPaths);
        StringBuilder resolvedUrlStringBuilder = new StringBuilder();
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && this.isNotSuperTenant(tenantDomain)) {
            resolvedUrlStringBuilder.append("/t/").append(tenantDomain);
        }
        if (StringUtils.isNotBlank((String)resolvedUrlContext)) {
            if (resolvedUrlContext.trim().charAt(0) != '/') {
                resolvedUrlStringBuilder.append("/").append(resolvedUrlContext.trim());
            } else {
                resolvedUrlStringBuilder.append(resolvedUrlContext.trim());
            }
        }
        return resolvedUrlStringBuilder.toString();
    }

    private boolean isNotSuperTenant(String tenantDomain) {
        return !StringUtils.equals((String)tenantDomain, (String)"carbon.super");
    }

    @Override
    public ServiceURLBuilder addParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    @Override
    public ServiceURLBuilder setFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    @Override
    public ServiceURLBuilder addFragmentParameter(String key, String value) {
        this.fragmentParams.put(key, value);
        return this;
    }

    private String resolveTenantDomain() {
        String tenantDomain = IdentityTenantUtil.getTenantDomainFromContext();
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        }
        return tenantDomain;
    }

    private String buildFragment(String fragment, Map<String, String> fragmentParams) throws URLBuilderException {
        if (StringUtils.isNotBlank((String)fragment)) {
            return fragment;
        }
        return this.getResolvedParamString(fragmentParams);
    }

    private String getResolvedParamString(Map<String, String> parameters) throws URLBuilderException {
        StringJoiner joiner = new StringJoiner("&");
        if (MapUtils.isNotEmpty(parameters)) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                StringBuilder paramBuilder = new StringBuilder();
                try {
                    paramBuilder.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new URLBuilderException(String.format("Error while trying to build url. %s is not supported.", StandardCharsets.UTF_8.name()), e);
                }
                joiner.add(paramBuilder.toString());
            }
        }
        return joiner.toString();
    }

    private String buildUrlPath(String[] urlPaths) {
        StringBuilder urlPathBuilder = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])urlPaths)) {
            for (String path : urlPaths) {
                if (!StringUtils.isNotBlank((String)path)) continue;
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                urlPathBuilder.append(path).append("/");
            }
            if (urlPathBuilder.length() > 0 && urlPathBuilder.charAt(urlPathBuilder.length() - 1) == '/') {
                urlPathBuilder.setLength(urlPathBuilder.length() - 1);
            }
        }
        return urlPathBuilder.toString();
    }

    private String fetchProtocol() {
        return CarbonUtils.getManagementTransport();
    }

    private String fetchProxyHostName() throws URLBuilderException {
        String proxyHostName = ServerConfiguration.getInstance().getFirstProperty("HostName");
        return this.resolveHostName(proxyHostName);
    }

    private String fetchInternalHostName() throws URLBuilderException {
        String internalHostName = IdentityUtil.getProperty("ServerHostName");
        return this.resolveHostName(internalHostName);
    }

    private String resolveHostName(String hostName) throws URLBuilderException {
        try {
            if (StringUtils.isBlank((String)hostName)) {
                hostName = NetworkUtils.getLocalHostname();
            }
        }
        catch (SocketException e) {
            throw new URLBuilderException(String.format("Error while trying to resolve the hostname %s from the system", hostName), e);
        }
        if (StringUtils.isNotBlank((String)hostName) && hostName.endsWith("/")) {
            hostName = hostName.substring(0, hostName.length() - 1);
        }
        return hostName;
    }

    private int fetchPort() {
        String mgtTransport = CarbonUtils.getManagementTransport();
        AxisConfiguration axisConfiguration = IdentityCoreServiceComponent.getConfigurationContextService().getServerConfigContext().getAxisConfiguration();
        int port = CarbonUtils.getTransportProxyPort((AxisConfiguration)axisConfiguration, (String)mgtTransport);
        if (port <= 0) {
            port = CarbonUtils.getTransportPort((AxisConfiguration)axisConfiguration, (String)mgtTransport);
        }
        return port;
    }

    private int fetchTransportPort() {
        String mgtTransport = CarbonUtils.getManagementTransport();
        AxisConfiguration axisConfiguration = IdentityCoreServiceComponent.getConfigurationContextService().getServerConfigContext().getAxisConfiguration();
        return CarbonUtils.getTransportPort((AxisConfiguration)axisConfiguration, (String)mgtTransport);
    }

    private class ServiceURLImpl
    implements ServiceURL {
        private String protocol;
        private String proxyHostName;
        private String internalHostName;
        private int proxyPort;
        private int transportPort;
        private String tenantDomain;
        private String proxyContextPath;
        private String urlPath;
        private Map<String, String> parameters;
        private String fragment;
        private String absolutePublicUrl;
        private String absoluteInternalUrl;
        private String relativePublicUrl;
        private String relativeInternalUrl;

        private ServiceURLImpl(String protocol, String proxyHostName, String internalHostName, int proxyPort, int transportPort, String tenantDomain, String proxyContextPath, String urlPath, Map<String, String> parameters, String fragment) throws URLBuilderException {
            this.protocol = protocol;
            this.proxyHostName = proxyHostName;
            this.internalHostName = internalHostName;
            this.proxyPort = proxyPort;
            this.transportPort = transportPort;
            this.tenantDomain = tenantDomain;
            this.proxyContextPath = proxyContextPath;
            this.urlPath = urlPath;
            this.parameters = parameters;
            this.fragment = fragment;
            this.absolutePublicUrl = this.fetchAbsolutePublicUrl();
            this.absoluteInternalUrl = this.fetchAbsoluteInternalUrl();
            this.relativePublicUrl = this.fetchRelativePublicUrl();
            this.relativeInternalUrl = this.fetchRelativeInternalUrl();
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }

        @Override
        public String getProxyHostName() {
            return this.proxyHostName;
        }

        @Override
        public int getPort() {
            return this.proxyPort;
        }

        @Override
        public int getTransportPort() {
            return this.transportPort;
        }

        @Override
        public String getPath() {
            return this.urlPath;
        }

        @Override
        public String getParameter(String key) {
            return this.parameters.get(key);
        }

        @Override
        public Map<String, String> getParameters() {
            return Collections.unmodifiableMap(this.parameters);
        }

        @Override
        public String getFragment() {
            return this.fragment;
        }

        @Override
        public String getTenantDomain() {
            return this.tenantDomain;
        }

        @Override
        public String getAbsoluteInternalURL() {
            return this.absoluteInternalUrl;
        }

        @Override
        public String getAbsolutePublicURL() {
            return this.absolutePublicUrl;
        }

        @Override
        public String getRelativePublicURL() {
            return this.relativePublicUrl;
        }

        @Override
        public String getRelativeInternalURL() {
            return this.relativeInternalUrl;
        }

        private String fetchAbsolutePublicUrl() throws URLBuilderException {
            StringBuilder absolutePublicUrl = new StringBuilder();
            if (StringUtils.isBlank((String)this.protocol)) {
                throw new URLBuilderException("Protocol of service URL is not available.");
            }
            if (StringUtils.isBlank((String)this.proxyHostName)) {
                throw new URLBuilderException("Hostname of service URL is not available.");
            }
            absolutePublicUrl.append(this.protocol).append("://");
            absolutePublicUrl.append(this.proxyHostName.toLowerCase());
            if (this.proxyPort != 443) {
                absolutePublicUrl.append(":").append(this.proxyPort);
            }
            absolutePublicUrl.append(this.fetchRelativePublicUrl());
            return absolutePublicUrl.toString();
        }

        private String fetchAbsoluteInternalUrl() throws URLBuilderException {
            StringBuilder absoluteInternalUrl = new StringBuilder();
            if (StringUtils.isBlank((String)this.protocol)) {
                throw new URLBuilderException("Protocol of service URL is not available.");
            }
            if (StringUtils.isBlank((String)this.internalHostName)) {
                throw new URLBuilderException("Internal hostname of service URL is not available.");
            }
            absoluteInternalUrl.append(this.protocol).append("://");
            absoluteInternalUrl.append(this.internalHostName.toLowerCase());
            if (this.transportPort != 443) {
                absoluteInternalUrl.append(":").append(this.transportPort);
            }
            absoluteInternalUrl.append(this.fetchRelativeInternalUrl());
            return absoluteInternalUrl.toString();
        }

        private String fetchRelativePublicUrl() throws URLBuilderException {
            StringBuilder relativeUrl = new StringBuilder();
            this.appendContextToUri(relativeUrl, this.proxyContextPath);
            this.appendContextToUri(relativeUrl, this.urlPath);
            String resolvedParamsString = DefaultServiceURLBuilder.this.getResolvedParamString(this.parameters);
            this.appendParamsToUri(relativeUrl, resolvedParamsString, "?");
            this.appendParamsToUri(relativeUrl, this.fragment, "#");
            return relativeUrl.toString();
        }

        private String fetchRelativeInternalUrl() throws URLBuilderException {
            StringBuilder relativeUrl = new StringBuilder();
            this.appendContextToUri(relativeUrl, this.urlPath);
            String resolvedParamsString = DefaultServiceURLBuilder.this.getResolvedParamString(this.parameters);
            this.appendParamsToUri(relativeUrl, resolvedParamsString, "?");
            this.appendParamsToUri(relativeUrl, this.fragment, "#");
            return relativeUrl.toString();
        }

        private void appendParamsToUri(StringBuilder serverUrl, String resolvedParamsString, String delimiter) throws URLBuilderException {
            if (serverUrl.length() > 0 && serverUrl.charAt(serverUrl.length() - 1) == '/') {
                serverUrl.setLength(serverUrl.length() - 1);
            }
            if (StringUtils.isNotBlank((String)resolvedParamsString)) {
                serverUrl.append(delimiter).append(resolvedParamsString);
            }
        }

        private void appendContextToUri(StringBuilder serverUrl, String contextPath) {
            if (StringUtils.isNotBlank((String)contextPath)) {
                if (contextPath.endsWith("/")) {
                    contextPath = contextPath.substring(0, contextPath.length() - 1);
                }
                if (StringUtils.isNotBlank((String)contextPath) && contextPath.trim().charAt(0) != '/') {
                    serverUrl.append("/").append(contextPath.trim());
                } else {
                    serverUrl.append(contextPath.trim());
                }
            }
        }
    }
}

