/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.internal;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.KeyStoreManagerExtension;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class DefaultKeystoreManagerExtension
implements KeyStoreManagerExtension {
    private RealmService realmService;

    public void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    @Override
    public PrivateKey getPrivateKey(String tenantDomain) throws IdentityException {
        PrivateKey privateKey;
        try {
            int tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            if (!tenantDomain.equals("carbon.super")) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                privateKey = (PrivateKey)keyStoreManager.getPrivateKey(jksName, tenantDomain);
            } else {
                privateKey = keyStoreManager.getDefaultPrivateKey();
            }
        }
        catch (Exception e) {
            throw new IdentityException("Error retrieving private key for tenant: " + tenantDomain, (Throwable)e);
        }
        return privateKey;
    }

    @Override
    public Certificate getCertificate(String tenantDomain) throws IdentityException {
        try {
            int tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            return keyStoreManager.getDefaultPrimaryCertificate();
        }
        catch (UserStoreException e) {
            throw new IdentityException("Error retrieving the tenant ID for tenant: " + tenantDomain, (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityException("Error retrieving the primary certificate of the server, the tenant is: " + tenantDomain, (Throwable)e);
        }
    }
}

