/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.internal;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.KeyProviderService;
import org.wso2.carbon.identity.core.KeyStoreManagerExtension;
import org.wso2.carbon.utils.CarbonUtils;

public class DefaultKeyProviderService
implements KeyProviderService {
    private static final Log log = LogFactory.getLog(DefaultKeyProviderService.class);
    private KeyStoreManagerExtension keyStoreManagerExtension;

    public DefaultKeyProviderService(KeyStoreManagerExtension defaultKeyStoreManagerExtension) {
        if (defaultKeyStoreManagerExtension == null) {
            throw new NullPointerException("The " + DefaultKeyProviderService.class.getName() + " can not be constructed with null " + KeyStoreManagerExtension.class.getName());
        }
        this.keyStoreManagerExtension = defaultKeyStoreManagerExtension;
    }

    protected void setKeyStoreManagerExtension(KeyStoreManagerExtension keyStoreManagerExtension) {
        CarbonUtils.checkSecurity();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting the current KeyStoreManagerExtension with new KeyStoreManagerExtension : " + keyStoreManagerExtension));
        }
        if (keyStoreManagerExtension == null) {
            throw new NullPointerException("The " + DefaultKeyProviderService.class.getName() + " can not be set with null " + KeyStoreManagerExtension.class.getName());
        }
        this.keyStoreManagerExtension = keyStoreManagerExtension;
    }

    @Override
    public PrivateKey getPrivateKey(String tenantDomain) throws IdentityException {
        CarbonUtils.checkSecurity();
        return this.keyStoreManagerExtension.getPrivateKey(tenantDomain);
    }

    @Override
    public Certificate getCertificate(String tenantDomain) throws IdentityException {
        CarbonUtils.checkSecurity();
        return this.keyStoreManagerExtension.getCertificate(tenantDomain);
    }
}

