/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.AbstractIdentityMessageHandler;
import org.wso2.carbon.identity.core.handler.HandlerComparator;
import org.wso2.carbon.identity.core.handler.IdentityHandler;
import org.wso2.carbon.identity.core.handler.IdentityMessageHandler;
import org.wso2.carbon.identity.core.handler.MessageHandlerComparator;

public class HandlerManager {
    private static Log log = LogFactory.getLog(AbstractIdentityMessageHandler.class);
    private static HandlerManager handlerManager = new HandlerManager();

    private HandlerManager() {
    }

    public static HandlerManager getInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created singleton instance for " + HandlerManager.class.getName()));
        }
        return handlerManager;
    }

    public <T extends IdentityHandler> T getFirstPriorityHandler(List<T> identityHandlers, boolean isEnableHandlersOnly) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Get first priority handler for the given handler list.");
        }
        if (identityHandlers == null || identityHandlers.isEmpty()) {
            return null;
        }
        IdentityHandler identityHandler = null;
        Collections.sort(identityHandlers, new HandlerComparator());
        for (IdentityHandler identityHandlerTmp : identityHandlers) {
            if (isEnableHandlersOnly) {
                if (!identityHandlerTmp.isEnabled()) continue;
                identityHandler = identityHandlerTmp;
                break;
            }
            identityHandler = identityHandlerTmp;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get first priority handler : " + identityHandler.getName() + "(" + identityHandler.getClass().getName() + ")"));
        }
        return (T)identityHandler;
    }

    public <T extends IdentityHandler> List<T> sortHandlers(List<T> identityHandlers, boolean isEnableHandlersOnly) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sort the handler list.");
        }
        if (identityHandlers == null || identityHandlers.isEmpty()) {
            return new ArrayList();
        }
        List<T> identityHandlersList = identityHandlers;
        Collections.sort(identityHandlersList, new HandlerComparator());
        if (isEnableHandlersOnly) {
            identityHandlersList = new ArrayList<T>();
            for (IdentityHandler identityHandler : identityHandlers) {
                if (!identityHandler.isEnabled()) continue;
                identityHandlersList.add(identityHandler);
            }
        }
        return identityHandlersList;
    }

    public <T1 extends IdentityMessageHandler, T2 extends MessageContext> T1 getFirstPriorityHandler(List<T1> identityMessageHandlers, boolean isEnableHandlersOnly, T2 messageContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Get first priority handler for the given handler list and the context");
        }
        if (identityMessageHandlers == null || identityMessageHandlers.isEmpty()) {
            return null;
        }
        IdentityMessageHandler identityMessageHandler = null;
        Collections.sort(identityMessageHandlers, new MessageHandlerComparator(messageContext));
        for (IdentityMessageHandler identityHandlerTmp : identityMessageHandlers) {
            if (isEnableHandlersOnly) {
                if (!identityHandlerTmp.isEnabled(messageContext) || !identityHandlerTmp.canHandle(messageContext)) continue;
                identityMessageHandler = identityHandlerTmp;
                break;
            }
            if (!identityHandlerTmp.canHandle(messageContext)) continue;
            identityMessageHandler = identityHandlerTmp;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get first priority handler : " + identityMessageHandler.getName() + "(" + identityMessageHandler.getClass().getName() + ")"));
        }
        return (T1)identityMessageHandler;
    }

    public <T1 extends IdentityMessageHandler, T2 extends MessageContext> List<T1> sortHandlers(List<T1> identityMessageHandlers, boolean isEnableHandlersOnly, T2 messageContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sort the handler list with the context.");
        }
        if (identityMessageHandlers == null || identityMessageHandlers.isEmpty()) {
            return new ArrayList();
        }
        List<T1> identityMessageHandlerList = identityMessageHandlers;
        Collections.sort(identityMessageHandlerList, new MessageHandlerComparator(messageContext));
        if (isEnableHandlersOnly) {
            identityMessageHandlerList = new ArrayList<T1>();
            for (IdentityMessageHandler identityMessageHandler : identityMessageHandlers) {
                if (!identityMessageHandler.isEnabled(messageContext)) continue;
                identityMessageHandlerList.add(identityMessageHandler);
            }
        }
        return identityMessageHandlerList;
    }
}

