/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.handler;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.IdentityMessageHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public abstract class AbstractIdentityMessageHandler
implements IdentityMessageHandler {
    private static Log log = LogFactory.getLog(AbstractIdentityMessageHandler.class);
    protected final Properties properties = new Properties();
    protected InitConfig initConfig;

    @Override
    public void init(InitConfig initConfig) {
        this.initConfig = initConfig;
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty(AbstractIdentityMessageHandler.class.getName(), this.getClass().getName());
        if (identityEventListenerConfig == null) {
            return;
        }
        if (identityEventListenerConfig.getProperties() != null) {
            for (Map.Entry<Object, Object> property : identityEventListenerConfig.getProperties().entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                if (!this.properties.containsKey(key)) {
                    this.properties.setProperty(key, value);
                    continue;
                }
                log.warn((Object)("Property key " + key + " already exists. Cannot add property!!"));
            }
        }
    }

    @Override
    public boolean isEnabled(MessageContext messageContext) {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty(AbstractIdentityMessageHandler.class.getName(), this.getClass().getName());
        if (identityEventListenerConfig == null) {
            return true;
        }
        return Boolean.parseBoolean(identityEventListenerConfig.getEnable());
    }

    @Override
    public int getPriority(MessageContext messageContext) {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty(AbstractIdentityMessageHandler.class.getName(), this.getClass().getName());
        if (identityEventListenerConfig == null) {
            return -1;
        }
        return identityEventListenerConfig.getOrder();
    }

    @Override
    public boolean canHandle(MessageContext messageContext) {
        return false;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

