/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.handler;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.handler.IdentityHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public abstract class AbstractIdentityHandler
implements IdentityHandler {
    private static Log log = LogFactory.getLog(AbstractIdentityHandler.class);
    protected final Properties properties = new Properties();
    protected InitConfig initConfig;

    @Override
    public void init(InitConfig initConfig) {
        this.initConfig = initConfig;
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty(AbstractIdentityHandler.class.getName(), this.getClass().getName());
        if (identityEventListenerConfig == null) {
            return;
        }
        if (identityEventListenerConfig.getProperties() != null) {
            for (Map.Entry<Object, Object> property : identityEventListenerConfig.getProperties().entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                if (!this.properties.containsKey(key)) {
                    this.properties.setProperty(key, value);
                    continue;
                }
                log.warn((Object)("Property key " + key + " already exists. Cannot add property!!"));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty(AbstractIdentityHandler.class.getName(), this.getClass().getName());
        if (identityEventListenerConfig == null) {
            return true;
        }
        return Boolean.parseBoolean(identityEventListenerConfig.getEnable());
    }

    @Override
    public int getPriority() {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty(AbstractIdentityHandler.class.getName(), this.getClass().getName());
        if (identityEventListenerConfig == null) {
            return -1;
        }
        return identityEventListenerConfig.getOrder();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

