/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.dao.AbstractDAO;
import org.wso2.carbon.identity.core.model.XMPPSettingsDO;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;

public class XMPPSettingsDAO
extends AbstractDAO<XMPPSettingsDO> {
    protected static final Log log = LogFactory.getLog(XMPPSettingsDAO.class);

    public XMPPSettingsDAO(Registry registry) {
        this.registry = registry;
    }

    @Override
    protected XMPPSettingsDO resourceToObject(Resource resource) {
        XMPPSettingsDO xmppSettingsDO = null;
        if (resource != null) {
            xmppSettingsDO = new XMPPSettingsDO();
            xmppSettingsDO.setXmppServer(resource.getProperty("XmppServer"));
            xmppSettingsDO.setXmppUserName(resource.getProperty("XmppUserName"));
            xmppSettingsDO.setUserCode(resource.getProperty("XmppUserCode"));
            if (resource.getProperty("Enabled").trim().equals("true")) {
                xmppSettingsDO.setXmppEnabled(true);
            } else {
                xmppSettingsDO.setXmppEnabled(false);
            }
            if (resource.getProperty("PINEnabled").trim().equals("true")) {
                xmppSettingsDO.setPINEnabled(true);
            } else {
                xmppSettingsDO.setPINEnabled(false);
            }
        }
        return xmppSettingsDO;
    }

    public void addXmppSettings(String userId, String xmppServer, String xmppUserName, String xmppUserCode, boolean enabled, boolean pinEnabled) throws IdentityException {
        String path = null;
        Resource resource = null;
        Collection userResource = null;
        String xmppEnabled = "false";
        String isPINEnabled = "false";
        if (enabled) {
            xmppEnabled = "true";
        }
        if (pinEnabled) {
            isPINEnabled = "true";
        }
        try {
            if (userId != null) {
                path = "/repository/identity/XmppSettings/" + userId;
            }
            if (this.registry.resourceExists(path)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("XMPP Settings already exists for user " + userId));
                }
                return;
            }
            resource = this.registry.newResource();
            resource.addProperty("XmppServer", xmppServer);
            resource.addProperty("XmppUserName", xmppUserName);
            resource.addProperty("XmppUserCode", xmppUserCode);
            resource.addProperty("Enabled", xmppEnabled);
            resource.addProperty("PINEnabled", isPINEnabled);
            boolean transactionStarted = Transaction.isStarted();
            try {
                if (!transactionStarted) {
                    this.registry.beginTransaction();
                }
                this.registry.put(path, resource);
                if (!this.registry.resourceExists("/users/" + userId)) {
                    userResource = this.registry.newCollection();
                    this.registry.put("/users/" + userId, (Resource)userResource);
                }
                this.registry.addAssociation("/users/" + userId, path, "identity.user.xmppSettings");
                if (!transactionStarted) {
                    this.registry.commitTransaction();
                }
            }
            catch (Exception e) {
                if (!transactionStarted) {
                    this.registry.rollbackTransaction();
                }
                if (e instanceof RegistryException) {
                    throw (RegistryException)((Object)e);
                }
                throw IdentityException.error((String)"Error occured while adding XMPP Settings", (Throwable)e);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("XMPP Settings for " + userId + " added successfully."));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occured while adding XMPP Settings.", (Throwable)e);
            throw IdentityException.error((String)"Error occured while adding XMPP Settings.", (Throwable)e);
        }
    }

    public void updateXmppSettings(String userId, String xmppServer, String xmppUserName, String xmppUserCode, boolean enabled, boolean pinEnabled) throws IdentityException {
        String path = null;
        Resource resource = null;
        String xmppEnabled = "false";
        String isPINEnabled = "false";
        if (enabled) {
            xmppEnabled = "true";
        }
        if (pinEnabled) {
            isPINEnabled = "true";
        }
        try {
            if (userId != null) {
                path = "/repository/identity/XmppSettings/" + userId;
            }
            if (!this.registry.resourceExists(path)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("XMPP Settings does not exist for the user " + userId));
                }
                return;
            }
            resource = this.registry.get(path);
            resource.setProperty("XmppServer", xmppServer);
            resource.setProperty("XmppUserName", xmppUserName);
            resource.setProperty("XmppUserCode", xmppUserCode);
            resource.setProperty("Enabled", xmppEnabled);
            resource.setProperty("PINEnabled", isPINEnabled);
            this.registry.put(path, resource);
            if (log.isInfoEnabled()) {
                log.info((Object)("XMPP Settings are updated for the user " + userId));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occured while updating the XMPP Settings.", (Throwable)e);
            throw IdentityException.error((String)"Error occured while updating the XMPP Settings.", (Throwable)e);
        }
    }

    public XMPPSettingsDO getXmppSettings(String userId) {
        XMPPSettingsDO xmppSettings = null;
        try {
            if (this.registry.resourceExists("/repository/identity/XmppSettings/" + userId)) {
                xmppSettings = this.resourceToObject(this.registry.get("/repository/identity/XmppSettings/" + userId));
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Cannot retrieve the XMPP Settings for the user " + userId), (Throwable)e);
        }
        return xmppSettings;
    }

    public boolean isXmppSettingsEnabled(String userId) {
        boolean isEnabled = false;
        try {
            if (this.registry.resourceExists("/repository/identity/XmppSettings/" + userId)) {
                XMPPSettingsDO xmppSettings = this.resourceToObject(this.registry.get("/repository/identity/XmppSettings/" + userId));
                isEnabled = xmppSettings.isXmppEnabled();
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error when checking the availability of the user " + userId), (Throwable)e);
        }
        return isEnabled;
    }

    public boolean hasXmppSettings(String userId) {
        boolean hasSettings = false;
        try {
            hasSettings = this.registry.resourceExists("/repository/identity/XmppSettings/" + userId);
        }
        catch (RegistryException e) {
            log.error((Object)("Error when checking the availability of the user " + userId), (Throwable)e);
        }
        return hasSettings;
    }
}

