/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.CertificateRetriever;
import org.wso2.carbon.identity.core.CertificateRetrievingException;
import org.wso2.carbon.identity.core.DatabaseCertificateRetriever;
import org.wso2.carbon.identity.core.KeyStoreCertificateRetriever;
import org.wso2.carbon.identity.core.dao.AbstractDAO;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;

public class SAMLSSOServiceProviderDAO
extends AbstractDAO<SAMLSSOServiceProviderDO> {
    private static final String CERTIFICATE_PROPERTY_NAME = "CERTIFICATE";
    private static final String QUERY_TO_GET_APPLICATION_CERTIFICATE_ID = "SELECT META.VALUE FROM SP_INBOUND_AUTH INBOUND,SP_APP SP,SP_METADATA META WHERE SP.ID = INBOUND.APP_ID AND SP.ID = META.SP_ID AND META.NAME = ? AND INBOUND.INBOUND_AUTH_KEY = ? AND META.TENANT_ID = ?";
    private static Log log = LogFactory.getLog(SAMLSSOServiceProviderDAO.class);

    public SAMLSSOServiceProviderDAO(Registry registry) {
        this.registry = registry;
    }

    @Override
    protected SAMLSSOServiceProviderDO resourceToObject(Resource resource) {
        SAMLSSOServiceProviderDO serviceProviderDO = new SAMLSSOServiceProviderDO();
        serviceProviderDO.setIssuer(resource.getProperty("Issuer"));
        serviceProviderDO.setAssertionConsumerUrls(resource.getPropertyValues("SAMLSSOAssertionConsumerURLs"));
        serviceProviderDO.setDefaultAssertionConsumerUrl(resource.getProperty("DefaultSAMLSSOAssertionConsumerURL"));
        serviceProviderDO.setCertAlias(resource.getProperty("IssuerCertAlias"));
        if (StringUtils.isNotEmpty((String)resource.getProperty("signingAlgorithm"))) {
            serviceProviderDO.setSigningAlgorithmUri(resource.getProperty("signingAlgorithm"));
        }
        if (resource.getProperty("AssertionQueryRequestProfileEnabled") != null) {
            serviceProviderDO.setAssertionQueryRequestProfileEnabled(Boolean.valueOf(resource.getProperty("AssertionQueryRequestProfileEnabled").trim()));
        }
        if (resource.getProperty("SupportedAssertionQueryRequestTypes") != null) {
            serviceProviderDO.setSupportedAssertionQueryRequestTypes(resource.getProperty("SupportedAssertionQueryRequestTypes").trim());
        }
        if (resource.getProperty("EnableSAML2ArtifactBinding") != null) {
            serviceProviderDO.setEnableSAML2ArtifactBinding(Boolean.valueOf(resource.getProperty("EnableSAML2ArtifactBinding").trim()));
        }
        if (StringUtils.isNotEmpty((String)resource.getProperty("digestAlgorithm"))) {
            serviceProviderDO.setDigestAlgorithmUri(resource.getProperty("digestAlgorithm"));
        }
        if (StringUtils.isNotEmpty((String)resource.getProperty("assertionEncryptionAlgorithm"))) {
            serviceProviderDO.setAssertionEncryptionAlgorithmUri(resource.getProperty("assertionEncryptionAlgorithm"));
        }
        if (StringUtils.isNotEmpty((String)resource.getProperty("keyEncryptionAlgorithm"))) {
            serviceProviderDO.setKeyEncryptionAlgorithmUri(resource.getProperty("keyEncryptionAlgorithm"));
        }
        if (resource.getProperty("doSingleLogout") != null) {
            serviceProviderDO.setDoSingleLogout(Boolean.valueOf(resource.getProperty("doSingleLogout").trim()));
        }
        if (resource.getProperty("NameIDFormat") != null) {
            serviceProviderDO.setNameIDFormat(resource.getProperty("NameIDFormat"));
        }
        if (resource.getProperty("EnableNameIDClaimUri") != null && Boolean.valueOf(resource.getProperty("EnableNameIDClaimUri").trim()).booleanValue()) {
            serviceProviderDO.setNameIdClaimUri(resource.getProperty("NameIDClaimUri"));
        }
        serviceProviderDO.setLoginPageURL(resource.getProperty("loginPageURL"));
        if (resource.getProperty("doSignResponse") != null) {
            serviceProviderDO.setDoSignResponse(Boolean.valueOf(resource.getProperty("doSignResponse").trim()));
        }
        if (serviceProviderDO.isDoSingleLogout()) {
            serviceProviderDO.setSloResponseURL(resource.getProperty("sloResponseURL"));
            serviceProviderDO.setSloRequestURL(resource.getProperty("sloRequestURL"));
            if (resource.getProperty("doFrontChannelLogout") != null) {
                serviceProviderDO.setDoFrontChannelLogout(Boolean.valueOf(resource.getProperty("doFrontChannelLogout").trim()));
                if (serviceProviderDO.isDoFrontChannelLogout()) {
                    if (resource.getProperty("frontChannelLogoutBinding") != null) {
                        serviceProviderDO.setFrontChannelLogoutBinding(resource.getProperty("frontChannelLogoutBinding"));
                    } else {
                        serviceProviderDO.setFrontChannelLogoutBinding("HTTPRedirectBinding");
                    }
                }
            }
        }
        if (resource.getProperty("doSignAssertions") != null) {
            serviceProviderDO.setDoSignAssertions(Boolean.valueOf(resource.getProperty("doSignAssertions").trim()));
        }
        if (resource.getProperty("EnableSAMLECP") != null) {
            serviceProviderDO.setSamlECP(Boolean.valueOf(resource.getProperty("EnableSAMLECP").trim()));
        }
        if (resource.getProperty("AttributeConsumingServiceIndex") != null) {
            serviceProviderDO.setAttributeConsumingServiceIndex(resource.getProperty("AttributeConsumingServiceIndex"));
        } else {
            serviceProviderDO.setAttributeConsumingServiceIndex("");
        }
        if (resource.getProperty("RequestedClaims") != null) {
            serviceProviderDO.setRequestedClaims(resource.getPropertyValues("RequestedClaims"));
        }
        if (resource.getProperty("RequestedAudiences") != null) {
            serviceProviderDO.setRequestedAudiences(resource.getPropertyValues("RequestedAudiences"));
        }
        if (resource.getProperty("RequestedRecipients") != null) {
            serviceProviderDO.setRequestedRecipients(resource.getPropertyValues("RequestedRecipients"));
        }
        if (resource.getProperty("EnableAttributesByDefault") != null) {
            String enableAttrByDefault = resource.getProperty("EnableAttributesByDefault");
            serviceProviderDO.setEnableAttributesByDefault(Boolean.valueOf(enableAttrByDefault));
        }
        if (resource.getProperty("IdPInitSSOEnabled") != null) {
            serviceProviderDO.setIdPInitSSOEnabled(Boolean.valueOf(resource.getProperty("IdPInitSSOEnabled").trim()));
        }
        if (resource.getProperty("IdPInitSLOEnabled") != null) {
            serviceProviderDO.setIdPInitSLOEnabled(Boolean.valueOf(resource.getProperty("IdPInitSLOEnabled").trim()));
            if (serviceProviderDO.isIdPInitSLOEnabled() && resource.getProperty("IdPInitiatedSLOReturnToURLs") != null) {
                serviceProviderDO.setIdpInitSLOReturnToURLs(resource.getPropertyValues("IdPInitiatedSLOReturnToURLs"));
            }
        }
        if (resource.getProperty("doEnableEncryptedAssertion") != null) {
            serviceProviderDO.setDoEnableEncryptedAssertion(Boolean.valueOf(resource.getProperty("doEnableEncryptedAssertion").trim()));
        }
        if (resource.getProperty("doValidateSignatureInRequests") != null) {
            serviceProviderDO.setDoValidateSignatureInRequests(Boolean.valueOf(resource.getProperty("doValidateSignatureInRequests").trim()));
        }
        if (resource.getProperty("doValidateSignatureInArtifactResolve") != null) {
            serviceProviderDO.setDoValidateSignatureInArtifactResolve(Boolean.valueOf(resource.getProperty("doValidateSignatureInArtifactResolve").trim()));
        }
        if (resource.getProperty("SpQualifier") != null) {
            serviceProviderDO.setIssuerQualifier(resource.getProperty("SpQualifier"));
        }
        if (resource.getProperty("IdPEntityIDAlias") != null) {
            serviceProviderDO.setIdpEntityIDAlias(resource.getProperty("IdPEntityIDAlias"));
        }
        return serviceProviderDO;
    }

    public boolean addServiceProvider(SAMLSSOServiceProviderDO serviceProviderDO) throws IdentityException {
        if (serviceProviderDO == null || serviceProviderDO.getIssuer() == null || StringUtils.isBlank((String)serviceProviderDO.getIssuer())) {
            throw new IdentityException("Issuer cannot be found in the provided arguments.");
        }
        if (StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier())) {
            serviceProviderDO.setIssuer(this.getIssuerWithQualifier(serviceProviderDO.getIssuer(), serviceProviderDO.getIssuerQualifier()));
        }
        String path = "/repository/identity/SAMLSSO/" + this.encodePath(serviceProviderDO.getIssuer());
        boolean isTransactionStarted = Transaction.isStarted();
        boolean isErrorOccurred = false;
        try {
            if (this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    if (StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier())) {
                        log.debug((Object)("SAML2 Service Provider already exists with the same issuer name " + this.getIssuerWithoutQualifier(serviceProviderDO.getIssuer()) + " and qualifier name " + serviceProviderDO.getIssuerQualifier()));
                    } else {
                        log.debug((Object)("SAML2 Service Provider already exists with the same issuer name " + serviceProviderDO.getIssuer()));
                    }
                }
                boolean bl = false;
                return bl;
            }
            Resource resource = this.createResource(serviceProviderDO);
            if (!isTransactionStarted) {
                this.registry.beginTransaction();
            }
            this.registry.put(path, resource);
            if (log.isDebugEnabled()) {
                if (StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier())) {
                    log.debug((Object)("SAML2 Service Provider " + serviceProviderDO.getIssuer() + " with issuer " + this.getIssuerWithoutQualifier(serviceProviderDO.getIssuer()) + " and qualifier " + serviceProviderDO.getIssuerQualifier() + " is added successfully."));
                } else {
                    log.debug((Object)("SAML2 Service Provider " + serviceProviderDO.getIssuer() + " is added successfully."));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (RegistryException e) {
            isErrorOccurred = true;
            String msg = StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier()) ? "Error while adding SAML2 Service Provider for issuer: " + this.getIssuerWithoutQualifier(serviceProviderDO.getIssuer()) + " and qualifier name " + serviceProviderDO.getIssuerQualifier() : "Error while adding SAML2 Service Provider for issuer: " + serviceProviderDO.getIssuer();
            log.error((Object)msg, (Throwable)e);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
        finally {
            this.commitOrRollbackTransaction(isErrorOccurred);
        }
    }

    private Resource createResource(SAMLSSOServiceProviderDO serviceProviderDO) throws RegistryException {
        Resource resource = this.registry.newResource();
        resource.addProperty("Issuer", serviceProviderDO.getIssuer());
        resource.setProperty("SAMLSSOAssertionConsumerURLs", serviceProviderDO.getAssertionConsumerUrlList());
        resource.addProperty("DefaultSAMLSSOAssertionConsumerURL", serviceProviderDO.getDefaultAssertionConsumerUrl());
        resource.addProperty("IssuerCertAlias", serviceProviderDO.getCertAlias());
        resource.addProperty("loginPageURL", serviceProviderDO.getLoginPageURL());
        resource.addProperty("NameIDFormat", serviceProviderDO.getNameIDFormat());
        resource.addProperty("signingAlgorithm", serviceProviderDO.getSigningAlgorithmUri());
        resource.addProperty("digestAlgorithm", serviceProviderDO.getDigestAlgorithmUri());
        resource.addProperty("assertionEncryptionAlgorithm", serviceProviderDO.getAssertionEncryptionAlgorithmUri());
        resource.addProperty("keyEncryptionAlgorithm", serviceProviderDO.getKeyEncryptionAlgorithmUri());
        if (serviceProviderDO.getNameIdClaimUri() != null && serviceProviderDO.getNameIdClaimUri().trim().length() > 0) {
            resource.addProperty("EnableNameIDClaimUri", "true");
            resource.addProperty("NameIDClaimUri", serviceProviderDO.getNameIdClaimUri());
        } else {
            resource.addProperty("EnableNameIDClaimUri", "false");
        }
        String doSingleLogout = String.valueOf(serviceProviderDO.isDoSingleLogout());
        resource.addProperty("doSingleLogout", doSingleLogout);
        if (serviceProviderDO.isDoSingleLogout()) {
            if (StringUtils.isNotBlank((String)serviceProviderDO.getSloResponseURL())) {
                resource.addProperty("sloResponseURL", serviceProviderDO.getSloResponseURL());
            }
            if (StringUtils.isNotBlank((String)serviceProviderDO.getSloRequestURL())) {
                resource.addProperty("sloRequestURL", serviceProviderDO.getSloRequestURL());
            }
            String doFrontChannelLogout = String.valueOf(serviceProviderDO.isDoFrontChannelLogout());
            resource.addProperty("doFrontChannelLogout", doFrontChannelLogout);
            if (serviceProviderDO.isDoFrontChannelLogout()) {
                resource.addProperty("frontChannelLogoutBinding", serviceProviderDO.getFrontChannelLogoutBinding());
            }
        }
        String doSignResponse = String.valueOf(serviceProviderDO.isDoSignResponse());
        resource.addProperty("doSignResponse", doSignResponse);
        String isAssertionQueryRequestProfileEnabled = String.valueOf(serviceProviderDO.isAssertionQueryRequestProfileEnabled());
        resource.addProperty("AssertionQueryRequestProfileEnabled", isAssertionQueryRequestProfileEnabled);
        String supportedAssertionQueryRequestTypes = serviceProviderDO.getSupportedAssertionQueryRequestTypes();
        resource.addProperty("SupportedAssertionQueryRequestTypes", supportedAssertionQueryRequestTypes);
        String isEnableSAML2ArtifactBinding = String.valueOf(serviceProviderDO.isEnableSAML2ArtifactBinding());
        resource.addProperty("EnableSAML2ArtifactBinding", isEnableSAML2ArtifactBinding);
        String doSignAssertions = String.valueOf(serviceProviderDO.isDoSignAssertions());
        resource.addProperty("doSignAssertions", doSignAssertions);
        String isSamlECP = String.valueOf(serviceProviderDO.isSamlECP());
        resource.addProperty("EnableSAMLECP", isSamlECP);
        if (CollectionUtils.isNotEmpty(serviceProviderDO.getRequestedClaimsList())) {
            resource.setProperty("RequestedClaims", serviceProviderDO.getRequestedClaimsList());
        }
        if (serviceProviderDO.getAttributeConsumingServiceIndex() != null) {
            resource.addProperty("AttributeConsumingServiceIndex", serviceProviderDO.getAttributeConsumingServiceIndex());
        }
        if (CollectionUtils.isNotEmpty(serviceProviderDO.getRequestedAudiencesList())) {
            resource.setProperty("RequestedAudiences", serviceProviderDO.getRequestedAudiencesList());
        }
        if (CollectionUtils.isNotEmpty(serviceProviderDO.getRequestedRecipientsList())) {
            resource.setProperty("RequestedRecipients", serviceProviderDO.getRequestedRecipientsList());
        }
        String enableAttributesByDefault = String.valueOf(serviceProviderDO.isEnableAttributesByDefault());
        resource.addProperty("EnableAttributesByDefault", enableAttributesByDefault);
        String idPInitSSOEnabled = String.valueOf(serviceProviderDO.isIdPInitSSOEnabled());
        resource.addProperty("IdPInitSSOEnabled", idPInitSSOEnabled);
        String idPInitSLOEnabled = String.valueOf(serviceProviderDO.isIdPInitSLOEnabled());
        resource.addProperty("IdPInitSLOEnabled", idPInitSLOEnabled);
        if (serviceProviderDO.isIdPInitSLOEnabled() && serviceProviderDO.getIdpInitSLOReturnToURLList().size() > 0) {
            resource.setProperty("IdPInitiatedSLOReturnToURLs", serviceProviderDO.getIdpInitSLOReturnToURLList());
        }
        String enableEncryptedAssertion = String.valueOf(serviceProviderDO.isDoEnableEncryptedAssertion());
        resource.addProperty("doEnableEncryptedAssertion", enableEncryptedAssertion);
        String validateSignatureInRequests = String.valueOf(serviceProviderDO.isDoValidateSignatureInRequests());
        resource.addProperty("doValidateSignatureInRequests", validateSignatureInRequests);
        String validateSignatureInArtifactResolve = String.valueOf(serviceProviderDO.isDoValidateSignatureInArtifactResolve());
        resource.addProperty("doValidateSignatureInArtifactResolve", validateSignatureInArtifactResolve);
        if (StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier())) {
            resource.addProperty("SpQualifier", serviceProviderDO.getIssuerQualifier());
        }
        if (StringUtils.isNotBlank((String)serviceProviderDO.getIdpEntityIDAlias())) {
            resource.addProperty("IdPEntityIDAlias", serviceProviderDO.getIdpEntityIDAlias());
        }
        return resource;
    }

    private String getIssuerWithoutQualifier(String issuerWithQualifier) {
        String issuerWithoutQualifier = StringUtils.substringBeforeLast((String)issuerWithQualifier, (String)":urn:sp:qualifier:");
        return issuerWithoutQualifier;
    }

    private String getIssuerWithQualifier(String issuer, String qualifier) {
        String issuerWithQualifier = issuer + ":urn:sp:qualifier:" + qualifier;
        return issuerWithQualifier;
    }

    public SAMLSSOServiceProviderDO[] getServiceProviders() throws IdentityException {
        ArrayList<SAMLSSOServiceProviderDO> serviceProvidersList = new ArrayList<SAMLSSOServiceProviderDO>();
        try {
            Resource samlSSOServiceProvidersResource;
            if (this.registry.resourceExists("/repository/identity/SAMLSSO/") && (samlSSOServiceProvidersResource = this.registry.get("/repository/identity/SAMLSSO/")) instanceof Collection) {
                String[] resources;
                Collection samlSSOServiceProvidersCollection = (Collection)samlSSOServiceProvidersResource;
                for (String resource : resources = samlSSOServiceProvidersCollection.getChildren()) {
                    this.getChildResources(resource, serviceProvidersList);
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error reading Service Providers from Registry", (Throwable)e);
            throw IdentityException.error((String)"Error reading Service Providers from Registry", (Throwable)e);
        }
        return serviceProvidersList.toArray(new SAMLSSOServiceProviderDO[serviceProvidersList.size()]);
    }

    public boolean removeServiceProvider(String issuer) throws IdentityException {
        if (issuer == null || StringUtils.isEmpty((String)issuer.trim())) {
            throw new IllegalArgumentException("Trying to delete issuer '" + issuer + "'");
        }
        String path = "/repository/identity/SAMLSSO/" + this.encodePath(issuer);
        boolean isTransactionStarted = Transaction.isStarted();
        boolean isErrorOccurred = false;
        try {
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registry resource does not exist for the path: " + path));
                }
                boolean bl = false;
                return bl;
            }
            if (!isTransactionStarted) {
                this.registry.beginTransaction();
            }
            this.registry.delete(path);
            boolean bl = true;
            return bl;
        }
        catch (RegistryException e) {
            isErrorOccurred = true;
            String msg = "Error removing the service provider from the registry with name: " + issuer;
            log.error((Object)msg, (Throwable)e);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
        finally {
            this.commitOrRollbackTransaction(isErrorOccurred);
        }
    }

    public SAMLSSOServiceProviderDO getServiceProvider(String issuer) throws IdentityException {
        String path = "/repository/identity/SAMLSSO/" + this.encodePath(issuer);
        SAMLSSOServiceProviderDO serviceProviderDO = null;
        UserRegistry userRegistry = null;
        String tenantDomain = null;
        try {
            userRegistry = (UserRegistry)this.registry;
            tenantDomain = IdentityTenantUtil.getRealmService().getTenantManager().getDomain(userRegistry.getTenantId());
            if (this.registry.resourceExists(path)) {
                serviceProviderDO = this.resourceToObject(this.registry.get(path));
                if (serviceProviderDO.isDoValidateSignatureInRequests() || serviceProviderDO.isDoValidateSignatureInArtifactResolve() || serviceProviderDO.isDoEnableEncryptedAssertion()) {
                    Tenant tenant = new Tenant();
                    tenant.setDomain(tenantDomain);
                    tenant.setId(userRegistry.getTenantId());
                    serviceProviderDO.setX509Certificate(this.getApplicationCertificate(serviceProviderDO, tenant));
                }
                serviceProviderDO.setTenantDomain(tenantDomain);
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)("Error occurred while checking if resource path '" + path + "' exists in registry for tenant domain : " + tenantDomain), (Throwable)e);
        }
        catch (UserStoreException e) {
            throw IdentityException.error((String)("Error occurred while getting tenant domain from tenant ID : " + userRegistry.getTenantId()), (Throwable)e);
        }
        catch (SQLException e) {
            throw IdentityException.error((String)String.format("An error occurred while getting the application certificate id for validating the requests from the issuer '%s'", issuer), (Throwable)e);
        }
        catch (CertificateRetrievingException e) {
            throw IdentityException.error((String)String.format("An error occurred while getting the application certificate for validating the requests from the issuer '%s'", issuer), (Throwable)e);
        }
        return serviceProviderDO;
    }

    private X509Certificate getApplicationCertificate(SAMLSSOServiceProviderDO serviceProviderDO, Tenant tenant) throws SQLException, CertificateRetrievingException {
        String certificateIdentifier;
        CertificateRetriever certificateRetriever;
        int applicationCertificateId = this.getApplicationCertificateId(serviceProviderDO.getIssuer(), tenant.getId());
        if (applicationCertificateId != -1) {
            certificateRetriever = new DatabaseCertificateRetriever();
            certificateIdentifier = Integer.toString(applicationCertificateId);
        } else {
            certificateRetriever = new KeyStoreCertificateRetriever();
            certificateIdentifier = serviceProviderDO.getCertAlias();
        }
        return certificateRetriever.getCertificate(certificateIdentifier, tenant);
    }

    private int getApplicationCertificateId(String issuer, int tenantId) throws SQLException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection(false);
             PreparedStatement statementToGetApplicationCertificate = connection.prepareStatement(QUERY_TO_GET_APPLICATION_CERTIFICATE_ID);){
            statementToGetApplicationCertificate.setString(1, CERTIFICATE_PROPERTY_NAME);
            statementToGetApplicationCertificate.setString(2, issuer);
            statementToGetApplicationCertificate.setInt(3, tenantId);
            try (ResultSet queryResults = statementToGetApplicationCertificate.executeQuery();){
                if (queryResults.next()) {
                    int n = queryResults.getInt(1);
                    return n;
                }
            }
        }
        return -1;
    }

    public boolean isServiceProviderExists(String issuer) throws IdentityException {
        String path = "/repository/identity/SAMLSSO/" + this.encodePath(issuer);
        try {
            return this.registry.resourceExists(path);
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)("Error occurred while checking if resource path '" + path + "' exists in registry"));
        }
    }

    private String encodePath(String path) {
        String encodedStr = new String(Base64.encodeBase64((byte[])path.getBytes()));
        return encodedStr.replace("=", "");
    }

    public SAMLSSOServiceProviderDO uploadServiceProvider(SAMLSSOServiceProviderDO serviceProviderDO) throws IdentityException {
        if (serviceProviderDO == null || serviceProviderDO.getIssuer() == null) {
            throw new IdentityException("Issuer cannot be found in the provided arguments.");
        }
        if (StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier())) {
            serviceProviderDO.setIssuer(this.getIssuerWithQualifier(serviceProviderDO.getIssuer(), serviceProviderDO.getIssuerQualifier()));
        }
        if (serviceProviderDO.getDefaultAssertionConsumerUrl() == null) {
            throw new IdentityException("No default assertion consumer URL provided for service provider :" + serviceProviderDO.getIssuer());
        }
        String path = "/repository/identity/SAMLSSO/" + this.encodePath(serviceProviderDO.getIssuer());
        boolean isTransactionStarted = Transaction.isStarted();
        boolean isErrorOccurred = false;
        try {
            if (this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    if (StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier())) {
                        log.debug((Object)("SAML2 Service Provider already exists with the same issuer name " + this.getIssuerWithoutQualifier(serviceProviderDO.getIssuer()) + " and qualifier name " + serviceProviderDO.getIssuerQualifier()));
                    } else {
                        log.debug((Object)("SAML2 Service Provider already exists with the same issuer name " + serviceProviderDO.getIssuer()));
                    }
                }
                throw IdentityException.error((String)"A Service Provider already exists.");
            }
            if (!isTransactionStarted) {
                this.registry.beginTransaction();
            }
            Resource resource = this.createResource(serviceProviderDO);
            this.registry.put(path, resource);
            if (log.isDebugEnabled()) {
                if (StringUtils.isNotBlank((String)serviceProviderDO.getIssuerQualifier())) {
                    log.debug((Object)("SAML2 Service Provider " + serviceProviderDO.getIssuer() + " with issuer " + this.getIssuerWithoutQualifier(serviceProviderDO.getIssuer()) + " and qualifier " + serviceProviderDO.getIssuerQualifier() + " is added successfully."));
                } else {
                    log.debug((Object)("SAML2 Service Provider " + serviceProviderDO.getIssuer() + " is added successfully."));
                }
            }
            SAMLSSOServiceProviderDO sAMLSSOServiceProviderDO = serviceProviderDO;
            return sAMLSSOServiceProviderDO;
        }
        catch (RegistryException e) {
            isErrorOccurred = true;
            throw IdentityException.error((String)"Error while adding Service Provider.", (Throwable)e);
        }
        finally {
            this.commitOrRollbackTransaction(isErrorOccurred);
        }
    }

    private void commitOrRollbackTransaction(boolean isErrorOccurred) throws IdentityException {
        try {
            if (isErrorOccurred) {
                this.registry.rollbackTransaction();
            } else {
                this.registry.commitTransaction();
            }
        }
        catch (RegistryException ex) {
            throw new IdentityException("Error occurred while trying to commit or rollback the registry operation.", (Throwable)ex);
        }
    }

    private void getChildResources(String parentResource, List<SAMLSSOServiceProviderDO> serviceProviderList) throws RegistryException {
        if (this.registry.resourceExists(parentResource)) {
            Resource resource = this.registry.get(parentResource);
            if (resource instanceof Collection) {
                String[] resources;
                Collection collection = (Collection)resource;
                for (String res : resources = collection.getChildren()) {
                    this.getChildResources(res, serviceProviderList);
                }
            } else {
                serviceProviderList.add(this.resourceToObject(resource));
            }
        }
    }
}

