/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.dao.AbstractDAO;
import org.wso2.carbon.identity.core.model.ParameterDO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class ParameterDAO
extends AbstractDAO<ParameterDO> {
    protected static final Log log = LogFactory.getLog(ParameterDAO.class);

    public ParameterDAO(Registry registry) {
        this.registry = registry;
    }

    public void createOrUpdateParameter(ParameterDO parameterDO) throws IdentityException {
        String path = null;
        Resource resource = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating or updating parameter");
        }
        try {
            path = "/repository/identity/CardIssuer";
            resource = this.registry.resourceExists(path) ? this.registry.get(path) : this.registry.newResource();
            if (resource.getProperty(parameterDO.getName()) != null) {
                resource.removeProperty(parameterDO.getName());
            }
            resource.addProperty(parameterDO.getName(), parameterDO.getValue());
            this.registry.put(path, resource);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while creating or updating parameter", (Throwable)e);
            throw IdentityException.error((String)"Error while creating or updating parameter", (Throwable)e);
        }
    }

    public ParameterDO getParameter(String paramName) throws IdentityException {
        ParameterDO param = null;
        String path = null;
        Resource resource = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving parameter " + paramName));
        }
        try {
            path = "/repository/identity/CardIssuer";
            param = new ParameterDO();
            if (this.registry.resourceExists(path) && (resource = this.registry.get(path)) != null) {
                param.setName(paramName);
                param.setValue(resource.getProperty(paramName));
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retrieving parameter " + paramName), (Throwable)e);
            throw IdentityException.error((String)("Error while retrieving parameter " + paramName), (Throwable)e);
        }
        return param;
    }

    public void removeParameter(ParameterDO parameterDO) throws IdentityException {
        String path = null;
        Resource resource = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing parameter");
        }
        try {
            path = "/repository/identity/CardIssuer";
            if (this.registry.resourceExists(path) && (resource = this.registry.get(path)) != null) {
                resource.removeProperty(parameterDO.getName());
                this.registry.put(path, resource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while removing parameter", (Throwable)e);
            throw IdentityException.error((String)"Error while removing parameter", (Throwable)e);
        }
    }

    @Override
    protected ParameterDO resourceToObject(Resource resource) {
        return null;
    }
}

